#include <string.h>
#include "internal.h"
#include <netconf.h>


PRIVATE void FQHOST::init (const char *host)
{
	const char *pt = host;
	FQHOST_DECOMP *ptd = tb;
	strcpy (ptd->host,"@");
	strcpy (ptd->domain,host);
	ptd++;
	while ((pt = strchr(pt,'.'))!=NULL){
		int len = (int)(pt-host);
		memcpy (ptd->host,host,len);
		ptd->host[len] = '\0';
		strcpy (ptd->domain,pt+1);
		ptd++;
		pt++;
	}
	nbelm = (int)(ptd - tb);
}

static void qualify(
	const char *fqhost,
	char *full)
{
	char *pt = strchr(fqhost,'.');
	if (pt != NULL){
		strcpy (full,fqhost);
	}else{
		char domain[PATH_MAX];
		resolv_getdomain (domain);
		sprintf (full,"%s.%s",fqhost,domain);
	}
	int len = strlen(full)-1;
	if (len >= 0 && full[len] == '.') full[len] = '\0';
}

/*
	A FQHOST (Fully qualified host) is used to do
	different operation on a hostname, to find out if it
	is a member of a domain, to get its host part (relative
	to the domain etc...
*/
PUBLIC FQHOST::FQHOST(const char *host)
{
	char buf[200];
	qualify (host,buf);
	init (buf);
}
PUBLIC FQHOST::FQHOST(const SSTRING &host)
{
	char buf[200];
	qualify (host.get(),buf);
	init (buf);
}

PUBLIC FQHOST::FQHOST(const char *host, const char *domain)
{
	char buf[200];
	sprintf (buf,"%s.%s",host,domain);
	init (buf);
}

/*
	Return != 0 if the FQHOST is a member of this domain.
	(in fact, if there is a match, it return the number of
	 component in the host part).
*/
PUBLIC int FQHOST::is_member(
	const char *domain,
	char *hostpart)		// If not NULL, will contain the
				// host part matching this domain
				// so that hostpart.domain give
				// back the fully qualified hostname
{
	int ret = 0;
	if (hostpart != NULL) hostpart[0] = '\0';
	FQHOST_DECOMP *ptd = tb;
	for (int i=0; i<nbelm; i++, ptd++){
		/* #Specification: dnsconf / domain / case insensitive
			When trying to match domain name, dnsconf
			use case insensitive string compare.
		*/
		if (stricmp(ptd->domain,domain)==0){
			ret = i+1;
			if (hostpart != NULL) strcpy (hostpart,ptd->host);
			break;
		}
	}
	return ret;
}

/*
	Return != 0 if this domain name is a reverse address (x.y.z.in-addr.arpa)
*/
PUBLIC int FQHOST::is_reverse()
{
	return is_member ("in-addr.arpa",NULL)>0;
}


/*
	Get the host part that fit with this domain.
*/
PUBLIC const char *FQHOST::gethostpart(const char *domain)
{
	const char *ret = NULL;
	int no = is_member(domain,NULL);
	if (no > 0) ret = tb[no-1].host;
	return NULL;
}

/*
	Format the fully qualified (with a trailing dot)
*/
PUBLIC void FQHOST::formatfull(char *full)
{
	strcpy (full,tb[0].domain);
}

/*
	Format the fully qualified (with a trailing dot)
*/
PUBLIC void FQHOST::formatfull(SSTRING &full)
{
	char buf[200];
	formatfull(buf);
	full.setfrom (buf);
}

