#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <limits.h>
#include <sys/stat.h>
#include "netconf.h"
#include <popen.h>
#include "pppdial.h"
#include <fviews.h>
#include "dialout.m"
#include "dialout.h"
#include "../../paths.h"

extern HELP_FILE help_ppp;

static CONFIG_FILE f_pap_secrets (ETC_PPP_PAPSECRETS
	,help_ppp
	,CONFIGF_MANAGED
	,"root","root",0600,ppp_dialout);
static CONFIG_FILE f_chap_secrets (ETC_PPP_CHAPSECRETS
	,help_ppp
	,CONFIGF_MANAGED
	,"root","root",0600,ppp_dialout);

/*
	Set the path of the fifo used to allow the --postconnect process
	to tell to the waiting linuxconf that pppd has succeeded.
*/
PRIVATE void PPPONE::setfifowait(char *path)
{
	sprintf (path,"%s-%s.fifo",VAR_RUN_PPPD_WAIT,name.get());
}

/*
	Called both for on demand and manual connection
*/
PRIVATE int PPPONE::pppwait_cmd(const char *cmd)
{
	/* #Specification: netconf / --connect / return code
		When netconf establish a pppd connection, it wait for pppd
		to connect or fail. Once pppd has succeed or fail, netconf
		return an appropriate code. This allows this kind of usage

		#
		#!/bin/sh
		if netconf --connect config
		then
			echo succes
			do something with the net
			netconf --disconnect config
		else
			echo can\'t connect, you should try again
		fi
		#

		This works for both manual and on demand configuration.
	*/
	int ret = -1;
	POPEN po (cmd);
	int code;
	char fifo[PATH_MAX];
	setfifowait(fifo);
	int fd = -1;
	unlink (fifo);
	if (mknod (fifo,S_IFIFO | 0600,0)!=-1){
		fd = open (fifo,O_RDONLY|O_NDELAY,0);
		fcntl (fd,F_SETFL,O_RDONLY);
	}
	int count = 120;	// 2 minutes timeout
	while (count > 0 && (code=po.wait(1,fd))!=-1){
		while (1){
			char buf[5000];
			if (po.readout (buf,sizeof(buf)-1) != -1){
				strip_end (buf);
				printf ("%s\n",buf);
			}else if (po.readerr (buf,sizeof(buf)-1) != -1){
				strip_end (buf);
				fprintf (stderr,"%s\n",buf);
			}else{
				break;
			}
		}
		if ((code & 2) != 0){
			// We have received a signal from --postconnect
			// This is all what we need
			po.forget();	// Don't kill pppd when leaving
			ret = 0;
			break;
		}
		count--;
	}
	close (fd);
	unlink (fifo);
	return ret;
}


#if 0
/*
	Trigger a pppd command and wait for a connection succes
	or failure.
	Return a code appropriate
*/
PRIVATE int PPPONE::pppwait(
	const char *pppdpath,
	const char *filepath)	// Argument for pppd
{
	char buf[200];
	sprintf (buf,"%s file %s",pppdpath,filepath);
	return pppwait_cmd (buf);
}
#endif
static int pppwait_updsecrets (
	CONFIG_FILE &conf,
	const char *config_name,
	const char *login,
	const char *passwd,
	PRIVILEGE *priv)
{
	int ret = 0;
	VIEWITEMS items;
	items.read (conf);
	int n = items.getnb();
	bool found = false;
	bool modified = false;
	for (int i=0; i<n; i++){
		VIEWITEM *it = items.getitem(i);
		char word1[100],word2[100],word3[100];
		const char *pt = it->line.get();
		pt = str_copyword (word1,pt,100);
		pt = str_copyword (word2,pt,100);
		str_copyword (word3,pt,100);
		if (strncmp(word2,"lnx-",4)==0
			&& strcmp(word2+4,config_name)==0){
			found = true;
			if (strcmp(word1,login)!=0
				|| strcmp (word3,passwd)!=0){
				modified = true;
				char line[100];
				snprintf (line,sizeof(line)-1,"%s lnx-%s %s *"
					,login,config_name,passwd);
				it->line.setfrom (line);
			}
			break;
		}
	}
	if (!found){
		char line[100];
		SSTRING comment;
		comment.setfrom ("# ");
		comment.append (MSG_U(I_ADDBYLNX,"Added by linuxconf"));
		snprintf (line,sizeof(line)-1,"%s lnx-%s %s *",login,config_name,passwd);
		items.add (new VIEWITEM(comment.get(),VIEWITEM_COMMENT));
		items.add (new VIEWITEM(line));
		modified = true;
	}
	if (modified){
		net_prtlog (NETLOG_CMD,MSG_U(I_UPDPAP,"Updating file %s for PPP configuration %s\n")
			,conf.getpath(),config_name);
		items.write (conf,priv);
	}
	return ret;
}

/*
	Update the file pap-secrets and chap-secrets if needed
*/
PRIVATE int PPPONE::updsecrets(PRIVILEGE *priv)
{
	int ret = pppwait_updsecrets (f_pap_secrets,name.get(),login.get()
		,passwd.get(),priv);
	ret |= pppwait_updsecrets (f_chap_secrets,name.get(),login.get()
		,passwd.get(),priv);
	return ret;
}

