#!/bin/sh
# This script is used to format the documentation for
# the functions, specifications and classes of a directory
# It requires a guide file to tell how the information must be
# layed out. You need the linuxconf-tools package to make use of that
if [ $# -lt 2 ] ; then
	echo publish_spec.sh guide_file base_name_of_output_file base_html_path subdir
else
	export LANG=en
	tlproto -ceo+d -f/tmp/tmp.nap -q/tmp/tmp.cls *.h \
		`find . -maxdepth 1 -name \*.cc -o -name \*.tlcc`
	nadoc -a"Linuxconf team" -p -g $1 /tmp/tmp.nap /tmp/$2.sgml
	(cd /tmp && sgml2html $2.sgml)
	(cd /tmp && /usr/lib/linuxconf-tools/crossref $2*.html >$2.xref)
	nadoc -a"Linuxconf team" -x/tmp/$2.xref -p -g $1 /tmp/tmp.nap /tmp/$2.sgml
	../doc/update_global_xref.sh $2 /$4/$2
	(cd /tmp && sgml2html $2.sgml)
	if [ "$3" != "" -a "$4" != "" ] ; then
		echo Updating $3/$4/$2
		rm -fr $3/$4/$2
		mkdir -p $3/$4/$2
		# bug with virtualfs, mv fails because of utimes
		#mv /tmp/$2*.html $3/$4/$2
		bigcp -v /tmp/$2*.html $3/$4/$2/. && rm /tmp/$2*.html
		(cd $3/$4/$2 && cp $2.html index.html)
		if [ "$5" != "" ] ; then
			rm -fr $5/$4/$2
			mkdir -p $5/$4/$2
			cp -a $3/$4/$2/. $5/$4/$2/.
		fi
	fi
fi

