#!/bin/sh
# This script try to stuff linuxconf base configuration out
# of caldera specific configuration files
echo Probing Caldera specific information
echo
. /etc/sysconfig/network
if [ "$NETWORKING" = "yes" ] ; then
	echo Networking is enabled
	if [ "$DEVICE" = "" -a -f /etc/sysconfig/network-scripts/ifcfg-eth0 ]
	then
		DEVICE=eth0
	fi
	if [ "$DEVICE" != "" ] ; then
		echo "Main network device  is" $DEVICE
		. /etc/sysconfig/network-scripts/ifcfg-$DEVICE
		if [ "$DEVICE" = "" ] ; then
			echo No main network device
			netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
		else
			echo "Setting hostname     to" $HOSTNAME
			echo "Setting IP address   to" $IPADDR
			echo "Setting netmask      to" $NETMASK
			netconf --setdevdef 0 $HOSTNAME $IPADDR $NETMASK $DEVICE
			if [ "$GATEWAY" != ""  -a "$GATEWAY" != "localhost" ] ; then
				netconf --setgateway $GATEWAY
				echo "Setting gateway      to" $GATEWAY
			fi
		fi
	else
		echo No main network device
		netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
	fi
else
	echo Networking disabled
	netconf --setdevdef 0 $HOSTNAME 127.0.0.1 "" ""
fi

. /etc/sysconfig/clock
if [ "$CLOCKMODE" != "" ] ; then
	echo "CMOS clock mode set  to" $CLOCKMODE
	netconf --setclockmode $CLOCKMODE
else
	echo "CMOS clock mode set  to" local
	netconf --setclockmode local
fi

if [ -f /etc/sysconfig/keyboard ] ; then
	. /etc/sysconfig/keyboard
	if [ "$KEYTABLE" = "" ] ; then
		echo No keytable defined
	else
		echo Keyboard mapping set to $KEYTABLE
		linuxconf --setkeymap $KEYTABLE
	fi
fi

