#pragma implementation
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <misc.h>
#include <time.h>
#include <configf.h>
#include <dialog.h>
#include <translat.h>
#include "builder.m"
#include "builder.h"

static HELP_FILE help_builder ("builder","builder");
static HELP_FILE help_newmod  ("builder","newmod");
static HELP_FILE help_editmod ("builder","editmod");


static void builder_edit (const char *path)
{
	chdir (path);
	BUILDMOD mod;
	mod.edit ();
}

static void builder_populate (const char *path)
{
}

static void builder_newmod()
{
	DIALOG dia;
	SSTRING name;
	dia.newf_str (MSG_U(F_MODNAME,"Module name"),name);
	dia.last_noempty();
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_NEWMOD,"New module")
			,MSG_U(I_NEWMOD
				,"Enter the module name.\n"
				 "A sub-directory will be created with that name\n"
				 "and populated appropriatly")
			,help_newmod
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (file_type(name.get())!=-1){
			xconf_error (MSG_U(E_DIREXIST
				,"A directory or file already exist with that name\n"
				 "Please pick another"));
		}else{
			builder_populate(name.get());
			builder_edit (name.get());
		}
	}
}

static void builder_editmod()
{
	DIALOG dia;
	SSTRING name;
	dia.newf_str (MSG_R(F_MODNAME),name);
	dia.last_noempty();
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_EDITMOD,"Edit a module")
			,MSG_U(I_EDITMOD
				,"Enter the module name you wish to enhance")
			,help_editmod
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (file_type(name.get())!=1){
			xconf_error (MSG_U(E_NODIR
				,"No directory exists with that name\n"
				 "Please pick another"));
		}else{
			builder_edit (name.get());
		}
	}
}

int main (int argc, char *argv[])
{
	translat_load ("/usr/lib/builder/help","builder", "eng");
	html_registerpath ("/usr/lib/builder");
	DIALOG_MENU dia;
	static const char *newmod = MSG_U(M_NEWMOD,"Create a new module");
	static const char *editmod = MSG_U(M_EDITMOD,"Edit/enhance a module");
	static const char *menuopt[]={
		"",		newmod,
		"",		editmod,
		NULL
	};
	dia.new_menuitems (menuopt);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_BUILDER,"Module builder")
			,MSG_U(I_BUILDER
				,"This utility lets you create and enhance\n"
				 "Linuxconf modules.")
			,help_builder
			,nof,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *sel = dia.getmenustr (nof);
			if (sel == newmod){
				builder_newmod();
			}else if (sel == editmod){
				builder_editmod();
			}
		}
	}
	return 0;
}

