#define _GNU_SOURCE

#include "stringf.h"

#include <stdio.h>
#include <stdarg.h>

int stringf::addf(std::string& str, const char* fmt, ...) throw() ATTR_PRINTF(2, 3)
{
	char *buf;
	va_list ap;
	va_start(ap, fmt);
	int res = vasprintf(&buf, fmt, ap);
	va_end(ap);
	str += buf;
	free(buf);
	return res;
}

std::string stringf::fmt(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	char *buf;
	va_list ap;
	va_start(ap, fmt);
	vasprintf(&buf, fmt, ap);
	va_end(ap);
	std::string res(buf);
	free(buf);
	return res;
}

std::string stringf::fmt(int val) throw() { return fmt("%i", val); }
std::string stringf::fmt(unsigned int val) throw() { return fmt("%u", val); }
std::string stringf::fmt(long int val) throw() { return fmt("%li", val); }
std::string stringf::fmt(long unsigned int val) throw() { return fmt("%lu", val); }

// vim:set ts=4 sw=4:
