//LabPlot : RichTextWidget.h

#ifndef RICHTEXTWIDGET_H
#define RICHTEXTWIDGET_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <klineedit.h>
#include <kpopupmenu.h>
#include <kcolorbutton.h>
#include "Worksheet.h"
#include "Label.h"

class QComboBox;
class KPushButton;

class RichTextWidget: public QWidget
{
	Q_OBJECT
public:
	RichTextWidget(QWidget *parent, Label *label, const char *name, bool qwtplot=0);
	~RichTextWidget();
public slots:
	void setLabel(Label *label) { l = label; update(); }
	Label* getLabel() { apply(); return l; }
	Label* label() { return getLabel(); }
	void setPostionReadOnly(bool r=true) {xle->setReadOnly(r); yle->setReadOnly(r); }
	void update();
private slots:
	void selectFont();
	void setTEColor();
	void toggleBold();
	void toggleItalic();
	void toggleUnderline();
	void toggleSuperscript();
	void toggleSubscript();
	void insertChar(int ch);
	void insertGChar(int ch);
	void boxedChanged(bool b) { l->setBoxed(b); }
	void texChanged(bool b);
private:
	void apply();
	Label *l;
	QFont greek;
	QTextEdit *te;
	KLineEdit *xle, *yle, *titleFont, *rotle;
	KPushButton *newtitleFont;
	QToolButton *bold, *italic, *underline, *superscript, *subscript;
	KPopupMenu *sgletters, *bgletters, *oletters;
	KColorButton *kcb, *bgcolor;
	QCheckBox *boxedcb, *texcb, *transcb;
};

#endif //RICHTEXTWIDGET_H
