//LabPlot : PlotSettingsDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qradiobutton.h>
#include <klocale.h>
#include <kconfig.h>
#include "PlotSettingsDialog.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotQWT3D.h"
#include "ColormapReader.h"
#include "qwt3d.h"
#include "defs.h"

//! class for general plot settings
PlotSettingsDialog::PlotSettingsDialog(MainWin *m, const char *name)
	: Dialog(m, name)
{
	kdDebug()<<"PlotSettingsDialog()"<<endl;
	setCaption(i18n("Plot Settings")+i18n(" : ")+QString(name));

	// get type
	p = mw->activeWorksheet();
	if(p == 0) {
		kdDebug()<<"WARNING : worksheet == 0!"<<endl;
		return;
	}
	plot = p->getPlot(p->API());
	if(plot == 0) {
		kdDebug()<<"WARNING : plot == 0!"<<endl;
		 return;
	}
	type = plot->Type();

	QTabWidget *tw;
	QHBox *hb;
	KConfig *config = mw->Config();
	config->setGroup( "Plot" );
	tw = new QTabWidget(vbox);
	if(type != PQWT3D) {
		QVBox *tab1 = new QVBox(tw);
		hb = new QHBox(tab1);
		aspect = new QCheckBox(i18n("Aspect Ratio"),hb);
		if(type == P3D)
			render = new QCheckBox(i18n("3D Rendering"),hb);
		hb = new QHBox(tab1);
		new QLabel(i18n("Plot Position : "),hb);
		posx = new KLineEdit("",hb);
		posx->setValidator(new QDoubleValidator(0,1,3,posx));
		new QLabel(i18n(" , "),hb);
		posy = new KLineEdit("",hb);
		posy->setValidator(new QDoubleValidator(0,1,3,posy));
		hb = new QHBox(tab1);
		new QLabel(i18n("Plot Size : "),hb);
		sizex = new KLineEdit("",hb);
		sizex->setValidator(new QDoubleValidator(0,1,3,sizex));
		new QLabel(i18n(" , "),hb);
		sizey = new KLineEdit("",hb);
		sizey->setValidator(new QDoubleValidator(0,1,3,sizey));
		hb = new QHBox(tab1);
		new QLabel(i18n("Panel : "),hb);
		leftpanel = new QCheckBox(i18n("Left"),hb);
		if(config->readNumEntry("Panel",0) == 1) leftpanel->setChecked(true);
		rightpanel = new QCheckBox(i18n("Right"),hb);
		if(config->readNumEntry("Panel",0) == 2) rightpanel->setChecked(true);
		toppanel = new QCheckBox(i18n("Top"),hb);
		if(config->readNumEntry("Panel",0) == 3) toppanel->setChecked(true);
		bottompanel = new QCheckBox(i18n("Bottom"),hb);
		if(config->readNumEntry("Panel",0) == 4) bottompanel->setChecked(true);
		tw->addTab(tab1,i18n("Main"));

		QVBox *tab2 = new QVBox(tw);
		hb = new QHBox(tab2);
		KPushButton *asx = new KPushButton(i18n("Autoscale x"),hb);
		QObject::connect(asx,SIGNAL(clicked()),mw,SLOT(autoScaleX()));
		KPushButton *asy = new KPushButton(i18n("Autoscale y"),hb);
		QObject::connect(asy,SIGNAL(clicked()),mw,SLOT(autoScaleY()));
		if (type == P3D) {
			KPushButton *asz = new KPushButton(i18n("Autoscale z"),hb);
			QObject::connect(asz,SIGNAL(clicked()),mw,SLOT(autoScaleZ()));
		}
		hb = new QHBox(tab2);
		new QLabel(i18n("x = "),hb);
		xmin = new KLineEdit("",hb);
		xmin->setValidator(new QDoubleValidator(xmin));
		new QLabel(i18n(" .. "),hb);
		xmax = new KLineEdit("",hb);
		xmax->setValidator(new QDoubleValidator(xmax));
		hb = new QHBox(tab2);
		new QLabel(i18n("y = "),hb);
		ymin = new KLineEdit("",hb);
		ymin->setValidator(new QDoubleValidator(ymin));
		new QLabel(i18n(" .. "),hb);
		ymax = new KLineEdit("",hb);
		ymax->setValidator(new QDoubleValidator(ymax));

		if (type == P3D) {
			hb = new QHBox(tab2);
			new QLabel(i18n("z = "),hb);
			zmin = new KLineEdit("",hb);
			zmin->setValidator(new QDoubleValidator(zmin));
			new QLabel(i18n(" .. "),hb);
			zmax = new KLineEdit("",hb);
			zmax->setValidator(new QDoubleValidator(zmax));
		}

		hb = new QHBox(tab2);
		new QLabel(i18n("clipping offset : "),hb);
		clipni = new KIntNumInput(0,hb);
		clipni->setRange(0,INF,1,false);
		tw->addTab(tab2,i18n("Ranges"));
	}

	QVBox *tab3 = new QVBox(tw);
	hb = new QHBox(tab3);
	transparentcb = new QCheckBox(i18n("transparent plot"),hb);

	hb = new QHBox(tab3);
	new QLabel(i18n("Background Color : "),hb);
	bgcolor = new KColorButton(Qt::white,hb);
	QObject::connect(bgcolor,SIGNAL(changed(const QColor &)),this,SLOT(bgColorChanged()));
	hb = new QHBox(tab3);
	new QLabel(i18n("    Brush : "),hb);
	bgbrushcb = new KComboBox(hb);
	fillBrushBox(bgbrushcb,SRECT,Qt::black,FFULL,Qt::white);
	bgbrushcb->setCurrentItem(Qt::SolidPattern);

	hb = new QHBox(tab3);
	new QLabel(i18n("Graph Background Color : "),hb);
	gbgcolor = new KColorButton(Qt::white,hb);
	QObject::connect(gbgcolor,SIGNAL(changed(const QColor &)),this,SLOT(gbgColorChanged()));
	hb = new QHBox(tab3);
	new QLabel(i18n("    Brush : "),hb);
	gbgbrushcb = new KComboBox(hb);
	fillBrushBox(gbgbrushcb,SRECT,Qt::black,FFULL,Qt::white);
	gbgbrushcb->setCurrentItem(Qt::SolidPattern);
	tw->addTab(tab3,i18n("Background"));

	if(type != PQWT3D) {
		QVBox *tab4 = new QVBox(tw);
		hb = new QHBox(tab4);
		xbaselinecb = new QCheckBox(i18n("draw X Baseline "),hb);
		new QLabel(i18n("Baseline @ x = "),hb);
		xbaselinele = new KLineEdit("",hb);
		xbaselinele->setValidator(new QDoubleValidator(xbaselinele));

		hb = new QHBox(tab4);
		baselinecb = new QCheckBox(i18n("draw Y Baseline "),hb);
		new QLabel(i18n("Baseline @ y = "),hb);
		baselinele = new KLineEdit("",hb);
		baselinele->setValidator(new QDoubleValidator(baselinele));

		hb = new QHBox(tab4);
		regioncb = new QCheckBox(i18n("draw Region "),hb);
		new QLabel(i18n("x = "),hb);
		regionminle = new KLineEdit("",hb);
		regionminle->setValidator(new QDoubleValidator(regionminle));
		new QLabel(i18n(" .. "),hb);
		regionmaxle = new KLineEdit("",hb);
		regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
		tw->addTab(tab4,i18n("Baseline/Region"));

		QVBox *tab5 = new QVBox(tw);
		hb = new QHBox(tab5);
		markercb = new QCheckBox(i18n("show Marker "),hb);
		hb = new QHBox(tab5);
		new QLabel(i18n("x1 = "),hb);
		markxminle = new KLineEdit("",hb);
		markxminle->setValidator(new QDoubleValidator(markxminle));
		new QLabel(i18n(" x2 = "),hb);
		markxmaxle = new KLineEdit("",hb);
		markxmaxle->setValidator(new QDoubleValidator(markxmaxle));
		hb = new QHBox(tab5);
		new QLabel(i18n("y1 = "),hb);
		markyminle = new KLineEdit("",hb);
		markyminle->setValidator(new QDoubleValidator(markyminle));
		new QLabel(i18n(" y2 = "),hb);
		markymaxle = new KLineEdit("",hb);
		markymaxle->setValidator(new QDoubleValidator(markymaxle));
		tw->addTab(tab5,i18n("Marker"));

		if(type == P2D) {
			QVBox *tab6 = new QVBox(tw);
			hb = new QHBox(tab6);
			fillcb = new QCheckBox(i18n("enable Fill"),hb);

			hbg = new QHButtonGroup(hb,0);
			hbg->setRadioButtonExclusive(true);
			hbg->hide();
			QRadioButton *rb;
			rb = new QRadioButton(i18n("all"),hb);
			rb->setChecked(true);
			hbg->insert(rb);
			rb = new QRadioButton(i18n("higher"),hb);
			hbg->insert(rb);
			rb = new QRadioButton(i18n("lower"),hb);
			hbg->insert(rb);
			rb = new QRadioButton(i18n("region"),hb);
			hbg->insert(rb);

			hb = new QHBox(tab6);
			new QLabel(i18n("First Graph : "),hb);
			fillg1le = new KLineEdit("",hb);
			fillg1le->setValidator(new QIntValidator(1,1000,fillg1le));
			new QLabel(i18n("Second Graph : "),hb);
			fillg2le = new KLineEdit("",hb);
			fillg2le->setValidator(new QIntValidator(1,1000,fillg2le));

			hb = new QHBox(tab6);
			new QLabel(i18n(" Color : "),hb);
			fillcolorcb = new KColorButton(Qt::red,hb);
			QObject::connect(fillcolorcb,SIGNAL(changed(const QColor &)),this,SLOT(fillColorChanged()));

			hb = new QHBox(tab6);
			new QLabel(i18n(" Brush : "),hb);
			fillbrushcb = new KComboBox(hb);
			fillColorChanged();

			tw->addTab(tab6,i18n("Fill"));
			QVBox *tab7 = new QVBox(tw);
			hb = new QHBox(tab7);
			new QLabel(i18n(" Color : "),hb);
			datamodecolorcb = new KColorButton(mw->DataModeColor(),hb);
			hb = new QHBox(tab7);
			new QLabel(i18n(" Graph for Data Mode : "),hb);
			datamodegraphcb = new KComboBox(hb);
			for(unsigned int i=0;i<plot->getGraphList()->Number();i++)
				datamodegraphcb->insertItem(plot->getGraphList()->getGraph(i)->getLabel()->simpleTitle());
			datamodegraphcb->setCurrentItem(plot->DataModeGraph());

			tw->addTab(tab7,i18n("DataMode"));
		}
	}
#ifdef HAVE_GL
	else {
		int i=0;

		QVBox *tab4 = new QVBox(tw);

		hb = new QHBox(tab4);
		disablemousecb = new QCheckBox(i18n("disable mouse"),hb);
		new QLabel(i18n(" resolution = "),hb);
		resolutionle = new KLineEdit("",hb);
		resolutionle->setValidator(new QIntValidator(1,1000,resolutionle));

		hb = new QHBox(tab4);
		new QLabel(i18n("Aspect ration "),hb);
		aspectcb = new KComboBox(hb);
		while(aspectRatio[i] != 0) aspectcb->insertItem(i18n(aspectRatio[i++]));

		hb = new QHBox(tab4);
		new QLabel(i18n("Plot Style : "),hb);
		plotstyle = new KComboBox(hb);
		i=0;
		while(plotStyle[i] != 0) plotstyle->insertItem(i18n(plotStyle[i++]));

		hb = new QHBox(tab4);
		new QLabel(i18n("Coordinate Style : "),hb);
		coordinatestyle = new KComboBox(hb);
		i=0;
		while(coordinateStyle[i] != 0) coordinatestyle->insertItem(i18n(coordinateStyle[i++]));

		hb = new QHBox(tab4);
		new QLabel(i18n("Floor Style : "),hb);
		floorstyle = new KComboBox(hb);
		i=0;
		while(floorStyle[i] != 0) floorstyle->insertItem(i18n(floorStyle[i++]));

		hb = new QHBox(tab4);
		new QLabel(i18n("isolines = "),hb);
		isolines = new KLineEdit("",hb);
		isolines->setValidator(new QIntValidator(isolines));

		hb = new QHBox(tab4);
		KPushButton *colormap = new KPushButton(i18n("Colormap"),hb);
		QObject::connect(colormap,SIGNAL(clicked()),SLOT(selectColormap()));
		tw->addTab(tab4,i18n("Style"));
	}
#endif

	kdDebug()<<"TYPE = "<<type<<endl;
	if (type == PSURFACE) {
		QVBox *styletab = surfaceStyle(tw,true);
		tw->addTab(styletab,i18n("Style"));
	}

	updateDialog();

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth((int)(1.8*tw->minimumSizeHint().width()));
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PlotSettingsDialog::bgColorChanged() {
	int brush = bgbrushcb->currentItem();
	bgbrushcb->clear();
	// Qt : number of different brush styles
	int BRUSHNR=15;
	for (int i=0;i<BRUSHNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
		pa.begin( &pm );

		Symbol symbol(SRECT,Qt::black,10,FFULL,bgcolor->color(),i);
		symbol.draw(&pa,15,15);
		pa.end();

		bgbrushcb->insertItem(pm);
	}
	bgbrushcb->setCurrentItem(brush);
}

void PlotSettingsDialog::gbgColorChanged() {
	int brush = gbgbrushcb->currentItem();
	gbgbrushcb->clear();
	// Qt : number of different brush styles
	int BRUSHNR=15;
	for (int i=0;i<BRUSHNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
		pa.begin( &pm );

		Symbol symbol(SRECT,Qt::black,10,FFULL,gbgcolor->color(),i);
		symbol.draw(&pa,15,15);
		pa.end();

		gbgbrushcb->insertItem(pm);
	}
	gbgbrushcb->setCurrentItem(brush);
}

void PlotSettingsDialog::fillColorChanged() {
	int brush = fillbrushcb->currentItem();
	fillbrushcb->clear();
	// Qt : number of different brush styles
	int BRUSHNR=15;
	for (int i=0;i<BRUSHNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
		pa.begin( &pm );

		Symbol symbol(SRECT,Qt::black,10,FFULL,fillcolorcb->color(),i);
		symbol.draw(&pa,15,15);
		pa.end();

		fillbrushcb->insertItem(pm);
	}
	fillbrushcb->setCurrentItem(brush);
}

void PlotSettingsDialog::updateDialog() {
	kdDebug()<<"PlotSettingsDialog::updateDialog()"<<endl;
	p = mw->activeWorksheet();
	if(p == 0) {
		kdDebug()<<"WARNING: worksheet==0!"<<endl;
		return;
	}
	plot = p->getPlot(p->API());
	if(plot == 0) {
		kdDebug()<<"WARNING: plot==0! API="<<p->API()<<endl;
		return;
	}
	type = plot->Type();

	if(type != PQWT3D) {
		aspect->setChecked(plot->AspectRatioEnabled());
		if (type == P3D)
			render->setChecked(((Plot3D *) plot)->RenderStyle());
		posx->setText(QString::number(plot->Position().X()));
		posy->setText(QString::number(plot->Position().Y()));
		sizex->setText(QString::number(plot->Size().X()));
		sizey->setText(QString::number(plot->Size().Y()));

		LRange *r = plot->ActRanges();
		xmin->setText(QString::number(r[0].rMin()));
		xmax->setText(QString::number(r[0].rMax()));
		ymin->setText(QString::number(r[1].rMin()));
		ymax->setText(QString::number(r[1].rMax()));
		if (type == P3D) {
			zmin->setText(QString::number(r[2].rMin()));
			zmax->setText(QString::number(r[2].rMax()));
		}
		clipni->setValue(plot->ClipOffset());
	}

	transparentcb->setChecked(plot->Transparent());
	bgcolor->setColor(plot->Background().color());
	bgbrushcb->setCurrentItem(plot->Background().style());
	gbgcolor->setColor(plot->graphBackground().color());
	gbgbrushcb->setCurrentItem(plot->graphBackground().style());

	if(type != PQWT3D) {
		xbaselinecb->setChecked(plot->XBaselineEnabled());
		xbaselinele->setText(QString::number(plot->XBaseline()));
		baselinecb->setChecked(plot->BaselineEnabled());
		baselinele->setText(QString::number(plot->Baseline()));
		regioncb->setChecked(plot->regionEnabled());
		regionminle->setText(QString::number(plot->RegionMin()));
		regionmaxle->setText(QString::number(plot->RegionMax()));
		markercb->setChecked(plot->marksEnabled());
		markxminle->setText(QString::number(plot->markX()->rMin()));
		markxmaxle->setText(QString::number(plot->markX()->rMax()));
		markyminle->setText(QString::number(plot->markY()->rMin()));
		markymaxle->setText(QString::number(plot->markY()->rMax()));

		if(type == P2D) {
			fillcb->setChecked(plot->Fill());
			hbg->setButton(plot->FillType());
			fillg1le->setText(QString::number(plot->FillG1()));
			fillg2le->setText(QString::number(plot->FillG2()));
			QBrush fillbrush = plot->FillBrush();
			fillcolorcb->setColor(fillbrush.color());
			fillbrushcb->setCurrentItem((int) fillbrush.style());
		}
	}
#ifdef HAVE_GL
	else {
		disablemousecb->setChecked(((PlotQWT3D *)plot)->mouseDisabled());
		// need to be disabled on MacOSX ???
		resolutionle->setText(QString::number(((PlotQWT3D *)plot)->Resolution()));
		aspectcb->setCurrentItem(((PlotQWT3D *) plot)->aspectRatio());
		plotstyle->setCurrentItem(((PlotQWT3D *) plot)->PlotStyle());
		coordinatestyle->setCurrentItem(((PlotQWT3D *) plot)->CoordinateStyle());
		floorstyle->setCurrentItem(((PlotQWT3D *) plot)->FloorStyle());
		isolines->setText(QString::number(((PlotQWT3D *) plot)->isolines()));
	}
#endif
}

void PlotSettingsDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Plot" );

	config->writeEntry("AspectRatio",aspect->isChecked());
	config->writeEntry("Position X",posx->text());
	config->writeEntry("Position Y",posy->text());
	config->writeEntry("Size X",sizex->text());
	config->writeEntry("Size Y",sizey->text());
	int panel=0;
	if(leftpanel->isChecked()) panel=1;
	if(rightpanel->isChecked()) panel=2;
	if(toppanel->isChecked()) panel=3;
	if(bottompanel->isChecked()) panel=4;
	config->writeEntry("Panel",panel);

	config->writeEntry("ClipOffset",clipni->value());
	config->writeEntry("Transparent",transparentcb->isChecked());
	config->writeEntry("BackgroundColor",bgcolor->color());
	config->writeEntry("BackgroundBrush",(int)bgbrushcb->currentItem());
	config->writeEntry("GraphBackgroundColor",gbgcolor->color());
	config->writeEntry("GraphBackgroundBrush",(int)gbgbrushcb->currentItem());

	config->writeEntry("XBaselineEnabled",xbaselinecb->isChecked());
	config->writeEntry("XBaseline",xbaselinele->text().toDouble());
	config->writeEntry("YBaselineEnabled",baselinecb->isChecked());
	config->writeEntry("YBaseline",baselinele->text().toDouble());
	config->writeEntry("RegionEnabled",regioncb->isChecked());
	config->writeEntry("RegionMin",regionminle->text().toDouble());
	config->writeEntry("RegionMax",regionmaxle->text().toDouble());
	config->writeEntry("MarkerEnabled",markercb->isChecked());
	config->writeEntry("MarkerXMin",markxminle->text().toDouble());
	config->writeEntry("MarkerXMax",markxmaxle->text().toDouble());
	config->writeEntry("MarkerYMin",markyminle->text().toDouble());
	config->writeEntry("MarkerYMax",markymaxle->text().toDouble());

	config->writeEntry("FillEnabled",fillcb->isChecked());
#if QT_VERSION > 0x030102
	config->writeEntry("FillType",hbg->selectedId());
#endif
	config->writeEntry("FillG1",fillg1le->text().toInt());
	config->writeEntry("FillG2",fillg2le->text().toInt());
	config->writeEntry("FillColor",fillcolorcb->color());
	config->writeEntry("FillBrush",fillbrushcb->currentItem());

}

int PlotSettingsDialog::apply_clicked() {
	kdDebug()<<"PlotSettingsDialog::apply()"<<endl;
	if(plot == 0) {
		kdDebug()<<"WARNING : plot == 0!"<<endl;
		return -1;
	}
	plot->setBackground(QBrush(bgcolor->color(),(Qt::BrushStyle)bgbrushcb->currentItem()));
	plot->setGraphBackground(QBrush(gbgcolor->color(),(Qt::BrushStyle)gbgbrushcb->currentItem()));
	plot->setTransparent(transparentcb->isChecked());

	if(type != PQWT3D) {
		if (type == P3D)
			((Plot3D *)plot)->setRenderStyle(render->isChecked());
		plot->setPosition(posx->text().toDouble(),posy->text().toDouble());
		plot->setSize(sizex->text().toDouble(),sizey->text().toDouble());
		plot->enableAspectRatio(aspect->isChecked());
		if(leftpanel->isChecked()) plot->setLeftPanel();
		if(rightpanel->isChecked()) plot->setRightPanel();
		if(toppanel->isChecked()) plot->setTopPanel();
		if(bottompanel->isChecked()) plot->setBottomPanel();

		plot->setClipOffset(clipni->value());
		plot->setXRange(xmin->text().toDouble(),xmax->text().toDouble());
		plot->setYRange(ymin->text().toDouble(),ymax->text().toDouble());
		if (type == P3D)
			plot->setZRange(zmin->text().toDouble(),zmax->text().toDouble());

		if (type == PSURFACE) {
			((Plot2DSurface* )plot)->enableDensity(dcb->isChecked());
			((Plot2DSurface* )plot)->enableContour(ccb->isChecked());
			((Plot2DSurface* )plot)->setNumber(numberle->text().toInt());
			((Plot2DSurface* )plot)->setContourColor(contourcolor->color());
			((Plot2DSurface* )plot)->setColoredContour(coloredcb->isChecked());
			((Plot2DSurface* )plot)->setMesh(meshcb->isChecked());
			((Plot2DSurface* )plot)->setRelative(relativecb->isChecked());
			((Plot2DSurface* )plot)->setBrush(dbrushcb->currentItem());
			((Plot2DSurface* )plot)->setThreshold(thresholdle->text().toDouble());
		}

		plot->setBaseline(baselinele->text().toDouble());
		plot->setBaselineEnabled(baselinecb->isChecked());
		plot->setXBaseline(xbaselinele->text().toDouble());
		plot->setXBaselineEnabled(xbaselinecb->isChecked());

		plot->setRegionMin(regionminle->text().toDouble());
		plot->setRegionMax(regionmaxle->text().toDouble());
		plot->setRegionEnabled(regioncb->isChecked());

		plot->setMarksEnabled(markercb->isChecked());
		LRange *xrange = new LRange(markxminle->text().toDouble(),markxmaxle->text().toDouble());
		LRange *yrange = new LRange(markyminle->text().toDouble(),markymaxle->text().toDouble());
		plot->setMarkX(xrange);
		plot->setMarkY(yrange);
		if(type == P2D) {
			plot->setFill(fillcb->isChecked());
#if QT_VERSION > 0x030102
			plot->setFillType(hbg->selectedId());
#endif
			plot->setFillG1(fillg1le->text().toInt());
			plot->setFillG2(fillg2le->text().toInt());
			QColor fillcolor = fillcolorcb->color();
			int fillbrush = fillbrushcb->currentItem();
			plot->setFillBrush(QBrush(fillcolor,(Qt::BrushStyle) fillbrush));
			plot->setDataModeGraph(datamodegraphcb->currentItem());
			mw->setDataModeColor(datamodecolorcb->color());
		}
	}
#ifdef HAVE_GL
	else {	// PQWT3D
		((PlotQWT3D *) plot)->setPlotStyle((Qwt3D::PLOTSTYLE) plotstyle->currentItem());
		((PlotQWT3D *) plot)->setCoordinateStyle((Qwt3D::COORDSTYLE) coordinatestyle->currentItem());
		((PlotQWT3D *) plot)->setFloorStyle((Qwt3D::FLOORSTYLE) floorstyle->currentItem());
		((PlotQWT3D *) plot)->setIsolines(isolines->text().toInt());
		((PlotQWT3D *) plot)->setAspectRatio(aspectcb->currentItem());
		((PlotQWT3D *) plot)->disableMouse(disablemousecb->isChecked());
		((PlotQWT3D *) plot)->setDataResolution(resolutionle->text().toInt());
	}
#endif

	p->updatePixmap();
	return 0;
}

void PlotSettingsDialog::autoScaleX() {
	plot->autoScaleX();
	LRange *r = plot->Ranges();
	xmin->setText(QString::number(r[0].rMin()));
	xmax->setText(QString::number(r[0].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoScaleY() {
	plot->autoScaleY();
	LRange *r = plot->Ranges();
	ymin->setText(QString::number(r[1].rMin()));
	ymax->setText(QString::number(r[1].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoScaleZ() {
	plot->autoScaleZ();
	LRange *r = plot->Ranges();
	zmin->setText(QString::number(r[2].rMin()));
	zmax->setText(QString::number(r[2].rMax()));
	p->updatePixmap();
}
