/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSPainter.cpp,v 1.6 2002/12/03 08:24:44 com Exp $
*/

#include <GRASSPainter.h>
#include <GRASSLayer.h>
#include <qpainter.h>
#include <algorithm>
#include <iostream>

#include <GRASSVectorLayer.h>



//#define ACE_ENABLE_TIMEPROBES
//#include "ace/Timeprobe.h"



static int max(int a,int b)
{
    return a>b?a:b;
}

GRASSPainter::GRASSPainter(char* location) 
  : 
  _location(location), D_to_A_tab(NULL) 
{
  /* Initialize the GIS calls */
  //G_gisinit(argv[0]) ;
  G_gisinit("Hej") ;

  G__setenv("LOCATION_NAME", location);    
  char *buf = G__getenv("LOCATION_NAME");

  if (G_get_set_window(&_grassRegion) == -1) 
    G_fatal_error("Current region not available");
}


GRASSPainter::~GRASSPainter() {}
  

void GRASSPainter::addLayer(GRASSLayer* layer) {
  _layers.push_back(layer);
}


void GRASSPainter::removeLayer(GRASSLayer* layer) {
  _layers.erase(find(_layers.begin(), _layers.end(), layer));
}


void GRASSPainter::paint(QRect& area, QPainter* painter) {
//   ACE_TIMEPROBE_RESET;  
//   ACE_TIMEPROBE ("GRASSPainter::paint start");
  D.set(&_grassRegion, area);

  /* Set up the screen for drawing map */
  D_x_beg = (int)D.D_get_d_west();
  D_x_end = (int)D.D_get_d_east();
  D_y_beg = (int)D.D_get_d_north();
  D_y_end = (int)D.D_get_d_south();
  
  if (D_to_A_tab) {
    free (D_to_A_tab) ;
    D_to_A_tab = NULL;
  }
  
  D_to_A_tab = (int *)G_calloc(D_x_end+1, sizeof(int)) ;
  
  /* construct D_to_A_tab for converting x screen Dots to x data Array
     values */
  for (int D_col = D_x_beg; D_col<=D_x_end; D_col++) {
    D_to_A_tab[D_col] = (int)(D.D_d_to_a_col((double)D_col));
  }
  
  painter->fillRect(area, Qt::white);

//    int j=0;
  for (LayerVectorIter i = _layers.begin(); i != _layers.end(); ++i) {
//      QColor c = ((GRASSVectorLayer*) (*i))->fillColor();
//      int h,s,v;
//      c.hsv(&h,&s,&v);
//      cerr << h << "," << s << "," << v << endl;
//  //      c.setHsv(h,s-(++j*10),v);
//      c.dark(50 * ++j);
//      c.setHsv(h,s, v-(10*j));
//      c.hsv(&h,&s,&v);
//      cerr << h << "," << s << "," << v << endl;


//      ((GRASSVectorLayer*) (*i))->fillColor(c);
    (*i)->draw(painter);
  }
//   ACE_TIMEPROBE ("GRASSPainter::paint stop");
//   ACE_TIMEPROBE_PRINT;
}


string GRASSPainter::xYToLatLong(int x, int y) {
  double east  = D.D_d_to_u_col(x);
  double north = D.D_d_to_u_row(y);
  char buffer[64];
  G_format_easting(east, buffer, _grassRegion.proj);
//    cerr << "EAST " << buffer;
  string result(buffer);
  G_format_northing(north, buffer, _grassRegion.proj);
//    cerr << " NORTH " << buffer << endl;
  result += string(" ") +  buffer;
  return result;
}


void GRASSPainter::zoom(QRect& zoomRect) {
  double ux1 = D.D_d_to_u_col(zoomRect.topLeft().x());
  double uy1 = D.D_d_to_u_row(zoomRect.topLeft().y());
  
  double ux2 = D.D_d_to_u_col(zoomRect.bottomRight().x());
  double uy2 = D.D_d_to_u_row(zoomRect.bottomRight().y());
  
  G_limit_south (&uy1, _grassRegion.proj);
  G_limit_north (&uy1, _grassRegion.proj);
  G_limit_east  (&ux1, _grassRegion.proj);
  G_limit_west  (&ux1, _grassRegion.proj);

  G_limit_south (&uy2, _grassRegion.proj);
  G_limit_north (&uy2, _grassRegion.proj);
  G_limit_east  (&ux2, _grassRegion.proj);
  G_limit_west  (&ux2, _grassRegion.proj);
  
  double north = uy1>uy2?uy1:uy2 ;
  double south = uy1<uy2?uy1:uy2 ;
  double west  = ux1<ux2?ux1:ux2 ;
  double east  = ux1>ux2?ux1:ux2 ;
  
  G_limit_north (&north, _grassRegion.proj);
  G_limit_south (&south, _grassRegion.proj);
  G_limit_east (&east, _grassRegion.proj);
  G_limit_west (&west, _grassRegion.proj);
  
  int t = (_grassRegion.north - north) / _grassRegion.ns_res;
  north = _grassRegion.north - (t) * _grassRegion.ns_res;
  
  t = (south - _grassRegion.south) / _grassRegion.ns_res;
  south = _grassRegion.south + (t) * _grassRegion.ns_res;
  
  t = (_grassRegion.east - east) / _grassRegion.ew_res;
  east = _grassRegion.east - (t) * _grassRegion.ew_res;
  
  t = (west - _grassRegion.west) / _grassRegion.ew_res;
  west = _grassRegion.west + (t) * _grassRegion.ew_res;
  
  _grassRegion.north = north;
  _grassRegion.south = south;
  _grassRegion.east  = east;
  _grassRegion.west  = west;


  /** print stuff **/
  cerr << "zoom start\n";
  char buffer[256];
  int len=0;
  strcpy (buffer, "?");
  G_format_northing(north, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"north: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_northing(south, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"south: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(east, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"east: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(west, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"west: %-*s  ", len, buffer);
  
  fprintf (stderr,"\r");
  fflush (stderr);

  if (char* err = G_adjust_Cell_head (&_grassRegion, 0, 0)) {
    cerr << "GRASSPainter::zoom failed " << err << ":" << __LINE__ << endl;
//      just_click(err);
//      continue;
  }
  
  G_put_window(&_grassRegion);
  G_set_window(&_grassRegion);

  cerr << "zoom done\n";
  
}

void GRASSPainter::unZoom(double magnify) {
  double ew = (_grassRegion.east - _grassRegion.west)/magnify;
  double ns = (_grassRegion.north - _grassRegion.south)/magnify;
  
  double ux1 = _grassRegion.east + ew/2;
  double ux2 = _grassRegion.west - ew/2;
  double uy1 = _grassRegion.north + ns/2;
  double uy2 = _grassRegion.south - ns/2;

  G_limit_south (&uy1, _grassRegion.proj);
  G_limit_north (&uy1, _grassRegion.proj);
  G_limit_east  (&ux1, _grassRegion.proj);
  G_limit_west  (&ux1, _grassRegion.proj);

  G_limit_south (&uy2, _grassRegion.proj);
  G_limit_north (&uy2, _grassRegion.proj);
  G_limit_east  (&ux2, _grassRegion.proj);
  G_limit_west  (&ux2, _grassRegion.proj);
  
  double north = uy1>uy2?uy1:uy2 ;
  double south = uy1<uy2?uy1:uy2 ;
  double west  = ux1<ux2?ux1:ux2 ;
  double east  = ux1>ux2?ux1:ux2 ;
  
  G_limit_north (&north, _grassRegion.proj);
  G_limit_south (&south, _grassRegion.proj);
  G_limit_east (&east, _grassRegion.proj);
  G_limit_west (&west, _grassRegion.proj);
  
  int t = (_grassRegion.north - north) / _grassRegion.ns_res;
  north = _grassRegion.north - (t) * _grassRegion.ns_res;
  
  t = (south - _grassRegion.south) / _grassRegion.ns_res;
  south = _grassRegion.south + (t) * _grassRegion.ns_res;
  
  t = (_grassRegion.east - east) / _grassRegion.ew_res;
  east = _grassRegion.east - (t) * _grassRegion.ew_res;
  
  t = (west - _grassRegion.west) / _grassRegion.ew_res;
  west = _grassRegion.west + (t) * _grassRegion.ew_res;
  
  _grassRegion.north = north;
  _grassRegion.south = south;
  _grassRegion.east  = east;
  _grassRegion.west  = west;


  /** print stuff **/
  cerr << "unZoom start\n";
  char buffer[256];
  int len=0;
  strcpy (buffer, "?");
  G_format_northing(north, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"north: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_northing(south, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"south: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(east, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"east: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(west, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"west: %-*s  ", len, buffer);
  
  fprintf (stderr,"\r");
  fflush (stderr);

  if (char* err = G_adjust_Cell_head (&_grassRegion, 0, 0)) {
    cerr << "GRASSPainter::unZoom failed " << err << ":" << __LINE__ << endl;
//      just_click(err);
//      continue;
  }
  
  G_put_window(&_grassRegion);
  G_set_window(&_grassRegion);

  cerr << flush << "unZoom done\n";

}


void GRASSPainter::pan(int x, int y, double magnify) {
  double ux2 = D.D_d_to_u_col((double)x)  ;
  double uy2 = D.D_d_to_u_row((double)y)  ;
  
  G_limit_south (&uy2, _grassRegion.proj);
  G_limit_north (&uy2, _grassRegion.proj);
  G_limit_east  (&ux2, _grassRegion.proj);
  G_limit_west  (&ux2, _grassRegion.proj);

  double ew = (_grassRegion.east - _grassRegion.west) / 2;
  double ns = (_grassRegion.north - _grassRegion.south) / 2;
  
  _grassRegion.east = ux2 + ew;
  _grassRegion.west = ux2 - ew;
  _grassRegion.north = uy2 + ns;
  _grassRegion.south = uy2 - ns;

  ew = (_grassRegion.east - _grassRegion.west)/magnify;
  ns = (_grassRegion.north - _grassRegion.south)/magnify;
  
  double ux1 = _grassRegion.east + ew/2;
  ux2 = _grassRegion.west - ew/2;
  double uy1 = _grassRegion.north + ns/2;
  uy2 = _grassRegion.south - ns/2;

  G_limit_south (&uy1, _grassRegion.proj);
  G_limit_north (&uy1, _grassRegion.proj);
  G_limit_east  (&ux1, _grassRegion.proj);
  G_limit_west  (&ux1, _grassRegion.proj);

  G_limit_south (&uy2, _grassRegion.proj);
  G_limit_north (&uy2, _grassRegion.proj);
  G_limit_east  (&ux2, _grassRegion.proj);
  G_limit_west  (&ux2, _grassRegion.proj);

  double north = uy1>uy2?uy1:uy2 ;
  double south = uy1<uy2?uy1:uy2 ;
  double west  = ux1<ux2?ux1:ux2 ;
  double east  = ux1>ux2?ux1:ux2 ;
  
  G_limit_north (&north, _grassRegion.proj);
  G_limit_south (&south, _grassRegion.proj);
  G_limit_east (&east, _grassRegion.proj);
  G_limit_west (&west, _grassRegion.proj);
  
  int t = (_grassRegion.north - north) / _grassRegion.ns_res;
  north = _grassRegion.north - (t) * _grassRegion.ns_res;
  
  t = (south - _grassRegion.south) / _grassRegion.ns_res;
  south = _grassRegion.south + (t) * _grassRegion.ns_res;
  
  t = (_grassRegion.east - east) / _grassRegion.ew_res;
  east = _grassRegion.east - (t) * _grassRegion.ew_res;
  
  t = (west - _grassRegion.west) / _grassRegion.ew_res;
  west = _grassRegion.west + (t) * _grassRegion.ew_res;
  
  _grassRegion.north = north;
  _grassRegion.south = south;
  _grassRegion.east  = east;
  _grassRegion.west  = west;


  /** print stuff **/
  cerr << "pan start\n";
  char buffer[256];
  int len=0;
  strcpy (buffer, "?");
  G_format_northing(north, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"north: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_northing(south, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"south: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(east, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"east: %-*s  ", len, buffer);
  len = 0;
  strcpy (buffer, "?");
  G_format_easting(west, buffer, _grassRegion.proj)  ;
  len = max (len, strlen(buffer));
  fprintf(stderr,"west: %-*s  ", len, buffer);
  
  fprintf (stderr,"\r");
  fflush (stderr);

  if (char* err = G_adjust_Cell_head (&_grassRegion, 0, 0)) {
    cerr << "GRASSPainter::pan failed " << err << ":" << __LINE__ << endl;
//      just_click(err);
//      continue;
  }
  
  G_put_window(&_grassRegion);
  G_set_window(&_grassRegion);

  cerr << flush << "pan done\n";


}


void GRASSPainter::useDefaultRegion() {
  G_get_default_window (&_grassRegion);
  if (char* err = G_adjust_Cell_head (&_grassRegion, 0, 0)) {
    cerr << "GRASSPainter::useDefaultRegion failed " << err << ":"
	<< __LINE__ << endl;
  }
  
  G_put_window(&_grassRegion);
  G_set_window(&_grassRegion);
}



string GRASSPainter::location() {
  return string(G_location_path());
}


void GRASSPainter::changeBrilliance(int bril) {
  for (LayerVectorIter i = _layers.begin(); i != _layers.end(); ++i) {
    QColor c = ((GRASSVectorLayer*) (*i))->fillColor();
    int h,s,v;
    c.hsv(&h,&s,&v);
    cerr << h << "," << s << "," << v << endl;
    c.setHsv(h,s,bril);
    c.hsv(&h,&s,&v);
    cerr << h << "," << s << "," << v << endl;
    ((GRASSVectorLayer*) (*i))->fillColor(c);
  }
}


GRASSPainter::GRASSPainter(const GRASSPainter& rhs) {}


GRASSPainter& GRASSPainter::operator=(const GRASSPainter& rhs) {
  return *this;
}
