/***************************************************************************
                          kwcentryselection.h  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWCENTRYSELECTION_H
#define KWCENTRYSELECTION_H

#include <kcombobox.h>
#include <qtoolbutton.h>
#include <kiconloader.h>
#include <kwcentry.h>

/**
  *@author Matthias Reif
  */
class KWCEntrySelection : public KWCEntry  {
	Q_OBJECT
public: 
	KWCEntrySelection( const QString & inscr, bool editable = false, KSingleTabWidget *parent = 0, const char *name = 0 );
	~KWCEntrySelection();
	void insertItem( const QString & text, int index = -1 );
	void setCurrentItem( int index );
	void clear();
	void setValue( QString text );
	void setAltLabel( QString text );
	bool contains( const QString & text );
	int getCurrentItem();

protected:
	KComboBox *valueSelect;
	QLabel *altLabel;
	QToolButton *applyButton;

signals:
	void activated( int );
	void textChanged ( const QString & );

protected slots:
	void textChangedSlot( );
	void itemActivatedSlot( int index );
};

#endif
