\ arrays.4th
\
\ Toolset for one- and two-dimensional arrays in ANS Forth

\ ---------------------------------------------------
\     (c) Copyright 2001  Julian V. Noble.          \
\       Permission is granted by the author to      \
\       use this software for any application pro-  \
\       vided this copyright notice is preserved.   \
\ ---------------------------------------------------

\ Requires CORE and CORE EXT wordsets

\ Ported to kForth -- 10-04-2001  K. Myneni; this version can also 
\ be used in ANS Forth by uncommenting the following definition:
\
\   : ?allot HERE SWAP ALLOT ;

\ non-Standard word:

-1 CELLS CONSTANT -1cells
    : cell-  -1cells  +  ;


\ words for 1-dimensional arrays

    : long   ;

    : 1array    ( len #bytes/datum --)      \ ( #b len data ...)
            CREATE  2DUP  *  2 CELLS + ?allot  DUP CELL+ >R ! R> ! ;

    : _len      ( base_addr -- len)  \ determine length of an array
            CELL+  @  ;

    : }         ( base_adr indx -- adr[indx] )
            OVER  _len  OVER  <=  OVER  0<  OR  ABORT" Index out of range"
            OVER  @   *  +  CELL+  CELL+  ;

\ words for 2-dimensional arrays

    : wide    ;

    : 2array    ( hgt wid data_size --)     \ ( wid #b len data ...)
	    CREATE   >R                       ( hgt wid)
	    2DUP   2DUP  *  R@  *  
	    3 CELLS  +  ?allot
	    TUCK  !  CELL+  DUP  R>  SWAP  !  ( hgt wid hgt a)
	    CELL+  >R  *  R>  !
	    DROP ;


    : }}        ( base_adr m n -- adr[m,n] )    \ data stored row-wise
            2>R  CELL+  DUP cell-  @
            R> *   R> +                ( base_adr+cell m+n*w)
            }   ;

(
Usage examples:

    20 long 2 DFLOATS 1array a{              \ complex vector
    20 long 20 wide  1 DFLOATS 2array M{{    \ real matrix
    20 long 1 CELLS  1array Irow{            \ single-length, integer-
                                             \   valued vector
)

