\ zeigen22h.4th
\
\ Compute eigenvalues and eigenvectors of 2x2 complex *Hermitian* matrix
\
\ A Hermitian matrix is a square complex matrix which, when conjugated 
\   and transposed, is identical to the original matrix. A Hermitian
\   matrix has *real* eigenvalues.
\
\ See Quantum Mechanics, vol. 1, 2nd ed., by Claude Cohen-Tannoudji,
\	Bernard Diu, and Franck Laloe, pp. 420--423.
\
\ Copyright (c) 2003 Krishna Myneni
\ Provided Under the GNU General Public License
\
\ Requires:
\
\	complex.4th
\	matrix.4th
\	zmatrix.4th
\
\ Revisions:
\	2003-02-20  created
\
\ Usage:
\
\ Create a 2x2 complex matrix (m1), and another matrix to hold the
\   eigenvectors (e1):
\
\	2 2 zmatrix m1
\	2 2 zmatrix e1
\
\ Put the matrix elements of the Hermitian matrix into m1, e.g.
\
\	z11   1 1 m1 zmat!
\	z12   1 2 m1 zmat!
\	z21   2 1 m1 zmat!
\	z22   2 2 m2 zmat!
\
\ where z11 ... z22 each are pairs of floating point numbers, 
\ representing a complex number. For a Hermitian matrix, the
\ diagonal elements z11 and z22 must have zero imaginary parts,
\ and the off-diagonal elements z12 and z21 must be complex
\ conjugate pairs.
\
\ Alternately, the matrix elements can be entered a row at a time:
\
\	z11 z12 2  1 m1 zrow!
\	z21 z22 2  2 m1 zrow!
\
\ Print the matrix m1 to make sure it has been correctly entered:
\
\	m1 zmat.
\
\ Compute and print the eigenvalues of m1:
\
\	m1 eigenvalues 
\	fswap f. f.
\
\ Compute and print the eigenvectors of m1:
\
\	m1 e1 eigenvectors
\	e1 zmat.
\
\ The 2 columns of e1 contain the 2 eigenvectors of m1. The
\ first column is the eigenvector corresponding to the first 
\ eigenvalue.
\

: z22_root_part ( a -- f | intermediate step in calc)
	>r
	1 1 r@ zmat@  real  2 2 r@ zmat@  real  f- fdup f*
	1 2 r@ zmat@  |z|^2 4e f*  f+ fsqrt
	r> drop ;
		
: eigenvalues ( a -- f1 f2 | compute the eigenvalues of 2x2 zmatrix a)
	>r
	1 1 r@ zmat@  real  2 2 r@ zmat@  real f+ .5e f*	
	r@  z22_root_part  .5e  f*
	r> drop 
	fover fover f+ 2>r
	f- 2r> ;

fvariable z22_phi2
fvariable z22_theta2

: eigenvectors ( a1 a2 -- | compute eigenvectors of 2x2 zmatrix a1)
	\ The columns of the 2x2 zmatrix a2 will contain the eigenvectors
	dup 2 2 rot mat_size!	\ ensure a2 is 2x2 zmatrix
	>r >r
	2 1 r@ zmat@ arg 2e f/ z22_phi2 f!
	1 1 r@ zmat@  real  2 2 r@ zmat@  real  f-
	r@ z22_root_part 
	f/ facos 2e f/ z22_theta2 f!
	r> drop
	z22_theta2 f@ fsin fnegate  z22_phi2 f@ fnegate polar>
	1 1 r@ zmat!
	z22_theta2 f@ fcos  z22_phi2 f@  polar>
	2 1 r@ zmat!
	z22_theta2 f@ fcos  z22_phi2 f@ fnegate polar>
	1 2 r@ zmat!
	z22_theta2 f@ fsin  z22_phi2 f@  polar>
	2 2 r> zmat! ;
