# $Id: wa.pl,v 1.11 2002/03/26 23:31:45 qvr Exp $
$VERSION = "1.11";
%IRSSI = (
    authors     => "Matti 'qvr' Hiljanen",
    contact     => "matti\@hiljanen.com",
    contributors => "bd\@bc-bd.org",
    name        => "wa",
    description => "shows what WinAmp is playing with /wa command",
    license     => "Public Domain",
    url         => "http://matin.maapallo.org/softa/irssi",
);
#
# Requires httpQ >= 1.8 (http://www.csc.uvic.ca/~karvanit/winamp/)
#
# /SET httpq_ to configure the script
#   /SET httpq_command sets the command which is executed on /wa
#   the following expandos can be used with it:
#   %T (time)
#   %P (percent)
#   %S (song name)
#   %L (lower cased song name)
#   httpq_command -setting was originally contributed by bd@bc-bd.org
#

use Socket;
use strict;

my($waport, $wahost, $wapass);

sub getstat($$$) {
    my ($host, $port, $data) = @_;
    $data = "$data HTTP/1.0\r\n";

   if (socket(SOCK, PF_INET, SOCK_STREAM, getprotobyname('tcp'))) {
        if (connect(SOCK, sockaddr_in($port, inet_aton($host)))) {
              unless (send(SOCK, $data, 0)) {
              Irssi::print("Unable to write to the socket: $!", Irssi::MSGLEVEL_CLIENTERROR);
              return;
              }
        } else {
              Irssi::print("Unable to connect to the socket: $!", Irssi::MSGLEVEL_CLIENTERROR);
              return;
        }
        } else {
        Irssi::print("Connection to $host failed: $!", Irssi::MSGLEVEL_CLIENTERROR);
        return;
        }

# uncomment this for slow networks
#    sleep(1);
   
    my @lines = <SOCK>;
    close(SOCK);
    my $result = join("", @lines);
    $result =~ s/^HTTP.*\n//g;
    $result =~ s/^Content.*\n//g;
    $result =~ s/^\r//g;
    $result =~ s/[\r,\n]//g;
    return $result;
}
    
sub parse_times ($$) {
   my ($position, $length) = @_;
    $position = sprintf("%02d", int(($position/1000/60))).":"
       .sprintf("%02d", ($position/1000%60));
    if ($length eq "-1") {
       $length = "/netradio";
    } else {
       $length = "/".sprintf("%02d", int(($length/60))).":"
          .sprintf("%02d", ($length%60));
    }
    my $result = "$position$length";
    return $result;
}

sub mkpercent ($$) {
   my ($position, $length) = @_;
   my $result;
   my $numbers;
   if ($length eq "-1") {
      $result = "0";
   } else {
      $numbers = sprintf("%.0f",((($position/1000)/$length)*100));
      $result = "(${numbers}%)";
   }
   if ($numbers>100) {
      $result = "(wtf?)";
   }
   return $result;
}

sub vol_control($) {
   $wapass = Irssi::settings_get_str('httpq_password');
   $wahost = Irssi::settings_get_str('httpq_host');
   $waport = Irssi::settings_get_int('httpq_port');

   my ($direction) = @_;
   if (!$direction) {
      Irssi::print("Usage: /vol <up|down>");
      return; 
   }
   
   if ($direction eq "up") {
      Irssi::print("Vol up..") if getstat($wahost, $waport, "GET /volumeup?p=$wapass");
   } elsif ($direction eq "down") {
      Irssi::print("Vol down..") if getstat($wahost, $waport, "GET /volumedown?p=$wapass");
   }
}


# this function from bd@bc-bd.org
sub expand {
   my ($string, %format) = @_;
   my ($exp, $repl);
   $string =~ s/%$exp/$repl/g while (($exp, $repl) = each(%format));
   return $string;
}

sub main_wa {
   $wapass = Irssi::settings_get_str('httpq_password');
   $wahost = Irssi::settings_get_str('httpq_host');
   $waport = Irssi::settings_get_int('httpq_port');
   my $status = getstat($wahost, $waport, "GET /isplaying?p=$wapass");
   if ($status eq "1") {
      my $position = getstat($wahost, $waport, "GET /getoutputtime?p=$wapass&a=0");
      my $length = getstat($wahost, $waport, "GET /getoutputtime?p=$wapass&a=1");
      my $song = getstat($wahost, $waport, "GET /getplaylisttitle?p=$wapass&a="
            .getstat($wahost, $waport, "GET /getplaylistpos?p=$wapass"));
      my $lc = lc($song);
      my $time = parse_times($position, $length);
      my $percent = mkpercent($position, $length);
      if (!$percent) {
         $percent = '';
      }
      #my $final = "np: '$song' [$time$percent]";
      
      my $final = expand(Irssi::settings_get_str("httpq_command"),
            "S", $song,
            "T", $time,
            "P", $percent,
            "L", $lc);
      
      Irssi::active_win()->command("$final");
   } elsif ($status eq "3") {
         Irssi::print("WinAmp is paused.");
   } else {
      Irssi::print("WinAmp isn't playing any song.");
   }
}

# working, but pretty useless imho :)
sub wa_statusbar {
   my ($item, $get_size_only) = @_;
   $wapass = Irssi::settings_get_str('httpq_password');
   $wahost = Irssi::settings_get_str('httpq_host');
   $waport = Irssi::settings_get_int('httpq_port');  

   my $status = getstat($wahost, $waport, "GET /isplaying?p=$wapass");
   return unless $status eq "1";
   my $position = getstat($wahost, $waport, "GET /getoutputtime?p=$wapass&a=0");
   my $length = getstat($wahost, $waport, "GET /getoutputtime?p=$wapass&a=1");
   my $song = getstat($wahost, $waport, "GET /getplaylisttitle?p=$wapass&a="
         .getstat($wahost, $waport, "GET /getplaylistpos?p=$wapass"));
   my $time = parse_times($position, $length);
   my $percent = mkpercent($position, $length);
   if (!$percent) {
      $percent = '';
   }
   my $content = "{sb '$song' %_@%_ $time}";
   $item->default_handler($get_size_only, $content, undef, 1);
}

sub refresh_wa {
   Irssi::statusbar_items_redraw('wa');
}
#Irssi::timeout_add(10000, 'refresh_wa', undef);
#Irssi::statusbar_item_register('wa', undef, 'wa_statusbar');

Irssi::command_bind('wa', 'main_wa');
Irssi::command_bind('vol', 'vol_control');

Irssi::settings_add_str('misc', 'httpq_password', "password");
Irssi::settings_add_str('misc', 'httpq_host', "hostname");
Irssi::settings_add_int('misc', 'httpq_port', "4800");
Irssi::settings_add_str('misc', 'httpq_command', "say np: '%S' [%T %P]");

#EOF
