module DB.HSQL.SQLite3.Functions where

import Foreign(Ptr,FunPtr)
import Foreign.C(CString,CInt)

#include <fcntl.h>
#include <sqlite3.h>

type SQLite3 = Ptr ()

foreign import ccall 
  sqlite3_open :: CString -> (Ptr SQLite3) -> IO Int

foreign import ccall
  sqlite3_errmsg :: SQLite3 -> IO CString

foreign import ccall
  sqlite3_close :: SQLite3 -> IO ()

foreign import ccall
  sqlite3_exec :: SQLite3 -> CString -> FunPtr () -> Ptr () -> Ptr CString -> IO CInt

foreign import ccall
  sqlite3_get_table ::   SQLite3 -> CString -> Ptr (Ptr CString) -> Ptr CInt -> Ptr CInt -> Ptr CString -> IO CInt

foreign import ccall
 sqlite3_free_table :: Ptr CString -> IO ()

foreign import ccall
  sqlite3_free :: CString -> IO ()

-- |
foreign import ccall "strlen"
  strlen :: CString -> IO CInt

-- |
sqliteOk:: Int
sqliteOk = #const SQLITE_OK

oRdOnly = #const O_RDONLY

oWrOnly = #const O_WRONLY

oRdWr = #const O_RDWR

oAppend = #const O_APPEND