{-# LANGUAGE ForeignFunctionInterface #-}
{-| Interface to the functions of the the foreign code environment.
-}
module DB.HSQL.PG.Functions where

import Foreign(Ptr,Word32)
import Foreign.C(CString)

import DB.HSQL.PG.Status(ConnStatusType,ExecStatusType)
import DB.HSQL.PG.Type(Oid)

#include <postgres.h>
#include <libpq-fe.h>

type PGconn = Ptr ()
type PGresult = Ptr ()

foreign import ccall "strlen" 
  strlen :: CString -> IO Int

{-| Refer to PostgreSQL manual, chapter 30, `libpq - C library' 
    (e.g. http://www.postgresql.org/docs/8.3/interactive/libpq.html)
-}
foreign import ccall "libpq-fe.h PQsetdbLogin" 
  pqSetdbLogin :: CString -> CString -> CString -> CString -> CString -> CString -> CString -> IO PGconn

foreign import ccall "libpq-fe.h PQstatus" 
  pqStatus :: PGconn -> IO ConnStatusType

foreign import ccall "libpq-fe.h PQerrorMessage"  
  pqErrorMessage :: PGconn -> IO CString

foreign import ccall "libpq-fe.h PQfinish" 
  pqFinish :: PGconn -> IO ()

foreign import ccall "libpq-fe.h PQexec" 
  pqExec :: PGconn -> CString -> IO PGresult

foreign import ccall "libpq-fe.h PQresultStatus" 
  pqResultStatus :: PGresult -> IO ExecStatusType

foreign import ccall "libpq-fe.h PQresStatus" 
  pqResStatus :: ExecStatusType -> IO CString

foreign import ccall "libpq-fe.h PQresultErrorMessage"
  pqResultErrorMessage :: PGresult -> IO CString

foreign import ccall "libpq-fe.h PQnfields" 
  pgNFields :: PGresult -> IO Int

foreign import ccall "libpq-fe.h PQntuples" 
  pqNTuples :: PGresult -> IO Int

foreign import ccall "libpq-fe.h PQfname" 
  pgFName :: PGresult -> Int -> IO CString

foreign import ccall "libpq-fe.h PQftype" 
  pqFType :: PGresult -> Int -> IO Oid

foreign import ccall "libpq-fe.h PQfmod" 
  pqFMod :: PGresult -> Int -> IO Int

foreign import ccall "libpq-fe.h PQfnumber" 
  pqFNumber :: PGresult -> CString -> IO Int

foreign import ccall "libpq-fe.h PQgetvalue" 
  pqGetvalue :: PGresult -> Int -> Int -> IO CString

foreign import ccall "libpq-fe.h PQgetisnull" 
  pqGetisnull :: PGresult -> Int -> Int -> IO Int

