// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Thread for calculating hashes
// ****************************************************************************


#ifndef __THREADHASH_H__
#define __THREADHASH_H__

#include <QThread>   //lint !e537 Repeated include

#ifndef __DEVICE_H__
  #include "device.h"
#endif

class t_ThreadHashLocal;

class t_ThreadHash: public QThread
{
   Q_OBJECT

   public:
      t_ThreadHash ();
      t_ThreadHash (t_pDevice pDevice);
     ~t_ThreadHash ();

   protected:
      void run (void);

   signals:
      void SignalEnded (t_pDevice pDevice);

   private slots:
      void SlotFinished (void);

   private:
      t_ThreadHashLocal *pOwn;
};

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_THREADHASH_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_THREADHASH + 1,
   ERROR_THREADHASH_LIBEWF_FAILED
};

#endif

