// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Provides all information for displaying the DeviceList on
//                  screen
// ****************************************************************************



#ifndef __DEVICELISTMODEL_H__
#define __DEVICELISTMODEL_H__

#include <QObject>
#include <QList>
#include <QAbstractTableModel>

#include "device.h"


class t_DeviceListModel: public QAbstractTableModel
{
   Q_OBJECT

   public:
      t_DeviceListModel ();
      t_DeviceListModel (t_pDeviceList pDeviceList);

      int  rowCount    (const QModelIndex & parent= QModelIndex()) const;
      int  columnCount (const QModelIndex & parent= QModelIndex()) const;

      QVariant data       (const QModelIndex &Index, int Role) const;
      QVariant headerData (int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;

   public slots:
      void SlotRefresh (void);
//      void SlotUpdate  (void);

   private:
      enum
      {
         DATATYPE_QSTRING,
         DATATYPE_INT32,
         DATATYPE_INT64,
         DATATYPE_DEVICE_STATE,
         DATATYPE_ACQUIRE_STATE,
      };

      typedef QVariant (* t_pGetDataFn) (t_pDevice pDevice);

      typedef struct
      {
         QString       Name;         // The column name as displayed in the table header
         t_pGetDataFn pGetDataFn;
         int           DisplayType;  // One of the display type as defined in t_ItemDelegate
         int           Alignment;    // Use Qt::AlignLeft, Qt::AlignRight, ...
         int           MinWidth;     // Set to 0 for default width
      } t_ColAssoc;

      QList<t_ColAssoc> ColAssocList;

      t_pDeviceList poDeviceList;
};

#endif
