// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Multithreaded AFF (AAFF = Avanced AFF)
// ****************************************************************************

#ifndef __AAFF_H__
#define __AAFF_H__

typedef struct _t_Aaff *t_pAaff;

typedef struct
{
   bool Zero;         // Tells AafWrite that all data is 0
   bool Compressed;   // Tells AafWrite whether the data should be written compressed or uncompresed
   int  DataLenOut;   // If Compressed is true: The size of the compressed data
} t_AaffPreprocess, *t_pAaffPreprocess;

#define AAFF_SEGNAME_COMMAND_LINE "acquisition_commandline"
#define AAFF_SEGNAME_MACADDR      "acquisition_macaddr"
#define AAFF_SEGNAME_DATE	       "acquisition_date"        // Format: YYYY-MM-DD HH:MM:SS TZT
#define AAFF_SEGNAME_DEVICE	    "acquisition_device"
#define AAFF_SEGNAME_MODEL		    "device_model"
#define AAFF_SEGNAME_SN		       "device_sn"

// ------------------------------------
//              Functions
// ------------------------------------

APIRET AaffOpen       (t_pAaff *ppAaff, const char *pFilename, unsigned long long DeviceSize, unsigned int SectorSize, unsigned int PageSize);
APIRET AaffPreprocess (t_pAaffPreprocess *ppPreprocess, unsigned char *pDataIn, unsigned int DataLenIn, unsigned char *pDataOut, unsigned int DataLenOut);
APIRET AaffWrite      (t_pAaff   pAaff, t_pAaffPreprocess pPreprocess, unsigned char *pData, unsigned int DataLen);
APIRET AaffClose      (t_pAaff   pAaff, unsigned long long BadSectors, unsigned char *pMD5, unsigned char *pSHA256, int Duration);

APIRET AaffWriteSegmentStr (t_pAaff pAaff, const char *pName, unsigned int Argument, const char *pStr);

APIRET AaffCopyBadSectorMarker (unsigned char *pBuffer, unsigned int Len);

APIRET AaffInit   (void);
APIRET AaffDeInit (void);


// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_AAFF_MEMALLOC_FAILED   = ERROR_BASE_AAFF + 1,
   ERROR_AAFF_CANNOT_CREATE_FILE,
   ERROR_AAFF_CANNOT_WRITE_FILE,
   ERROR_AAFF_CANNOT_CLOSE_FILE,
   ERROR_AAFF_CANNOT_FLUSH_FILE,
   ERROR_AAFF_SECTORSIZE_TOO_BIG,
   ERROR_AAFF_COMPRESSION_FAILED,
};

#endif


