/*
 * Merge view widget header
 *
 * From a GUI perspective, this widget consists of three components,
 * merge-widget, twopane-widget and overview-widget.
 * This widget is just a GUI container.
 * Almost every logic is handled by GdiffMerge and GdiffTwoPane widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_MERGEVIEW_H__
#define __GDIFF_MERGEVIEW_H__

#include <gtk/gtkhbox.h>
#include <gtk/gtkvpaned.h>
#include "basepane-widget.h"
#include "gdiffoverview.h"

#ifdef __cplusplus 

extern "C" {
#endif /* __cplusplus */
#define GDIFF_TYPE_MERGEVIEW				(gdiff_mergeview_get_type())
#define GDIFF_MERGEVIEW(obj)				GTK_CHECK_CAST(obj, gdiff_mergeview_get_type(), GdiffMergeView)
#define GDIFF_MERGEVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_mergeview_get_type(), GdiffMergeViewClass)
#define GDIFF_IS_MERGEVIEW(obj)			GTK_CHECK_TYPE(obj, gdiff_mergeview_get_type())
#define GDIFF_IS_MERGEVIEW_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_MERGEVIEW))


typedef struct _GdiffMergeView       GdiffMergeView;
typedef struct _GdiffMergeViewClass  GdiffMergeViewClass;

struct _GdiffMergeView {
	GtkHBox hbox;

	/* Child GUI components */
	GtkVPaned *vpaned;
	GdiffBasePane *merge;/* accessed via arg "basepane" */
	GdiffBasePane *multipane;/* accessed via arg "auxpane" */
	GdiffOverview *overview;
	GtkVScrollbar *vscrollboth;
	GtkWidget *rmenu;

	/* backward pointer for reference */
	GDiffWindow *gdwin;

	/* TRUE if this view is under directory view */
	gboolean is_under_dir;

	/* handler ids */
	guint merge_move_handler;
	guint multip_move_handler;
	guint merge_select_dl_handler;
	guint multip_select_dl_handler;

	/* output file */
	char *outfile;
};

struct _GdiffMergeViewClass {
	GtkHBoxClass parent_class;

	/* Interfaces */
	void (*scrollup)(GdiffMergeView *mergeview);/* signal */
	void (*scrolldown)(GdiffMergeView *mergeview);/* signal */
};


GtkType gdiff_mergeview_get_type(void);
GtkWidget* gdiff_mergeview_new(DiffDir *diffdir, DiffFiles *dfiles, gboolean is_under_dir);

void gdiff_mergeview_set_outfile(GdiffMergeView *mergeview, const char *outfile);


/* Macros */
/* I could have these informations in this widget, but I don't.
   Instead, they are implicitly kept in mergeane widget.
   I provide interfaces for them by macros. */
#define GDIFF_MERGEVIEW_DIFFDIR(mergeview)\
	(GDIFF_BASEPANE(GDIFF_MERGEVIEW(mergeview)->merge)->diffdir)
#define GDIFF_MERGEVIEW_DFILES(mergeview)\
	(GDIFF_BASEPANE(GDIFF_MERGEVIEW(mergeview)->merge)->dfiles)
#define GDIFF_MERGEVIEW_FILENAME(mergeview, whichfile)\
	(GDIFF_BASEPANE(GDIFF_MERGEVIEW(mergeview)->merge)->filename[whichfile])
#define GDIFF_MERGEVIEW_PREF(mergeview)\
	(GDIFF_BASEPANE(GDIFF_MERGEVIEW(mergeview)->merge)->pref)

#define GDIFF_MERGEVIEW_NUM_FILES(mergeview)\
	((GDIFF_MERGEVIEW_DFILES(mergeview)->is_diff3) ? 3 : 2)

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_MERGEVIEW_H__ */
