/*
 * GUI show(hide) line numbers header
 * Show or hide line numbers on GtkText widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_LINENUM_H__
#define __GDIFF_LINENUM_H__


#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/* Forward declarations of types. */
typedef struct _LineFormat LineFormat;

	
/*
 * Data structure definitions
 */
/* Format of line numbers */
struct _LineFormat {
	int n_col; /* The number of columns of inserted numbers.
				  (e.g. n_col==3 implies from "1" to "999".) */
	const char *format; /* format for each inserted numbers.
						   (e.g. "%4d> ") */
};

	
/* Global function declarations */
extern int insert_remove_line_numbers(GtkWidget *text, gboolean b_ins, int pos, const FontProp *fprop, MBuffer *mbuf, int begin, int end, const LineFormat *lformat);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_LINENUM_H__ */
