/*   grep-dctrl - grep Debian control files
     Copyright (C) 1999, 2000, 2001  Antti-Juhani Kaijanaho
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
  
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details. 
  
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
     The author can be reached via mail at (ISO 8859-1 charset for the city)
        Antti-Juhani Kaijanaho
        Helokantie 1 A 16
        FIN-40640 JYVSKYL
        FINLAND
        EUROPE
     and via electronic mail from
        gaia@iki.fi
     If you have a choice, use the email address; it is more likely to
     stay current.

*/


#ifndef MATCHER_H__
#define MATCHER_H__

#include <stdio.h>
#include <stddef.h>
#include <regex.h>

enum match_type_t { MATCH_FIXED, MATCH_EXACT, MATCH_REGEX };

union pattern_t {
  const char * fixed;
  regex_t * regex;
};

struct matcher_t {
  enum match_type_t type;
  int case_sensitive; /* flag */
  int show_fieldnames; /* flag */
  int exact_match; /* flag */
  int inverse; /* flag: true iff print those paras that don't match */
  int suppress; /* flag: suppress normal output */
  int short_descr; /* if Description is shown, show only the first line */
  unsigned long long match_count;
  size_t numfields;
  const char ** fields; 
  union pattern_t pattern;
};

/* Return true if all went well. */
int
grep_control (struct matcher_t * matcher, FILE * f, char * show_fields [],
              const char * fname);

char *
get_regerror (int errcode, regex_t *compiled);

#endif /* MATCHER_H__ */
