/*   grep-dctrl - grep Debian control files
     Copyright (C) 1999  Antti-Juhani Kaijanaho
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
  
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details. 
  
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
     The author can be reached via mail at (ISO 8859-1 charset for the city)
        Antti-Juhani Kaijanaho
        Helvintie 2 e as 9
        FIN-40500 JYVSKYL
        FINLAND
        EUROPE
     and via electronic mail from
        gaia@iki.fi
     If you have a choice, use the email address; it is more likely to
     stay current.

*/

#define BUFFER_C__

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "buffer.h"
#include "msg.h"

#include <stdio.h>

buffer buffer_nomem = 0;

#define INIT_SIZE 64 /* must be a power of two */

buffer
new_buffer (void)
{
  struct buffer_t * rv;

  debug_message("new_buffer", 0);

  rv = malloc (sizeof (struct buffer_t));
  if (rv == 0)
    return buffer_nomem;

  rv->magic_cookie = BUFFER_MC;
  rv->buffer_len = 0;
  rv->data_len = 0;
  rv->data = 0;
  return rv;
}

int
buffer_enlarge (buffer buf)
{
  char * new_data;
  size_t new_len;

  debug_message("buffer_enlarge", 0);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (INIT_SIZE % 2 == 0);

  new_len = (buf->buffer_len == 0) ? INIT_SIZE : buf->buffer_len * 2;
  new_data = realloc (buf->data, new_len);
  if (new_data == 0)
    return 0;
  buf->data = new_data;
  buf->buffer_len = new_len;
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);
  return 1;
}

void
buffer_free (buffer buf)
{
  debug_message("buffer_free", 0);

  if (buf == buffer_nomem)
    return;

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);

  buffer_empty (buf);

  /* make sure an invalid reference is caught */
  buf->magic_cookie = ~BUFFER_MC; 

  free (buf);
}

void
buffer_empty (buffer buf)
{
  debug_message("buffer_empty", 0);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);

  buffer_clear (buf);

  buf->buffer_len = 0;
  free (buf->data);
}

void
buffer_trim (buffer buf)
{
  debug_message("buffer_trim", 0);
  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);
  assert (INIT_SIZE % 2 == 0);

  if (buf->data_len > 0 && buf->buffer_len / buf->data_len > 4)
    {
      char * new_data;
      size_t new_len;

      /* Find the smallest power of two greater than data length.  */
      for (new_len = INIT_SIZE; new_len < buf->data_len; new_len *= 2);

      new_data = realloc (buf->data, new_len);
      if (new_data != 0)
        {
          buf->data = new_data;
          buf->buffer_len = new_len;
        }
    }
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);
}

const char *
buffer_c_str (buffer buf)
{
  debug_message("buffer_c_str", 0);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);

  /* Let's fool around a bit.  Insert a null character at the end,
   possibly enlarging the buffer, but then decrease the data length to
   make other routines think it is not there.  */
  buffer_append (buf, '\0');
  assert (buf->data_len > 0);
  --buf->data_len;

  return buf->data;
}

size_t
buffer_len (buffer buf)
{
  debug_message("buffer_len", 0);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);

  return buf->data_len;
}

void
buffer_data (buffer buf, char * cvec)
{
  debug_message("buffer_data", 0);

  assert (buf != 0);
  assert (buf->magic_cookie == BUFFER_MC);
  assert (buf->buffer_len == 0 || buf->data_len <= buf->buffer_len);

  memcpy (cvec, buf->data, buf->data_len);
}

#ifdef TESTMAIN

#include <stdio.h>

int
main (int argc, char * argv [])
{
  int c;
  buffer buf;
  FILE * f;

  buf = new_buffer ();

  f = fopen ("COPYING", "r");
  if (f == NULL)
    {
      perror (argv[0]);
      return 1;
    }
  while ( (c = getc (f)) != EOF)
    if (!buffer_append (buf, c))
      {
        buffer_free (buf);
        fprintf (stderr, "%s: unable to allocate enough memory, bailing out.\n", argv[0]);
        fclose (f);
        return 1;
      }
  
  fclose (f);

  puts (buffer_c_str (buf));
  printf ("%d\n", buffer_len (buf));
  buffer_free (buf);
  return 0;
}
          
#endif /* TESTMAIN */
