/*
 * Gmail. A Gnome email client.
 * Copyright (C) 1999 Wayne Schuller
 *
 * setup.c - The gnome druid code which sets up a new installation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "main.h"

extern _GmailApp_	*GmailApp;		/* Global vars live here. */

extern void  create_text (void);
extern gboolean DestroyRightPane(void);
extern void     gmail_init(void);
extern GtkWidget *create_database_page (gboolean full);
extern GString * setup_db (gchar *ruser, gchar *rpass, gchar *user, gchar *pass, gchar *hostname, gchar *db);
extern void mark_vfolder_unread_status_by_name(gchar *vfolder, gboolean unread_status);

void setup_druid(void);
static gboolean druid_back_callback (GnomeDruidPage *page, GnomeDruid *druid, gpointer data);
static gboolean simple_druid_next_callback (GnomeDruidPage *page, GnomeDruid *druid, GnomeDruidPage *next);
static gboolean mysql_next_callback (GnomeDruidPage *page, GnomeDruid *druid, GnomeDruidPage *next);
static void druid_finish (GnomeDruidPage *page, GnomeDruid *druid, gpointer data);

/* Setup_druid is called the first time the user runs gmail. 
 * It attemps to make it very very easy for the newbie user to get
 * up and running. 
 * It especially tries to make the mysql part very very simple.
 *
 */
void
setup_druid(void)
{
	GtkWidget *druid;
	GtkWidget *page_start, *page_finish;
	GtkWidget *page_a, *page_b, *page_c, *page_d;
	GtkWidget *mysql_hard;
  GdkImlibImage *logo = NULL;
  GdkImlibImage *wm = NULL;
	gchar *fname;
	GtkWidget *window;
 	GtkWidget *vbox, *label, *table;
	gchar *email;
  GtkWidget *text;
  GtkTooltips *tooltips;


	window = gnome_dialog_new(_("Welcome to Gmail"), NULL);

    /* load the images */
	fname = gnome_pixmap_file ("gnome-logo-icon.png");
  	if (fname)
   		logo = gdk_imlib_load_image (fname);
  	g_free (fname);

	fname = gnome_pixmap_file ("gmail-logo.png");
  	if (fname)
   		wm = gdk_imlib_load_image (fname);
  	g_free (fname);

	druid = gnome_druid_new();
	gnome_druid_set_buttons_sensitive(GNOME_DRUID (druid), FALSE, TRUE, FALSE);

	gtk_signal_connect_object (GTK_OBJECT (druid), "destroy",
                                   GTK_SIGNAL_FUNC (gtk_main_quit),
                                   GTK_OBJECT (window));

	/* Create all the pages. */
	page_start = gnome_druid_page_start_new_with_vals(
			"Gmail",
		_("Welcome to Gmail!\nGmail is an experiment in using database driven email.\nGmail vfolders give you powerful control over your messages.\n\n\nThis druid will help you set everything up easily."),
			logo, NULL);
	gtk_signal_connect_object (GTK_OBJECT (page_start), "cancel", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

	page_a = gnome_druid_page_standard_new_with_vals (_("Identity"), logo);
	page_b = gnome_druid_page_standard_new_with_vals (_("Mysql Server"), logo);
	mysql_hard = gnome_druid_page_standard_new_with_vals (_("Mysql Details"), logo);
	page_c = gnome_druid_page_standard_new_with_vals (_("Incoming Messages"), logo);
	page_d = gnome_druid_page_standard_new_with_vals (_("Outgoing Messages"), logo);
	page_finish = gnome_druid_page_finish_new_with_vals
   		(_("Setup Complete"),
    		_("Gmail is now setup and ready to go\nYou will already have 3 vfolders setup for you.\nPlease test gmail thoroughly and contribute to the mailing list."),
    		logo, NULL);


	/* Set each one up. Sorry it's all in one function :( */

	/* page_a - Identity */

  vbox = GNOME_DRUID_PAGE_STANDARD(page_a)->vbox;
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  table = gtk_table_new (4, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 5);

  /* Intro info */
  label = gtk_label_new (_("Your real name and reply-to address will be used as defaults in gmail.\nYou are able to modify the reply-to address when composing a new message."));
  /*gtk_misc_set_alignment (GTK_MISC (label), 1.0, 1);*/
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1,
	    GTK_FILL, GTK_FILL, 10, 10);

  /* your name */
  label = gtk_label_new (_("Your name:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
	    GTK_FILL, GTK_FILL, 10, 10);

  GmailApp->real_name = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), GmailApp->real_name, 1, 2, 1, 2,
	    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 10);


  /* reply-to address */
  label = gtk_label_new (_("Reply-to address:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
	    GTK_FILL, GTK_FILL, 10, 10);

  GmailApp->email = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), GmailApp->email, 1, 2, 2, 3,
	    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 10);

	/* Guess some defaults for the values.  */
	email = g_strdup_printf("%s@localhost", g_get_user_name());
  gtk_entry_set_text (GTK_ENTRY (GmailApp->email), email);
  gtk_entry_set_text (GTK_ENTRY (GmailApp->real_name), g_get_real_name());

	gtk_signal_connect (GTK_OBJECT (page_a), _("next"), (GtkSignalFunc) simple_druid_next_callback, (gpointer) page_b);
  gtk_signal_connect (GTK_OBJECT (page_a), _("back"), (GtkSignalFunc) druid_back_callback, (gpointer) page_start);
	gtk_signal_connect_object (GTK_OBJECT (page_a), _("cancel"), GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

	/* END page_a - Identity */


	/* page_b - Mysql Server */

  vbox = GNOME_DRUID_PAGE_STANDARD(page_b)->vbox;
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  table = gtk_table_new (4, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 5);

  /* Intro info */
  label = gtk_label_new (_("Gmail requires a running Mysql server accessible from this host.\nSee http://www.mysql.org to get Mysql.\nI haven't worked out whether gmail works with the GPL'ed version of mysql.\nYou need to temporarily tell me your mysql root username and password.\nBy default this is normally 'root' and password is NULL,\nif this is the case, just click on the Next button."));
	
  /*gtk_misc_set_alignment (GTK_MISC (label), 1.0, 1);*/
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1,
	    GTK_FILL, GTK_FILL, 10, 10);

  /* your name */
  label = gtk_label_new (_ ("Myql Root Username:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
	    GTK_FILL, GTK_FILL, 10, 10);

  GmailApp->root_user = gtk_entry_new();
  gtk_table_attach (GTK_TABLE (table), GmailApp->root_user, 1, 2, 1, 2,
	    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 10);


  /* reply-to address */
  label = gtk_label_new (_("Mysql Root Password:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
	    GTK_FILL, GTK_FILL, 10, 10);

  GmailApp->root_pass = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(GmailApp->root_pass), FALSE);
  gtk_table_attach (GTK_TABLE (table), GmailApp->root_pass, 1, 2, 2, 3,
	    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 10);

  gtk_entry_set_text (GTK_ENTRY (GmailApp->root_user), "root");

	gtk_signal_connect (GTK_OBJECT (page_b), _("next"), (GtkSignalFunc) simple_druid_next_callback, (gpointer) mysql_hard);
  gtk_signal_connect (GTK_OBJECT (page_b), _("back"), (GtkSignalFunc) druid_back_callback, (gpointer) page_a);
	gtk_signal_connect_object (GTK_OBJECT (page_b), _("cancel"), GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
	/* END page_b - Mysql Server */

	/* mysql_hard - Mysql Details */

  vbox = GNOME_DRUID_PAGE_STANDARD(mysql_hard)->vbox;
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

	gtk_box_pack_start (GTK_BOX (vbox), create_database_page(FALSE), FALSE, FALSE, 0); 

	gtk_entry_set_text (GTK_ENTRY (GmailApp->db_host_entry), "localhost");
	gtk_entry_set_text (GTK_ENTRY (GmailApp->db_user_entry), g_get_user_name());
	gtk_entry_set_text (GTK_ENTRY (GmailApp->db_pass_entry), "");
	gtk_entry_set_text (GTK_ENTRY (GmailApp->db_name_entry), "gmail");

	gtk_signal_connect (GTK_OBJECT (mysql_hard), "next", (GtkSignalFunc) mysql_next_callback, (gpointer) page_c);
  gtk_signal_connect (GTK_OBJECT (mysql_hard), "back", (GtkSignalFunc) druid_back_callback, (gpointer) page_b);
	gtk_signal_connect_object (GTK_OBJECT (mysql_hard), "cancel", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

	/* END mysql_hard - Mysql Details */



	/* page_c - Incoming Email */

  vbox = GNOME_DRUID_PAGE_STANDARD(page_c)->vbox;
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  table = gtk_table_new (5, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 5);

	label = gtk_label_new (_("\nPlease enter your POP3 server details.\nIf you mail is already delivered to this host, run a local POP3 server.\nSupport for unlimited POP3 servers is coming soon."));
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1,
		    GTK_FILL, GTK_FILL, 10, 10);

  label = gtk_label_new (_("POP3 username:"));
  gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    GTK_FILL, GTK_FILL, 10, 10);
  GmailApp->username_entry = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), GmailApp->username_entry, 1, 2, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 10);
  label = gtk_label_new (_("POP3 Password:"));
  gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
		    GTK_FILL, GTK_FILL, 10, 10);
  GmailApp->pop_password_entry = gtk_entry_new ();
	gtk_entry_set_visibility(GTK_ENTRY(GmailApp->pop_password_entry), FALSE);
  gtk_table_attach (GTK_TABLE (table), GmailApp->pop_password_entry, 1, 2, 2, 3,
		    GTK_FILL, GTK_FILL, 0, 10);
  label = gtk_label_new (_("POP3 server:"));
  gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
		    GTK_FILL, GTK_FILL, 10, 10);
  GmailApp->pop_server_entry = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), GmailApp->pop_server_entry, 1, 2, 3, 4,
		    GTK_FILL, GTK_FILL, 0, 10);

  gtk_entry_set_text (GTK_ENTRY (GmailApp->username_entry), g_get_user_name());
  gtk_entry_set_text (GTK_ENTRY (GmailApp->pop_server_entry), _("localhost"));

	gtk_signal_connect (GTK_OBJECT (page_c), "next", (GtkSignalFunc) simple_druid_next_callback, (gpointer) page_d);
  gtk_signal_connect (GTK_OBJECT (page_c), "back", (GtkSignalFunc) druid_back_callback, (gpointer) mysql_hard);
	gtk_signal_connect_object (GTK_OBJECT (page_c), "cancel", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
	/* END page_c - Incoming Email */

	/* page_d - Outgoing Email */

  vbox = GNOME_DRUID_PAGE_STANDARD(page_d)->vbox;
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  tooltips = gtk_tooltips_new ();
  table = gtk_table_new (2, 2, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 5);
  gtk_widget_show (table);

  gtk_container_set_border_width (GTK_CONTAINER (table), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5);

  GmailApp->smtp_server = gtk_entry_new ();
  gtk_widget_show (GmailApp->smtp_server);
  gtk_table_attach (GTK_TABLE (table), GmailApp->smtp_server, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, GmailApp->smtp_server, _("Enter your SMTP server here"), NULL);
  gtk_entry_set_text (GTK_ENTRY (GmailApp->smtp_server), _("localhost"));

  label = gtk_label_new (_("SMTP Server:"));
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);

  text = gtk_text_new (NULL, NULL);
  gtk_table_attach (GTK_TABLE (table), text, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                   _("Your SMTP server is a mail server used to send outgoing messages.\nIn many cases it is the same as your POP3 server.\nIf sendmail is configured on your local machine, leaving this as localhost should work.\nLater on your can change your preferences to let gmail use the local sendmail command, but the code isn't very stable.\nSMTP is the stable outgoing method."), -1);
  gtk_widget_show (text);
	gtk_signal_connect (GTK_OBJECT (page_d), "next", (GtkSignalFunc) simple_druid_next_callback, (gpointer) page_finish);
  gtk_signal_connect (GTK_OBJECT (page_d), "back", (GtkSignalFunc) druid_back_callback, (gpointer) page_c);
	gtk_signal_connect_object (GTK_OBJECT (page_d), "cancel", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

	/* END page_d - Outgoing Email */


	/* page_finish - Finish Page */

  gtk_signal_connect (GTK_OBJECT (page_finish), "back", (GtkSignalFunc) druid_back_callback, (gpointer) page_d);
	gtk_signal_connect (GTK_OBJECT (page_finish), "finish", (GtkSignalFunc) druid_finish, window);
	gtk_signal_connect_object (GTK_OBJECT (page_finish), "cancel", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

	/* END page_finish - Finish Page */




	/* Insert the pages into the Druid. */
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_start));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_a));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_b));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (mysql_hard));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_c));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_d));
	gnome_druid_append_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_finish));

	/* Set the first page. */
	gnome_druid_set_page (GNOME_DRUID (druid), GNOME_DRUID_PAGE (page_start));


  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG(window)->vbox), druid, FALSE, FALSE, 5);
	gtk_widget_show_all (window);
}

static gboolean
druid_back_callback (GnomeDruidPage *page, GnomeDruid *druid, gpointer data)
{
  GtkWidget *back_page = NULL;

  back_page = gtk_object_get_data (GTK_OBJECT (page), "back");
  if (back_page) {
      gtk_object_set_data (GTK_OBJECT (page), "back", NULL);
      gnome_druid_set_page (druid,
                    GNOME_DRUID_PAGE (back_page));
      return TRUE;
  }
  return FALSE;
}

static gboolean
mysql_next_callback (GnomeDruidPage *page, GnomeDruid *druid, GnomeDruidPage *next)
{
	gchar *ruser, *rpass, *user, *pass, *hostname, *db;
	GString *result;

	g_return_val_if_fail(GNOME_IS_DRUID_PAGE_STANDARD(page), FALSE);

	ruser = gtk_entry_get_text(GTK_ENTRY(GmailApp->root_user));
	rpass = gtk_entry_get_text(GTK_ENTRY(GmailApp->root_pass));
	hostname = gtk_entry_get_text (GTK_ENTRY (GmailApp->db_host_entry));
	user = gtk_entry_get_text (GTK_ENTRY (GmailApp->db_user_entry));
	pass = gtk_entry_get_text (GTK_ENTRY (GmailApp->db_pass_entry));
	db = gtk_entry_get_text (GTK_ENTRY (GmailApp->db_name_entry));

	if (strlen(rpass) == 0) rpass = NULL;
	if (strlen(pass) == 0) pass = NULL;

	/* FIXME: run a function to check if there is already a database
 	 * with these settings, and give the user the opportunity to use
 	 * them.
	 */
	result = setup_db(ruser, rpass, user, pass, hostname, db);

	if (result->len != 0) {
		GtkWidget *dialog;
		gchar *msg;

		msg = g_strdup_printf ("Failure: \n%s\nYou cannot continue until this error is fixed.", result->str);	
		dialog = gnome_message_box_new(msg, GNOME_MESSAGE_BOX_ERROR, "doh!", 0);
		gtk_window_set_modal(GTK_WINDOW (dialog), TRUE);
 		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
 		gtk_widget_show(dialog);
		g_free(msg);	
	} else {
		/* Success! */
  	gtk_object_set_data (GTK_OBJECT (next), "back", page);
  	gnome_druid_set_page (druid, next);
	}

	g_string_free(result, TRUE);

	return(TRUE);
}

static gboolean
simple_druid_next_callback (GnomeDruidPage *page, GnomeDruid *druid, GnomeDruidPage *next)
{
	g_return_val_if_fail(GNOME_IS_DRUID_PAGE_STANDARD(page), FALSE);
	

	/* Depending on the title of the page, we know where we are.
   * We take the values they have inputted and put them into the gmail config.
   * FIXME: Need to do error checking here and block them using a modal dialog
   */ 
	if (strcmp(GNOME_DRUID_PAGE_STANDARD (page)->title, "Identity") == 0) {

		/* g_print("Checking Identity details\n"); */
		gnome_config_set_string("/gmail/UserInfo/EmailAddress", gtk_entry_get_text(GTK_ENTRY(GmailApp->email)));
		gnome_config_set_string("/gmail/UserInfo/RealName", gtk_entry_get_text(GTK_ENTRY(GmailApp->real_name)));

		} else if (strcmp(GNOME_DRUID_PAGE_STANDARD (page)->title, "Incoming Messages") == 0) {

			/* g_print("Checking Incoming details\n"); */
			gnome_config_set_string("/gmail/mailsetups/default", "default");
			gnome_config_set_string("/gmail/mailsetup_default/username", gtk_entry_get_text(GTK_ENTRY(GmailApp->username_entry)));
			gnome_config_private_set_string("/gmail/mailsetup_default/password", gtk_entry_get_text(GTK_ENTRY(GmailApp->pop_password_entry)));
			gnome_config_set_string("/gmail/mailsetup_default/servername", gtk_entry_get_text(GTK_ENTRY(GmailApp->pop_server_entry)));
			gnome_config_set_bool("/gmail/mailsetup_default/leavemailonserver", TRUE);


		} else if (strcmp(GNOME_DRUID_PAGE_STANDARD (page)->title, "Outgoing Messages") == 0) {

			gnome_config_set_string("/gmail/mailsetup_default/smtp", gtk_entry_get_text(GTK_ENTRY(GmailApp->smtp_server)));
		}

  gtk_object_set_data (GTK_OBJECT (next), "back", page);
  gnome_druid_set_page (druid, next);

  return TRUE;
}


static void
druid_finish (GnomeDruidPage *page, GnomeDruid *druid, gpointer window)
{
	gchar *query;


	/* Apply database settings. */
	gnome_config_set_string("/gmail/MysqlServer/hostname", gtk_entry_get_text(GTK_ENTRY(GmailApp->db_host_entry)));
	gnome_config_set_string("/gmail/MysqlServer/username", gtk_entry_get_text(GTK_ENTRY(GmailApp->db_user_entry)));
	gnome_config_private_set_string("/gmail/MysqlServer/password", gtk_entry_get_text(GTK_ENTRY(GmailApp->db_pass_entry)));
	gnome_config_set_string("/gmail/MysqlServer/dbname", gtk_entry_get_text(GTK_ENTRY(GmailApp->db_name_entry)));
	gnome_config_set_int("/gmail/UserInfo/DatabaseVersion", DATABASE_VERSION);

	/* Set up the three standard queries. */
	query = g_strdup_printf("(direction = \"Incoming\" AND matched LIKE \"%%Inbox%%\")");
	gnome_config_set_string("/gmail/vfolders/Inbox", query);
	g_free(query);
	query = g_strdup_printf("(direction = \"Outgoing\")");
	gnome_config_set_string("/gmail/vfolders/Outbox", query);
	g_free(query);
	query = g_strdup_printf("(direction = \"Incoming\" AND readstatus = \"Unread\")");
	gnome_config_set_string("/gmail/vfolders/Unread", query);
	g_free(query);

	/* Lets give them a nice default font. */
	gnome_config_set_string("/gmail/fonts/mainfont", "-adobe-helvetica-medium-r-normal-*-*-120-*-*-p-*-iso8859-1");
	gnome_config_set_string("/gmail/fonts/boldfont", "-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");

	/* Other misc pop3 settings. */
	gnome_config_set_string("/gmail/UserInfo/CacheVfolders", "FALSE");

	/* Misc GUI settings. */
	gnome_config_set_string("/gmail/UserInfo/TwoPaneView", "FALSE");
	gnome_config_set_string("/gmail/UserInfo/display_first_message", "TRUE");

	gnome_config_sync();

	gtk_signal_handlers_destroy(GTK_OBJECT (druid));

 	gtk_widget_destroy(GTK_WIDGET (window));  

	gmail_init();	/* Go ahead with normal gmail start. */

	/* Set these because the welcome message will be unread. */
	mark_vfolder_unread_status_by_name("Inbox", TRUE);
	mark_vfolder_unread_status_by_name("Unread", TRUE);
}
