# First draft 05/01/96    Jianjun

#constrct a FitsTable object
# FitsTable FitsTableObjName FitsFileObjName chdu 

class VectorTable {
    inherit Table

    constructor {args} {}
    destructor         {}
    
    public variable father
    public variable cellSize
    private variable ffCmd
    protected variable isVariableVec 0 

    public method readInTable {} 
    public method makeVImage   {}
    public method getFather {}
    public method setFileName { fName }

    protected method drawTable {}
    protected method buildMenus {}
    protected method postMenus {}
    protected method realCloseCmd {}

    protected method readTabData {fCol fRow nCols nRows}
    protected method writeTabData {col row val}
    protected method getFormattedData {col row}
    protected method getRawData {col row}
    protected method putRawData {col row val}
    protected method getRawDataBlock { fCol fRow lCol lRow }
    protected method putRawDataBlock { fCol fRow data }

    private method powMakeImage {}
}

body VectorTable::constructor {args} {

    set colNum   [lindex $args 0]
    set father   [lindex $args 1]

# inherit some params from father
    set numRows        [$father cget -numRows]
    set isFailedToCopy [$father cget -isFailedToCopy]
    set ffCmd          [$father getFitsFileCmd]
    set fileName       [$father cget -fileName]
    set chdu           [$father cget -chdu]
    set colName  [$father getArray columnName $colNum]
    set colNull  [$father getArray columnNull $colNum]
    set colForm  [$father getArray columnForm $colNum]
    set colType  [$father getArray columnType $colNum]
    set colDim   [$father getArray columnDim  $colNum]
    set numCols  [$father getArray vecSize    $colNum]
    # pick the variable length array.
    if { $numCols < 0 } {
       set numCols [expr -$numCols]
       set isVariableVec 1
    }

    set cellSize [$father getArray cellWidth  $colNum]
    set fFObj    [$father cget -fFObj]
    set dispCols $numCols

    set justStarted 1

    $father addChild $this
}

body VectorTable::destructor {} {

    .fvwinkeeper signoff $droot

    set isBeingDestroyed 1
    destroy $droot

    $father freeChild $this
}


body VectorTable::setFileName { fName } {

   Table::setFileName $fName
   .fvwinkeeper signoff  $droot
   .fvwinkeeper register $droot "Vector Table" [urlTail $fName] $chdu \
         $this
}


body VectorTable::drawTable {} {

   Table::drawTable

   bind $droot <<Plot>>        [code $this plotCmd]
   bind $droot <<MakeVImg>>    [code $this makeVImage]
}


body VectorTable::buildMenus {} {
    global isMac
    
    if { $isMac } {
        set mBar .mbar.vtable
    } else {
        set mBar $droot.mbar
    }
    $droot config -menu $mBar
    
    if { ![winfo exists $mBar] } {

       buildNewMenus

       $mBar.tools add command -label "Plot..." \
             -command "doMenuEvent <<Plot>>"
       $mBar.tools add command -label "Make Image" \
             -command "doMenuEvent <<MakeVImg>>"

       $mBar.file  entryconfig "Export*"    -state disabled
    }
}


body VectorTable::postMenus {} {

   Table::postMenus

   if { $isVariableVec } {
      $mBar.tools entryconfig "Plot..."    -state disabled
      $mBar.tools entryconfig "Make Image" -state disabled
   } else {
      $mBar.tools entryconfig "Plot..."    -state normal
      $mBar.tools entryconfig "Make Image" -state normal
   }
   update idle
}   

body VectorTable::readInTable {} {
    global charPix

    set DC(height)   20
    set DC(width)     [expr (int(log10($numRows))+4)*$charPix]
    set DC(headroom) 20
    set DC(footroom) 40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace) 6
    set DC(interline)    0
    set DC(tmar)         6
    set DC(lmar)         8
    set DC(tabspace)     0

# use fits command setarray to initialize the rowState
# usage   setrowstate totalNumOfRos startRow endRow status 
# (0:normal, 1:selected, 2: deleted)
#    setarray rowState 0 [expr $numRows-1] 0
    setarray colState 0 [expr $dispCols-1] 0
#    
    set absXPos(0) [expr $DC(lmar) + $DC(width) + $DC(rightspace)]
    set colSelList {}
    for {set i 0} {$i < $numCols} {incr i} {
	set colState($i) 0
	set columnName($i) [expr $i+1]
	set columnType($i) " "
	set columnUnit($i) " "
	lappend colSelList [expr $i+1]
	set cellWidth($i) $cellSize 
	set cellPixWidth($i) [expr $charPix*(1+$cellWidth($i))]
	set absXPos([expr $i+1]) [expr $absXPos($i) + $cellPixWidth($i) \
                                                    + $DC(rightspace) ]
    }
    
    set tabType "Vector Table"
}


body VectorTable::makeVImage {} {
    global hasSAOtng hasDS9

    if { $fvPref::imgDisplayer == "SAOtng" && $hasSAOtng } {
       tk_messageBox -type ok -message "Vector columns cannot be\
             displayed with SAOtng. Please use POW instead."
    } elseif { $fvPref::imgDisplayer == "DS9" && $hasDS9 } {
       tk_messageBox -type ok -message "Vector columns cannot be\
             displayed with DS9. Please use POW instead."
    } else {
	powMakeImage
    }    
}

body VectorTable::powMakeImage {} {

   # get the pow widget 
    if { [winfo exist .pow.pow]!=1 } { 
	powInit .dummy
    }
    # load the entire vector table
    set tmpStr [$ffCmd load vtable [list $colName] NULL]
    set dataAddress [lindex $tmpStr 0]
    set dataType    [lindex $tmpStr 1]
    set dataSize    [lindex $tmpStr 2]

    set cleanFileName [urlTail $fileName]
    regsub -all " " ${cleanFileName}_$colName "" imgHandle
    set imgHandle $imgHandle
# the last param is for copying  data
    eval powCreateData $imgHandle $dataAddress $dataType \
		   $dataSize 1
# free the data array
    $fFObj freeVTable $dataAddress   

    powCreateImage $imgHandle $imgHandle 0 0 $numCols $numRows 0 1 0 1 \
		   pixels pixels counts
    powCreateGraph $imgHandle NULL $imgHandle pixels pixels \
		   detector detector \
		   [lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1] 
}

body VectorTable::realCloseCmd {} {
    $father refresh 0
    delete object $this
}

body VectorTable::getFather {} {
    return $father
}


##############################################
#
# Handle Reading/Writing/Formatting of Data
#

body VectorTable::writeTabData {col row val} {

   if { [regexp L $colType] == 1} {
      if { ([regexp -nocase {[ftu]} $val] == 0) || \
            ([string length $val] !=1)} {
         error "Logical column can only have value T, F or U"
         return
      } else {
         set val [string toupper $val]
      }
   }	
   set tmpStr [string toupper [string trim $val " "]]

   if { $tmpStr == "NULL" } {

      # float and double do not need a TNULL key for binary table
      if { $colNull == "NULL" && \
            ![regexp A|D|E|F|C|M|d|e|f $colType] } {
         error "\nNo NULL value is defined. Please write a\
               TNULLn keyword in the header first."
      }		
      set val "NULL"
         
   }

   putRawData $col $row $val
}

body VectorTable::readTabData {fCol fRow nCols nRows} {
   # col/row is 0-indexed

   if { $isVariableVec } {
      # Need to read/write entire row in Variable-length columns
      set fCol 1
      set lCol $numCols
   } else {
      incr fCol
      set lCol [expr $fCol+$nCols-1]
   }
   incr fRow
   for { set col $fCol } { $col <= $lCol } { incr col } {
      $ffCmd load tblock -noformat tabData [list $colName] $fRow \
            $nRows $col $col
   }
}

body VectorTable::getFormattedData {col row} {
   set val [getRawData $col $row]
   if { $val=="NULL" || $val==" " } {
      return $val
   }
   return [format $colForm $val]
}


body VectorTable::getRawData {col row} {
   set v $tabData($col,$row)
   if { $v!="NULL" && $v!=" " } {
      if { [regexp E $colType] } {
         return [format "%.7G" $v]
      } elseif { [regexp D $colType] } {
         return [format "%.15G" $v]
      }
   }
   return $v
}

body VectorTable::putRawData {col row val} {
   if { $isVariableVec } {
      # variable length vectors want to write the entire vector at
      # once so, build up list of values

      set tmpVecList {}
      set tabData($col,$row) $val
      for { set i 0 } { $i < $numCols } { incr i } {	
         if {$tabData($i,$row) == " "} break
         lappend tmpVecList $tabData($i,$row)
      }
      $ffCmd put table $colName 1 [expr $row+1] $tmpVecList
   } else {
      $ffCmd put table $colName [expr $col+1] [expr $row+1] [list $val]
   }
   readTabData $col $row 1 1
}

body VectorTable::getRawDataBlock { fCol fRow lCol lRow } {
   # col/row zero-indexed

   incr fRow
   incr lRow
   set range "${fRow}-${lRow}"
   set data {}
   for { set col $fCol } { $col<=$lCol } {} {
      incr col
      lappend data [$ffCmd get vtable -noformat $colName $col $range]
   }

   return $data
}

body VectorTable::putRawDataBlock { fCol fRow data } {

   if { $isVariableVec } {
      set col 1
   } else {
      set col [expr $fCol+1]
   }

   set nRows [llength [lindex $data 0]]
   set nCols [llength $data]

   for { set i 0 } { $i<$nRows } { incr i } {
      set rowData {}

      if { $isVariableVec } {
         # Must insert start of row
         for { set c 0 } { $c<$fCol } { incr c } {
            lappend rowData [getRawData $c $fRow]
         }
      }

      foreach cData $data {
         lappend rowData [lindex $cData $i]
      }

      if { $isVariableVec } {
         # Must append end of row
         for { set c [expr $fCol+$nCols] } { $c<$numCols } {incr c} {
            set v [getRawData $c $fRow]
            if { $v==" " } break
            lappend rowData $v
         }
      }

      incr fRow
      $ffCmd put table $colName $col $fRow $rowData
   }
}


#
#  End Data handlers
#
##############################################
