/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM Region Manager
 * File: evms2/engine/plugins/lvm/lvm_pv.h
 */ 

/* Functions exported from lvm_pv.c */
extern u_int64_t lvm_get_pe_start(lvm_physical_volume_t * pv_entry);
extern int lvm_allocate_pe_map(lvm_physical_volume_t * pv_entry);
extern lvm_physical_volume_t * lvm_allocate_physical_volume(storage_object_t * segment,
							    pv_disk_t * pv );
extern void lvm_deallocate_physical_volume(lvm_physical_volume_t * pv_entry);
extern int lvm_find_free_pv_number(lvm_volume_group_t * group);
extern lvm_physical_volume_t * lvm_create_pv_from_segment(storage_object_t * segment);
extern int lvm_check_segment_for_pe_size(storage_object_t * segment,
					 u_int32_t * pe_size);
extern lvm_physical_volume_t * lvm_get_pv_for_segment(storage_object_t * segment);
extern lvm_physical_volume_t * lvm_get_pv_for_name(char * name,
						   lvm_volume_group_t * group);
extern int lvm_update_pv_for_group(lvm_physical_volume_t * pv_entry,
				   lvm_volume_group_t * group);
extern void lvm_update_pv_for_no_group(lvm_physical_volume_t * pv_entry);
extern int lvm_get_available_stripes(lvm_volume_group_t * group);
extern lvm_physical_volume_t * lvm_get_selected_segment(list_anchor_t list);
extern inline int lvm_pv_has_available_extents(lvm_physical_volume_t * pv_entry);
extern inline int lvm_pv_num_available_extents(lvm_physical_volume_t * pv_entry);
extern inline int lvm_pe_is_valid(lvm_physical_volume_t * pv_entry, u_int32_t pe);
extern inline int lvm_pe_is_available(lvm_physical_extent_t * pe);
extern int lvm_get_available_objects(storage_container_t *container,
				     list_anchor_t *objects);

