/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __SNAP_DISCOVER_H__
#define __SNAP_DISCOVER_H__ 1

extern int get_snapshot_metadata(storage_object_t * snap_child,
				 snapshot_metadata_t ** metadata);
extern storage_object_t * find_origin(char * origin_name);
extern int write_snapshot_metadata(snapshot_volume_t * snap_volume,
				   boolean backup);
extern void erase_snapshot_metadata(storage_object_t * snap_child);
extern int erase_snapshot_header(snapshot_volume_t * snap_volume,
				 boolean backup);
extern void get_snapshot_state(snapshot_volume_t * snap_volume);
extern void get_origin_state(snapshot_volume_t * org_volume);

#endif

