/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvm2
 * File: evms2/engine/plugins/lvm2/move.h
 *
 */

extern int commit_container_moves(storage_container_t *container);

extern int can_move_stripe(logical_extent_map_t *le_maps);
extern int can_move_a_stripe(region_mapping_t *r_map);
extern int can_move_region_mapping(region_mapping_t *r_map,
				   u_int64_t max_consecutive_extents);
extern int can_move_a_region_mapping(storage_object_t *region);

extern int move_region_mapping(storage_object_t *region,
			       option_array_t *options);
