/*----------------------------------------------------------------------
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * include file:  messages.h
 *---------------------------------------------------------------------*/

/*----------------------------------------------------------------------
 * Change History:
 *
 * 11/2001  John Stiles   Initial version.
 *
 *---------------------------------------------------------------------*/


/* Identify this file. */
#define MESSAGES_H   1


/*----------------------------------------------------------------------
 * Global Variables
 *---------------------------------------------------------------------*/

#if  CONTROL_C || VOLUMES_C
  static char title_volumes[] = _( " Logical Volumes " );
#endif

#ifdef VOLUMES_C
  char vol_name_col[] = _( " Volume Name" );
  #define X_VOL_NAME      40
  char vol_size_col[] = _( "  Size  " );
  #define X_VOL_SIZE      40
  char vol_minor_col[] = _( "Minor " );
  #define X_VOL_MINOR     54
  char vol_dirty_col[] = _( "Dirty " );
  #define X_VOL_DIRTY     61
  char vol_new_col[] = _( "New " );
  #define X_VOL_NEW       68
  char vol_selectmsg[] = _( "Select a Volume and press enter for Actions." );
  char vol_displaydetsel[] = _( "Display Volume Details" );
  char vol_removesel[] = _( "Remove Volume from Storage Object" );
  char vol_destroysel[] = _( "Destroy the Volume" );
  char vol_expandsel[] = _( "Expand the Volume" );
  char vol_shrinksel[] = _( "Shrink the Volume" );
  char vol_setinfsel[] = _ ( "Modify Volume Properties" );  
  char vol_mkfssel[] = _ ( "Make File System" );    
  char vol_fscksel[] = _ ( "Check/Repair File System" );    
  char vol_defragsel[] = _ ( "Defragment File System" );    
  char vol_unmkfssel[] = _ ( "Remove File System" );      
  char info_no_volumes[] = _( " No Logical Volumes found." );
  char err_msg_set_name[] = _( "evms_set_volume_name() error, rc ==" );  
  char info_msg_set_name_ok[] = _( "Modify was successful, press any key to continue" );  
#endif

#if  ACTIONS_C
  char title_expandpt[] = _( " Select Expansion Point " );
  char expand_ding[] = _( "Expanding" );
  char expand_ptname_col[] = _( " Name" );
  #define X_EXPPT_SIZE    45
  char expand_ptsize_col[] = _( "Maximum Expand Size" );
  char expand_expandpt[] = _( "Select an Expansion Point and press enter." );
  char info_msg_get_expandpt[] = _( "evms_get_expand_points() returned" );
  char err_msg_no_expandpt[] = _( "Could not get Expand Points, press any key." );
  char err_msg_get_expandpt[] = _( "evms_get_expand_points() error, rc ==" );
  char info_msg_entries1[] = _( "entries" );

  char title_shrinkpt[] = _( " Select Shrink Point " );
  char shrink_ing[] = _( "Shrinking" );
  char shrink_ptname_col[] = _( " Name" );
  #define X_SHRKPT_SIZE    45
  char shrink_ptsize_col[] = _( "Maximum Shrink Size" );
  char shrink_shrinkpt[] = _( "Select a Shrink Point and press enter." );
  char info_msg_get_shrinkpt[] = _( "evms_get_shrink_points() returned" );
  char err_msg_no_shrinkpt[] = _( "Could not get Shrink Points, press any key." );
  char err_msg_get_shrinkpt[] = _( "evms_get_shrink_points() error, rc ==" );

  char title_sel_plugin[] = _( "Select a Plugin: " );
  #define X_PLUG_DESC     20
  char plugin_select1[] = _( "Select a Plugin to use and press enter." );

  char info_msg_get_acceptable[] = _( "evms_get_acceptable_objects() returned" );
  char err_msg_get_acceptable[] = _( "evms_get_acceptable_objects() error, rc ==" );
  char info_msg_get_selobjlimits[] = _( "evms_get_selected_object_limits() min, max == " );
  char err_msg_get_selobjlimits[] = _( "evms_get_selected_object_limits() error, rc ==" );
  char info_msg_get_selobjects[] = _( "evms_get_selected_objects() returned" );
  char err_msg_get_selobjects[] = _( "evms_get_selected_objects() error, rc ==" );
  char err_msg_set_selectedobj[] = _( "evms_set_selected_objects() error, rc ==" );
  char setobj_one_select[] = _( "Select One of the Item(s):" );
  char setobj_many_select[] = _( "Select %i Items:" );
  char setobj_range_select[] = _( "Select %i to %i Items:" );
  char setobj_select_col[] = _( "Select" );
  char setobj_size_col[] = _( " Size" );
  #define X_OBJSEL_SIZE    7
  char setobj_name_col[] = _( " Object Name" );
  #define X_OBJSEL_NAME    18
  char setobj_space_select[] = _( "Use spacebar to select the item." );
  char setobj_space_enter[] = _( "Use spacebar to select the item, enter to continue." );

  char selobj_many_select[] = _( "Select One or more Items:" );
  char selobj_name_col[] = _( " Item Name" );

  char editopt_space_select[] = _( "Use spacebar to change the item." );
  char editopt_number_enter[] = _( "Type in a number, then press Enter." );

  char err_msg_get_optdesc[] = _( "evms_get_option_descriptor() for entry" );
  char setopt_indicate_req[] = _( ") indicates a Required Option." );
  #define SETOPT_REQUIRED_CHAR  '*'
  char setopt_opt_is_list[] = _( "Option is a List." );
  char setopt_opt_not_active[] = _( "Option is not Active." );
  char setopt_space_select[] = _( "Use spacebar to select and Edit the item." );
  char setopt_space_enter[] = _( "Use spacebar to select and Edit the item, enter to finish." );

  char err_msg_no_accept_objs[] = _( "Could not get any Acceptable Objects, press any key." );
  char err_msg_accept_objs_rc[] = _( "Select Acceptable Objects failed, rc ==" );

  char create_nocreate[] = _( "Do not create" );
  char create_docreate[] = _( "Create" );
  char info_msg_create_ok[] = _( "Create was successful, press any key to continue" );
  char err_msg_create_fail[] = _( "Create failed, rc == %i" );
#endif

#if  CONTROL_C || ACTIONS_C || VOLUMES_C
  static char info_msg_get_pluglist[] = _( "evms_get_plugin_list() returned" );
  static char err_msg_get_pluglist[] = _( "evms_get_plugin_list() error, rc ==" );
  static char err_msg_no_plugins[] = _( "Could not get a Plugin to use, press any key." );  
  static char err_msg_create_task[] = _( "evms_create_task() error, rc ==" );  
#endif

#if  CONTROL_C || OBJECTS_C
  static char title_availobjs[] = _( " Available Topmost Storage Objects " );
  static char title_regions[] = _( " Storage Regions " );
  static char title_containers[] = _( " Storage Containers " );
  static char title_segments[] = _( " Disk Segments " );
  static char title_disks[] = _( " Logical Disks " );
  static char title_plugins[] = _( " Plugins " );
#endif

#if  OBJECTS_C || ACTIONS_C
  static char plug_name_col[] = _( "  Name  " );
  static char plug_desc_col[] = _( "  Description " );

  static char info_msg_get_extinfo[] = _( "evms_get_extended_info() returned" );
  static char info_msg_getitems[] = _( "items" );
  static char err_msg_get_extinfo[] = _( "evms_get_extended_info() error, rc ==" );
  static char ext_info_when_done[] = _( "Press Esc or Enter when finished." );
  static char info_no_ext_info[] = _( "No Detailed Information available, press any key to continue." );
#endif

#if  OBJECTS_C || VOLUMES_C
  static char action_selectmsg[] = _( "Select an action and press enter." );
  static char object_treeviewsel[] = _( "View Object Tree" );
#endif

#if  OBJECTS_C
  char object_name_col[] = _( " Object Name" );
  char object_size_col[] = _( "  Size  " );
  #define X_OBJECT_SIZE     35
  char object_plugin_col[] = _( " Plugin " );
  #define X_OBJECT_PLUGIN   46
  char object_dirty_col[] = _( "Dirty" );
  #define X_OBJECT_DIRTY    61
  // char object_biosr_col[] = _( "BIOS Readable" );
  char object_biosr_col[] = _( "BIOS R" );
  #define X_OBJECT_BIOSR    68
  char object_selectmsg[] = _( "Select a Storage Object and press enter for Actions." );
  char object_createnew[] = _( "Create a New Feature Object" );
  char object_displaydetsel[] = _( "Display Storage Object Details" );
  char object_removesel[] = _( "Remove Top Level Object or Feature" );
  char object_destroysel[] = _( "Destroy the Storage Object" );
  char object_expandsel[] = _( "Expand the Storage Object" );
  char object_shrinksel[] = _( "Shrink the Storage Object" );
  char object_createevmssel[] = _( "Create EVMS Volume from Storage Object" );
  char object_createcompatsel[] = _( "Create Compatibility Volume from Storage Object" );
  char object_setinfsel[] = _ ( "Modify Storage Object Properties" );
  char info_no_availobjs[] = _( " No Available Topmost Storage Objects found." );

  char region_name_col[] = _( " Region Name" );
  char region_size_col[] = _( "  Size  " );
  #define X_REGION_SIZE     30
  char region_plugin_col[] = _( " Plugin " );
  #define X_REGION_PLUGIN   41
  char region_alloc_col[] = _( "Alloc." );
  #define X_REGION_ALLOC    56
  char region_dirty_col[] = _( "Dirty" );
  #define X_REGION_DIRTY    63
  // char region_biosr_col[] = _( "BIOS Readable" );
  char region_biosr_col[] = _( "BIOSR" );
  #define X_REGION_BIOSR    69
  char region_selectmsg[] = _( "Select a Region and press enter for Actions." );
  char region_createnew[] = _( "Create a New Region" );
  char region_displaydetsel[] = _( "Display Region Details" );
  char region_removesel[] = _( "Remove Region from Storage Object" );
  char region_destroysel[] = _( "Destroy the Region" );
  char region_expandsel[] = _( "Expand the Region" );
  char region_shrinksel[] = _( "Shrink the Region" );
  char region_createevmssel[] = _( "Create EVMS Volume from the Region" );
  char region_createcompatsel[] = _( "Create Compatibility Volume from the Region" );
  char region_setinfsel[] = _ ( "Modify Region Properties" );  
  char region_contremove[] = _( "Remove Region from Consuming Container" );  
  char info_no_regions[] = _( " No Storage Regions found." );

  char contain_name_col[] = _( " Container Name" );
  char contain_size_col[] = _( "  Size  " );
  #define X_CONTAIN_SIZE     40
  char contain_plugin_col[] = _( " Plugin " );
  #define X_CONTAIN_PLUGIN   51
  char contain_dirty_col[] = _( "Dirty" );
  #define X_CONTAIN_DIRTY    67
  char contain_selectmsg[] = _( "Select a Container and press enter for Actions." );
  char contain_createnew[] = _( "Create a New Container" );
  char contain_displaydetsel[] = _( "Display Container Details" );
  char contain_removesel[] = _( "Remove Container from Storage Object" );
  char contain_destroysel[] = _( "Destroy the Container" );
  char contain_expandsel[] = _( "Expand the Container" );
  char contain_shrinksel[] = _( "Shrink the Container" );
  char contain_createevmssel[] = _( "Create EVMS Volume from the Container" );
  char contain_createcompatsel[] = _( "Create Compatibility Volume from the Container" );
  char contain_setinfsel[] = _ ( "Modify Container Properties" );  
  char info_no_containers[] = _( " No Storage Containers found." );

  char seg_name_col[] = _( " Segment Name" );
  char seg_size_col[] = _( "  Size  " );
  #define X_SEG_SIZE     16
  char seg_stlba_col[] = _( "Start LBA " );
  #define X_SEG_STLBA     27
  char seg_type_col[] = _( "Type" );
  #define X_SEG_TYPE      44
  char seg_type_meta[] = _( "Metadata" );
  char seg_type_free[] = _( "Freespace" );
  char seg_type_prim[] = _( "Primary" );
  char seg_type_extn[] = _( "Extended" );
  char seg_type_data[] = _( "Data" );
  char seg_dirty_col[] = _( "Dirty" );
  #define X_SEG_DIRTY    54
  // char seg_biosr_col[] = _( "BIOS Readable" );
  char seg_biosr_col[] = _( "BIOS R" );
  #define X_SEG_BIOSR    60
  char seg_selectmsg[] = _( "Select a Segment and press enter for Actions." );
  char seg_createnew[] = _( "Create a New Segment" );
  char seg_displaydetsel[] = _( "Display Segment Details" );
  char seg_removesel[] = _( "Remove Segment from Storage Object" );
  char seg_destroysel[] = _( "Destroy the Segment" );
  char seg_expandsel[] = _( "Expand the Segment" );
  char seg_shrinksel[] = _( "Shrink the Segment" );
  char seg_createevmssel[] = _( "Create EVMS Volume from the Segment" );
  char seg_createcompatsel[] = _( "Create Compatibility Volume from the Segment" );
  char seg_setinfsel[] = _ ( "Modify Segment Properties" );  
  char seg_contremove[] = _( "Remove Segment from Consuming Container" );
  char info_no_segments[] = _( " No Disk Segments found." );

  char disk_name_col[] = _( " Disk Name" );
  char disk_size_col[] = _( "  Size  " );
  #define X_DISK_SIZE     22
  char disk_geo_col[] = _( "Geometry (CHS)" );
  #define X_DISK_GEO      33
  char disk_dirty_col[] = _( "Dirty" );
  #define X_DISK_DIRTY    50
  char disk_error_col[] = _( "Errors" );
  #define X_DISK_ERRORS   56
  char disk_corrupt_col[] = _( "Corrupt" );
  #define X_DISK_CORRUPT  63
  char disk_unuse_col[] = _( "Unusable" );
  #define X_DISK_UNUSE    70
  char disk_selectmsg[] = _( "Select a Disk and press enter for Actions." );
  char disk_displaydetsel[] = _( "Display Disk Details" );
  char disk_createevmssel[] = _( "Create EVMS Volume from the Disk" );
  char disk_createcompatsel[] = _( "Create Compatibility Volume from the Disk" );
  char disk_setinfsel[] = _ ( "Modify Disk Properties" );  
  char disk_contremove[] = _( "Remove Disk from Consuming Container" );  
  char disk_assignpluginsel[] = _( "Assign Segment Manager to Disk" );
  char info_no_disks[] = _( " No Logical Disks found." );

  char plug_id_col[] = _( "PluginID " );
  #define X_PLUG_ID       15
  char plug_vers_col[] = _( "Version" );
  #define X_PLUG_VERS     25
  #define X_PLUG_DESC     34
  char plug_oem_col[] = _( "Devel." );
  #define X_PLUG_OEM      67
  char plugins_selectmsg[] = _( "Press enter to see Plugin Details." );
  char info_no_plugins[] = _( " No Plugins found." );

  char title_treeview[] = _( " Tree Object View " );
  char tree_selectmsg[] = _( "Press enter to see Object Details." );
#endif

#ifdef CONTROL_C
  char title_nooptions[] = _( " No options yet... press enter to continue. " );
  char title_actions[] = _( " Select an Action: " );
  char title_plugin_info[] = _( " Plugin Details: " );

  char info_msg_get_vollist[] = _( "evms_get_volume_list() returned" );
  char info_msg_get_objlist[] = _( "evms_get_object_list() returned" );
  char info_msg_get_contlist[] = _( "evms_get_container_list() returned" );
  char info_msg_entries[] = _( "entries" );

  char err_msg_get_vollist[] = _( "evms_get_volume_list() error, rc ==" );
  char err_msg_get_objlist[] = _( "evms_get_object_list() error, rc ==" );
  char err_msg_get_contlist[] = _( "evms_get_container_list() error, rc ==" );
#endif

#if  CONTROL_C || VOLUMES_C || OBJECTS_C || ACTIONS_C || DISPLAY_C || EVMSN_C
  static char err_msg_malloc_blanks[] = _( "could not malloc storage for blanks buffer." );
#endif

#if  VOLUMES_C || OBJECTS_C || ACTIONS_C
  static char err_msg_get_info[] = _( "evms_get_info() for entry" );
  static char err_msg_rc[] = _( "returned error, rc ==" );
#endif

#ifdef EVMSN_C
  char info_press_any_keyc[] = _( "Press any key to continue." );
  char info_press_any_keyx[] = _( "Press any key to exit." );
#endif

