/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: region_cb.c
 */ 
 
#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"
#include "destroy.h"
#include "revert.h"
#include "transfer.h"
#include "plugin_cb.h"
#include "region_cb.h"

/*
 *
 *   void on_destroy_region_button_clicked (GtkButton *, gpointer)
 *
 *   Description:
 *      This routine initiates the Destroy API call using the handle
 *      of the region associated with the last row  selected. It then 
 *      creates and displays the results popup which destroys both 
 *      windows when dismissed.
 * 
 *   Entry:
 *      button    - address of the GtkButton widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      See description.
 *
 */
void on_destroy_region_button_clicked (GtkButton *button, gpointer user_data)
{
    gchar *error_msg   = _("An error was encountered attempting to destroy the storage region.");
    gchar *success_msg = _("The storage region was successfully destroyed.");

    on_destroy_thing_button_clicked (button, error_msg, success_msg);
}

/*
 *
 *   void on_destroy_region_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of regions that can be destroyed.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable regions
 *
 */
void on_destroy_region_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_destroy_thing_clist_realize (widget, REGION);
}

/*
 *
 *   void on_remove_regions_from_container_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of regions that can be removed from their consuming
 *      container.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable regions
 *
 */
void on_remove_region_from_container_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_remove_thing_from_container_clist_realize (widget, REGION);
}

/*
 *
 *   void on_region_manager_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of region manager plugins to choose from.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with available region manager plugins
 *
 */
void on_region_manager_clist_realize (GtkWidget *widget, gpointer user_data)
{
    set_selection_window_clist_column_titles (GTK_CLIST (widget), _("Region Manager Plugin"), NULL, NULL);   
    on_plugin_selection_clist_realize (GTK_CLIST (widget), EVMS_REGION_MANAGER, 0);
}

/*
 *
 *   void on_remove_region_button_clicked (GtkButton *, gpointer)
 *
 *   Description:
 *      This routine invokes the function that removes a region
 *      from the top of a storage object stack.
 * 
 *   Entry:
 *      button    - address of the GtkButton widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      The region is removed and a results screen is displayed.
 *
 */
void on_remove_region_button_clicked (GtkButton *button, gpointer user_data)
{
    gchar *error_msg   = _("An error was encountered attempting to remove the storage region.");
    gchar *success_msg = _("The storage region was successfully removed from the storage object stack.");

    on_revert_thing_button_clicked (button, error_msg, success_msg);
}

/*
 *
 *   void on_remove_region_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of regions that can be removed from the top of a storage
 *      object stack.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with regions
 *
 */
void on_remove_region_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_revert_thing_clist_realize (widget, REGION);
}
