/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: is_lvm_region.c
 */ 

#ifndef _LVM_HELP_IS_LVM_REGION_
#define _LVM_HELP_IS_LVM_REGION_ 1

/* Function: is_lvm_region
 *
 *	Determine if the specified region belongs to LVM.
 *	Return non-zero if true, zero if false.
 */
int is_lvm_region( object_handle_t region )
{
	handle_object_info_t	* region_info = NULL;
	handle_object_info_t	* plugin_info = NULL;
	int			rc;

	if ( evms_get_info(region, &region_info) ||
	     ! region_info ) {
		return FALSE;
	}

	if ( evms_get_info(region_info->info.region.plugin, &plugin_info) ||
	     ! plugin_info ) {
		evms_free(region_info);
		return FALSE;
	}
	evms_free(region_info);

	rc = ( plugin_info->info.plugin.id == SetPluginID( EVMS_OEM_IBM,
							EVMS_REGION_MANAGER,
							0x01) );
	evms_free(plugin_info);
	return rc;
}

#endif

