/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_io.h
 */ 

#ifndef _MD_IO_H_
#define _MD_IO_H_ 1


#define READ( object, lsn, count, buf )  ((object->plugin->functions.plugin)->read(  object, lsn, count, buf ))
#define WRITE(object, lsn, count, buf )  ((object->plugin->functions.plugin)->write( object, lsn, count, buf ))
#define KILL_SECTORS(object, lsn, count) ((object->plugin->functions.plugin)->add_sectors_to_kill_list( object, lsn, count ))
//#define SET_STRING_FIELD(a,b) a = EngFncs->engine_alloc( strlen(b)+1 );if (a ) { strcpy(a, b); } else { rc = ENOMEM; LOG_EXIT return rc;}

// Endian conversion macros. Disk-order on Linux is little-endian
#if __BYTE_ORDER == __BIG_ENDIAN
#define MEM_DISK16(x)	x = bswap_16(x)
#define MEM_DISK32(x)	x = bswap_32(x)
#define MEM_DISK64(x)	x = bswap_64(x)

#elif __BYTE_ORDER == __LITTLE_ENDIAN
#define MEM_DISK16(x)
#define MEM_DISK32(x)
#define MEM_DISK64(x)

#else
#error "__BYTE_ORDER must be defined as __LITTLE_ENDIAN or __BIG_ENDIAN"

#endif

// Functions exported from md_io.c

int md_delete_volume(md_volume_t * volume);
#endif

