/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: solarisX86.h
 *
 */

#ifndef SOLARISX86_HEADER
#define SOLARISX86_HEADER 1


// partition fs types
#define SOLARISX86_TAG_UNUSED           0
#define SOLARISX86_TAG_BOOT             1
#define SOLARISX86_TAG_ROOT             2
#define SOLARISX86_TAG_SWAP             3
#define SOLARISX86_TAG_USR              4
#define SOLARISX86_TAG_ENTIRE_DISK      5
#define SOLARISX86_TAG_STAND            6
#define SOLARISX86_TAG_VAR              7
#define SOLARISX86_TAG_HOME             8
#define SOLARISX86_TAG_ALT_SECTORS      9
#define SOLARISX86_TAG_CACHE_FS        10

// partition flags
#define SOLARISX86_FLAG_UNMOUNTABLE     1
#define SOLARISX86_FLAG_READ_ONLY      10


#ifdef NEED_SOLARISX86_NAMES

// I cant find much information about solaris partitions
#define SOLARISX86_TAG_NAME_COUNT 11
static const char *solarisx86_names[SOLARISX86_TAG_NAME_COUNT]={
     "UNUSED",
     "BOOT",
     "ROOT",
     "SWAP",
     "USR",
     "WHOLE DISK",
     "STAND",
     "VAR",
     "HOME",
     "ALT SECTORS",
     "CACHE FS"
};

#endif


#define SOLARIS_X86_NUMSLICE    8
#define SOLARIS_X86_VTOC_SANE   (0x600DDEEEUL)

struct solaris_x86_slice {
    ushort  s_tag;          /* ID tag of partition */
    ushort  s_flag;         /* permission flags */
    unsigned int s_start;       /* start sector no of partition */
    unsigned int s_size;        /* # of blocks in partition */
};

struct solaris_x86_vtoc {
    unsigned int v_bootinfo[3]; /* info needed by mboot (unsupported) */
    unsigned int v_sanity;      /* to verify vtoc sanity */
    unsigned int v_version;     /* layout version */
    char    v_volume[8];        /* volume name */
    ushort  v_sectorsz;     /* sector size in bytes */
    ushort  v_nparts;       /* number of partitions */
    unsigned int v_reserved[10];    /* free space */
    struct solaris_x86_slice
        v_slice[SOLARIS_X86_NUMSLICE]; /* slice headers */
    unsigned int timestamp[SOLARIS_X86_NUMSLICE]; /* timestamp (unsupported) */
    char    v_asciilabel[128];  /* for compatibility */
};


int do_solaris_x86_partition_discover( LOGICALDISK *ld, Partition_Record *part );
int do_solaris_x86_partition_commit( LOGICALDISK *ld, DISKSEG *seg );

#endif

