/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: segs.h
 *
 */
#ifndef SEGS_HEADER
#define SEGS_HEADER

extern dlist_t     Disk_PrivateData_List;



char *             get_disk_name( storage_object_t *seg );
int                get_name_for_disk_segment( DISKSEG *seg );
DISKSEG *          allocate_disk_segment( LOGICALDISK *ld );
void               free_disk_segment( DISKSEG *seg);

int                create_disk_private_data( LOGICALDISK  *ld );
int                delete_disk_private_data( LOGICALDISK *ld );
DISK_PRIVATE_DATA *get_disk_private_data( LOGICALDISK *ld );

sector_count_t     get_cylinder_size( storage_object_t *obj );
BOOLEAN            below_1024_cylinder_limit(LOGICALDISK *ld,  lba_t  lba );
BOOLEAN            ends_on_cylinder_boundary( LOGICALDISK *ld, lba_t lba );
BOOLEAN            starts_on_cylinder_boundary( LOGICALDISK *ld, lba_t lba );
lba_t              roundup_to_cylinder_boundary( LOGICALDISK *ld, lba_t lba );
lba_t              rounddown_to_cylinder_boundary( LOGICALDISK *ld, lba_t lba );

BOOLEAN            disk_has_extended_partition( LOGICALDISK *ld );
BOOLEAN            seglist_has_mbr_segment( dlist_t  seglist );
DISKSEG *          get_mbr_from_seglist( dlist_t  seglist );

int                get_first_unused_ptable_entry( dlist_t  seglist, DISKSEG *ebr );
int                get_ptable_entry_count( dlist_t  seglist, DISKSEG *ebr );

DISKSEG *          get_first_freespace_seg_in_list( dlist_t seglist );

BOOLEAN            freespace_follows_seg( DISKSEG *seg );

DISKSEG *          get_freespace_following_seg( DISKSEG *seg );
DISKSEG *          find_freespace_in_seglist( dlist_t  seglist );
int                find_freespace_on_disk( LOGICALDISK *ld );

int                remove_diskseg_from_list( dlist_t  seglist, DISKSEG *seg );
void *             insert_diskseg_into_list( dlist_t  seglist, DISKSEG *seg);
void *             insert_diskseg_into_ordered_list( dlist_t  seglist, DISKSEG *seg);
int                merge_adjacent_freedisksegs_in_list( dlist_t seglist );

int                create_mbr_For_Disk( LOGICALDISK *ld, char *DiskName, BOOLEAN isa_os2_disk );
DISKSEG *          build_mbr_disk_segment( LOGICALDISK *ld );
DISKSEG *          build_ebr_disk_segment( LOGICALDISK      *ld,
                                           Partition_Record *part,
                                           DISKSEG          *ebr,
                                           lba_t             ebr_lba,
                                           u_int32_t         ptable_index,
                                           BOOLEAN           primary_partition_flag );


DISKSEG *          build_diskseg_from_partition_record( LOGICALDISK      *ld,
                                                        Partition_Record *part,
                                                        DISKSEG          *ebr,
                                                        u_int32_t         ptable_index,
                                                        BOOLEAN           primary_partition_flag );


int                LBA_to_Ptable_CHS( LOGICALDISK *ld, lba_t  lba, chs_t  *chs );
int                LBAtoCHS( LOGICALDISK *ld, lba_t  lba, chs_t  *chs );
int                CHStoLBA( LOGICALDISK *ld, chs_t  *chs, lba_t *callers_lba );

int                fixup_logical_partition_names( LOGICALDISK *ld );
void               fixup_EBR_Names( LOGICALDISK *ld );
int                fixup_EBR_Chain( LOGICALDISK *ld );
void               fixup_disk_extd_partition_dimensions( LOGICALDISK *ld );
void               fixup_disk_extd_partition_anchor( LOGICALDISK *ld );

int                create_logical_partition( LOGICALDISK *ld, DISKSEG *seg, DLA_Entry *dla, DISKSEG *freespace, sector_count_t offset );
int                create_primary_partition( LOGICALDISK *ld, DISKSEG *seg, DLA_Entry *dla );

BOOLEAN            seg_is_within_or_adjacant_to_extended_partition( LOGICALDISK *ld, DISKSEG *seg );
BOOLEAN            seg_is_within_the_extended_partition( LOGICALDISK *ld, DISKSEG *seg );


BOOLEAN            seg_is_volitile( DISKSEG *seg );
int                diskseg_to_container_segment( DISKSEG *seg );
void               revert_container_segment( DISKSEG *seg );
BOOLEAN            seg_is_within_container_segment( DISKSEG *seg );
BOOLEAN            seg_overlaps_container_segment( DISKSEG *seg );
int                remove_container_seg_overlap( DISKSEG *seg);


DISKSEG *          only_child( DISKSEG *seg );

#endif
