/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: task.h
 *
 */
/*
 * Global functions exported by task.c
 */

/* External APIs provided by task.c */

extern int evms_create_task(engine_handle_t thing,
                            task_action_t   action,
                            task_handle_t * new_task_context);

extern int evms_invoke_task(task_handle_t      handle,
                            handle_array_t * * resulting_objects);

extern int evms_destroy_task(task_handle_t handle);

extern int evms_get_task_action (task_handle_t handle, task_action_t *action);

extern int evms_get_acceptable_objects(task_handle_t      task,
                                       handle_array_t * * acceptable_object_list);

extern int evms_get_selected_objects(task_handle_t      task,
                                     handle_array_t * * selected_object_list);

extern int evms_get_selected_object_limits(task_handle_t task,
                                           u_int32_t   * miminum,
                                           u_int32_t   * maximum);

extern int evms_set_selected_objects(task_handle_t               task,
                                     handle_array_t            * selected_object_list,
                                     declined_handle_array_t * * declined_list,
                                     task_effect_t             * effect);
