/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 */

// Global data exported by engine.c

extern dlist_t PluginList;
extern dlist_t DiskList;
extern dlist_t SegmentList;
extern dlist_t ContainerList;
extern dlist_t RegionList;
extern dlist_t EVMSObjectList;
extern dlist_t VolumeList;
extern dlist_t KillSectorList;
extern dlist_t SoftVolumeDeleteList;
extern dlist_t HardVolumeDeleteList;
extern dlist_t VolumeRemoveList;
extern dlist_t VolumeDataList;

extern BOOLEAN changes_pending; /* TRUE means some change was made to the current
                                   configuration and a commit would be needed
                                   to force the change to disk. */

extern engine_mode_t    engine_mode;
extern debug_level_t    debug_level;

extern char           * log_file_name;
extern int              log_file;
extern u_char           log_buf[];
#define LOG_BUF_SIZE    1024

extern int              evms_block_dev_handle;

/*
 * Global functions exported by engine.c
 */

/* External APIs provided by engine.c */

extern void evms_get_api_version(evms_version_t * version);

extern int evms_open_engine(engine_mode_t                mode,
                            engine_message_functions_t * callbacks,
                            debug_level_t                level,
                            char                       * log_name);

extern int evms_close_engine(void);

extern BOOLEAN evms_changes_pending(void);

extern int evms_rediscover(void);

extern int evms_get_debug_level(debug_level_t * level);

extern int evms_set_debug_level(debug_level_t level);

extern int evms_get_kernel_info_level(debug_level_t * level);

extern int evms_set_kernel_info_level(debug_level_t level);

extern int evms_write_log_entry(debug_level_t level,
                                char        * module_name,
                                char        * fmt,
                                ...);

extern int evms_get_plugin_list(evms_plugin_code_t    type,
                                plugin_search_flags_t flags,
                                handle_array_t    * * plugin_list);

extern int evms_get_plugin_by_ID(plugin_id_t       plugin_ID,
                                 object_handle_t * plugin_handle);

extern int evms_get_plugin_by_name(char            * plugin_name,
                                   object_handle_t * plugin_handle);

extern int evms_update_evms_dev_tree(u_int32_t verbose_level);

/* Internal functions to share with other Engine source modules */

extern void timestamp(char * buf,
                      size_t len);

extern int engine_write_log_entry(debug_level_t level,
                                  char        * fmt,
                                  ...);

extern int open_evms_block_dev(void);

extern void close_evms_block_dev(void);

extern int get_kernel_volume_data(void);

extern int check_engine_read_access(void);

extern int check_engine_write_access(void);

extern int ensure_app_handle(void *            object,
                             object_type_t     object_type,
                             object_handle_t * app_handle);

extern int make_handle_entry(ADDRESS object,
                             TAG     tag,
                             uint    object_size,
                             ADDRESS object_handle,
                             ADDRESS parameters);

extern int make_user_handle_array(dlist_t            list,
                                  handle_array_t * * ha);

extern BOOLEAN is_mounted(char   * volume_name,
                          char * * mount_name);

extern int hasa_dev_node(char * volume_name, uint minor);

extern BOOLEAN is_devfs_installed(void);

