/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: container.h
 *
 */

/*
 * Global functions exported by container.c
 */

/* External APIs provided by container.c */

extern int evms_can_add_to_container(object_handle_t object,
                                     object_handle_t container);

extern int evms_can_remove_from_container(object_handle_t object);

extern int evms_create_container(plugin_handle_t   plugin,
                                 handle_array_t  * input_objects,
                                 option_array_t  * options,
                                 object_handle_t * output_container);

extern int evms_get_container_list(object_handle_t     plugin,
                                   handle_array_t * * container_list);
