/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: commit.h
 *
 */

/*
 * Global data exported by commit.h
 */

extern BOOLEAN commit_in_progress;

/*
 * Global functions exported by commit.c
 */

/* External APIs provided by commit.c */

extern int evms_commit_changes(commit_status_func_t status_callback);

/* Internal functions to share with other Engine source modules */

extern int mark_feature_headers_dirty(ADDRESS object,
                                      TAG     object_tag,
                                      uint    object_size,
                                      ADDRESS object_handle,
                                      ADDRESS parameters);

extern int kernel_rediscover(void);
