<renderers>

  <!-- First we define some renderers for our ship and the bad guys -->

  <renderer name="ship"
   tag="ship"
   onrender="ship_element_render">

    <attrib name="x"
     description="Horizontal location."
     value_desc="boolean"
     values="false,true"
     onset="ship_x_attr_set"/>
 
    <attrib name="y"
     description="Vertical location."
     value_desc="boolean"
     values="false,true"
     onset="ship_y_attr_set"/>

    <attrib name="turning-speed"
     description="How fast to turn (number of degrees per increment)"
     value_desc="integer"
     values="1,180"/>

    <attrib name="thrust-power"
     description="How powerful your thrusters are"
     value_desc="float"
     values="0,1.0"/>

    <attrib name="rotate-left"
     description="Set to true of you want to rotate the ship counter-clockwise."
     value_desc="boolean"
     values="false,true"/>

    <attrib name="rotate-right"
     description="Set to true if you want to rotate the ship clockwise"
     value_desc="boolean"
     values="false,true"/>

    <attrib name="thrust"
     description="Engage thrusters"
     value_desc="boolean"
     values="false,true"/>

    <attrib name="fire"
     description="Fire bullet"
     value_desc="boolean"
     values="false,true"
     onset="ship_fire_bullet"/>

    <attrib name="update"
     description="Make the ship calculate a new position for itself based on current direction etc."
     value_desc="boolean"
     values="false,true"
     onset="ship_update_attr_set"/>


   <!-- Ship template -->
  <norender name="ship-template">
    <!-- My ship -->
    <gl-matrix rotate-angle="0" rotate-x="0" rotate-y="0" rotate-z="1.0"
               translate-x="0" translate-y="0" translate-z="0">
      <gl-line width="1" x1="0" y1="-1.5" x2="1" y2="1.5" color="#ffffff"/>
      <gl-line width="1" x1="0" y1="-1.5" x2="-1" y2="1.5" color="#ffffff"/>
      <gl-line width="1" x1="-1" y1="1.5" x2="1" y2="1.5" color="#ffffff"/>
    </gl-matrix>
  </norender>

  <?javascript

  function ship_element_render (renderer_node, node)
  {
      xml = enode ("norender.ship-template").get_child_xml();
      node.append_xml (xml);
  }

  function ship_x_attr_set (renderer_node, node, attr, value)
  {
      n = node.child ("gl-matrix");
      n.attribval["translate-x"] = value;
  }
  
  function ship_y_attr_set (renderer_node, node, attr, value)
  {
      n = node.child ("gl-matrix");
      n.attribval["translate-y"] = value;
  }

  function ship_fire_bullet (renderer_node, ship, attr, value)
  {

      bullet = enode ("glarea.main").new_child ("bullet");
      bullet.attribval.x = ship.attribval.x;
      bullet.attribval.y = ship.attribval.y;
      bullet.attribval["x-velocity"] = ship.attribval["x-velocity"];
      bullet.attribval["y-velocity"] = ship.attribval["y-velocity"];
      bullet.attrib.moving="true";

      // Now we just have to give it a bit of a boost.
      matrix = ship.child ("gl-matrix");
      
      dir = matrix.attribval["rotate-angle"];
      x = Math.sin (dir / 180 * Math.PI);
      y = Math.cos (dir / 180 * Math.PI);
     
      bullet_speed = bullet.attribval.speed;
      bullet.attribval["x-velocity"] += (x * 3);
      bullet.attribval["y-velocity"] -= (y * 3);
   
  }

  function ship_update_attr_set (renderer_node, ship, attr, value)
  {
      matrix = ship.child ("gl-matrix");

      if (ship.attrib_is_true ("rotate-right")) {
	  matrix.attribval["rotate-angle"] += ship.attribval["turning-speed"];
	  if (matrix.attribval["rotate-angle"] >= 360)
	      matrix.attribval["rotate-angle"] -= 360;
      }
      
      if (ship.attrib_is_true ("rotate-left")) {
	  matrix.attribval["rotate-angle"] -= ship.attribval["turning-speed"];
	  if (matrix.attribval["rotate-angle"] < 0)
	      matrix.attribval["rotate-angle"] += 360;
      }
       
      if (ship.attrib_is_true ("thrust")) {
	  power = ship.attribval["thrust-power"];
	  
	  // Calculate new momentum vectors based on thrust and direction
	  dir = matrix.attribval["rotate-angle"];
	  x = Math.sin (dir / 180 * Math.PI);
	  y = Math.cos (dir / 180 * Math.PI);

	  ship.attribval["x-velocity"] += (x * power);
	  ship.attribval["y-velocity"] -= (y * power);
      }

      new_x = ship.attribval.x + ship.attribval["x-velocity"];
      new_y = ship.attribval.y + ship.attribval["y-velocity"];

      // Outer bounds checking
      if ((new_x >= 100) || (new_x <= 0)) {
	  // Switch directions
	  ship.attribval["x-velocity"] = -ship.attribval["x-velocity"];
	  // Half speed
	  ship.attribval["x-velocity"] /= 2;
      }

      if ((new_y >= 100) || (new_y <= 0)) {
	  // Switch directions
	  ship.attribval["y-velocity"] = -ship.attribval["y-velocity"];
	  // Half speed
	  ship.attribval["y-velocity"] /= 2;
      }

      // Inner bounds checking
      if ((new_x >= 25) && (new_x <= 75) &&
	  (new_y >= 35) && (new_y <= 65)) {
	  
	  // Now that we know we'll be inside the square, we have to decide
	  // if it's from the top, side etc.

	  // we check if the current value of the ship was not in the
	  // inner square, if it wasn't, we must be moving into it
	  // on that plane
	  if (ship.attribval.x <= 25 || ship.attribval.x >= 75) {
    	      ship.attribval["x-velocity"] = -ship.attribval["x-velocity"];
    	      ship.attribval["x-velocity"] /= 2;
	  } else if (ship.attribval.y <= 35 || ship.attribval.y >= 65) {
	      ship.attribval["y-velocity"] = -ship.attribval["y-velocity"];
    	      ship.attribval["y-velocity"] /= 2;
	  }
      }
	
      // Add velocity to the x/y vectors to make the ship actually move.
      ship.attribval.x += ship.attribval["x-velocity"];
      ship.attribval.y += ship.attribval["y-velocity"];
  }

  ?>

  </renderer>

  <renderer name="bullet"
   tag="bullet"
   onrender="bullet_element_render">

    <attrib name="x"
     description="Horizontal location."
     value_desc="boolean"
     values="false,true"
     onset="bullet_x_attr_set"/>
 
    <attrib name="y"
     description="Vertical location."
     value_desc="boolean"
     values="false,true"
     onset="bullet_y_attr_set"/>

    <attrib name="update"
     description="Firing Direction"
     onset="bullet_update_attr_set"/>

   <!-- Bullet template -->
  <norender name="bullet-template">
    <!-- My ship -->
    <gl-matrix rotate-angle="0" rotate-x="0" rotate-y="0" rotate-z="1.0"
               translate-x="0" translate-y="0" translate-z="0">
      <gl-line width="3" x1="-0.1" y1="-0.1" x2="0.1" y2="0.1" color="#ffffff"/>
    </gl-matrix>
  </norender>

  <?javascript

  function bullet_element_render (renderer_node, node)
  {
      xml = enode ("norender.bullet-template").get_child_xml();
      node.append_xml (xml);
  }

  function bullet_x_attr_set (renderer_node, node, attr, value)
  {
      n = node.child ("gl-matrix");
      n.attribval["translate-x"] = value;
  }
  
  function bullet_y_attr_set (renderer_node, node, attr, value)
  {
      n = node.child ("gl-matrix");
      n.attribval["translate-y"] = value;
  }

  function bullet_update_attr_set (renderer_node, bullet, attr, value)
  {
      matrix = bullet.child ("gl-matrix");
      
      new_x = bullet.attribval.x + bullet.attribval["x-velocity"];
      new_y = bullet.attribval.y + bullet.attribval["y-velocity"];

      // Outer bounds checking
      if ((new_x >= 100) || (new_x <= 0)) {
	  bullet.destroy();
	  return;
      }

      if ((new_y >= 100) || (new_y <= 0)) {
	  bullet.destroy();
	  return;
      }

      // Inner bounds checking
      if ((new_x >= 25) && (new_x <= 75) &&
	  (new_y >= 35) && (new_y <= 65)) {
	  bullet.destroy();	  
	  return;
      }
	
      // Add velocity to the x/y vectors to make the ship actually move.
      bullet.attribval.x += bullet.attribval["x-velocity"];
      bullet.attribval.y += bullet.attribval["y-velocity"];
  }

  ?>

  </renderer>

</renderers>


