#include <stdio.h>
#include <stdlib.h>

#include "ptg_gen.h"
#include "obstack.h"

/* -------------------------------------------------------- */
/*                      Memory Management                   */
/* -------------------------------------------------------- */

static Obstack _PTGObstack;
static void *_PTGFirstObj = NULL;

static void _PTGInit()
{
	if (_PTGFirstObj)
		return;
	obstack_init(&_PTGObstack);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}

void PTGFree()
{
	obstack_free(&_PTGObstack, _PTGFirstObj);
	_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);
}


#if defined(__STDC__) || defined(__cplusplus)
static void *MALLOC(int size)
#else
static void *MALLOC(size) int size;
#endif
{
	if (! _PTGFirstObj)
		_PTGInit();
	return (obstack_alloc(&_PTGObstack, size));
}

/* -------------------------------------------------------- */
/*                       Output-functions                   */
/* -------------------------------------------------------- */

static PTG_OUTPUT_FILE f;
static char buffer[40];

#if PTG_OUTPUT_DEFAULT
#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
	PTGNode r;
#endif
{
	f = stdout;
	if (r) {
		(* (r->_print)) (r);
	}
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
	char * fn; PTGNode r;
#endif
{
	if ((f = fopen(fn, "w"))  == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	fclose(f);
	return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
	FILE *fptr; PTGNode r;
#endif
{
	if ((f = fptr) == (FILE *)NULL)
	{
		fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
		exit(1);
	}
	if (r)
		(* (r->_print)) (r);
	return (r);
}

#endif

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProcess(PTG_OUTPUT_FILE file, PTGNode r)
#else
PTGNode PTGProcess(file, r)
	PTG_OUTPUT_FILE file; PTGNode r;
#endif
{
	f = file;
	if (r)
		(* (r->_print)) (r);
	return (r);
}
/* -------------------------------------------------------- */
/*                            PTGNULL                       */
/* -------------------------------------------------------- */

/* Define PTGNULL as a PTGNode that prints nothing. */

#if defined(__STDC__) || defined(__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { (_PTGProc) _PrPTGNULL };

/* -------------------------------------------------------- */
/*          Node-Construction and Print-functions           */
/* -------------------------------------------------------- */


/* Implementation of Pattern node_definition */

typedef struct _SPTGnode_definition{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
	PTGNode p3;
	PTGNode p4;
	PTGNode p5;
	PTGNode p6;
} * _PPTGnode_definition;

#ifdef PROTO_OK
static void _PrPTGnode_definition(_PPTGnode_definition n)
#else
static void _PrPTGnode_definition(n)
	_PPTGnode_definition n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, ")");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(");
	n->p3->_print(n->p3);
	PTG_OUTPUT_STRING(f, ")");
	n->p4->_print(n->p4);
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\t_PPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " n;");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\n\tn = (_PPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, ")MALLOC(sizeof(struct _SPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "));");
	n->p6->_print(n->p6);
	PTG_OUTPUT_STRING(f, "\n\tn->_print = (_PTGProc)_PrPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, ";");
	n->p5->_print(n->p5);
	PTG_OUTPUT_STRING(f, "\n\treturn (PTGNode)n;");
	PTG_OUTPUT_STRING(f, "\n}\n");
}

#ifdef PROTO_OK
PTGNode PTGnode_definition(char * p1, PTGNode p2, PTGNode p3, PTGNode p4, PTGNode p5, PTGNode p6)
#else
PTGNode PTGnode_definition(p1, p2, p3, p4, p5, p6)
char * p1;
PTGNode p2;
PTGNode p3;
PTGNode p4;
PTGNode p5;
PTGNode p6;
#endif
{
	_PPTGnode_definition n;

	n = (_PPTGnode_definition)MALLOC(sizeof(struct _SPTGnode_definition));
	n->_print = (_PTGProc)_PrPTGnode_definition;
	n->p1 = p1;
	n->p2 = p2;
	n->p3 = p3;
	n->p4 = p4;
	n->p5 = p5;
	n->p6 = p6;
	return (PTGNode)n;
}

/* Implementation of Pattern static_node_definition */

typedef struct _SPTGstatic_node_definition{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
	PTGNode p3;
	PTGNode p4;
	PTGNode p5;
} * _PPTGstatic_node_definition;

#ifdef PROTO_OK
static void _PrPTGstatic_node_definition(_PPTGstatic_node_definition n)
#else
static void _PrPTGstatic_node_definition(n)
	_PPTGstatic_node_definition n;
#endif
{
	PTG_OUTPUT_STRING(f, "\nstatic struct _SPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " _sptg");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " = {");
	PTG_OUTPUT_STRING(f, " (_PTGProc) _PrPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " };\n");
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, ")");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(");
	n->p3->_print(n->p3);
	PTG_OUTPUT_STRING(f, ")");
	n->p4->_print(n->p4);
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	n->p5->_print(n->p5);
	PTG_OUTPUT_STRING(f, "\n\treturn (PTGNode)(&_sptg");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, ");");
	PTG_OUTPUT_STRING(f, "\n}\n");
}

#ifdef PROTO_OK
PTGNode PTGstatic_node_definition(char * p1, PTGNode p2, PTGNode p3, PTGNode p4, PTGNode p5)
#else
PTGNode PTGstatic_node_definition(p1, p2, p3, p4, p5)
char * p1;
PTGNode p2;
PTGNode p3;
PTGNode p4;
PTGNode p5;
#endif
{
	_PPTGstatic_node_definition n;

	n = (_PPTGstatic_node_definition)MALLOC(sizeof(struct _SPTGstatic_node_definition));
	n->_print = (_PTGProc)_PrPTGstatic_node_definition;
	n->p1 = p1;
	n->p2 = p2;
	n->p3 = p3;
	n->p4 = p4;
	n->p5 = p5;
	return (PTGNode)n;
}

/* Implementation of Pattern comma_typename */

typedef struct _SPTGcomma_typename{
	_PTGProc _print;
	char * p1;
	int p2;
} * _PPTGcomma_typename;

#ifdef PROTO_OK
static void _PrPTGcomma_typename(_PPTGcomma_typename n)
#else
static void _PrPTGcomma_typename(n)
	_PPTGcomma_typename n;
#endif
{
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " p");
	PTG_OUTPUT_INT(f, n->p2);
}

#ifdef PROTO_OK
PTGNode PTGcomma_typename(char * p1, int p2)
#else
PTGNode PTGcomma_typename(p1, p2)
char * p1;
int p2;
#endif
{
	_PPTGcomma_typename n;

	n = (_PPTGcomma_typename)MALLOC(sizeof(struct _SPTGcomma_typename));
	n->_print = (_PTGProc)_PrPTGcomma_typename;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern comma_argument */

typedef struct _SPTGcomma_argument{
	_PTGProc _print;
	int p1;
} * _PPTGcomma_argument;

#ifdef PROTO_OK
static void _PrPTGcomma_argument(_PPTGcomma_argument n)
#else
static void _PrPTGcomma_argument(n)
	_PPTGcomma_argument n;
#endif
{
	PTG_OUTPUT_STRING(f, "p");
	PTG_OUTPUT_INT(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGcomma_argument(int p1)
#else
PTGNode PTGcomma_argument(p1)
int p1;
#endif
{
	_PPTGcomma_argument n;

	n = (_PPTGcomma_argument)MALLOC(sizeof(struct _SPTGcomma_argument));
	n->_print = (_PTGProc)_PrPTGcomma_argument;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern semicolon_typename */

typedef struct _SPTGsemicolon_typename{
	_PTGProc _print;
	char * p1;
	int p2;
} * _PPTGsemicolon_typename;

#ifdef PROTO_OK
static void _PrPTGsemicolon_typename(_PPTGsemicolon_typename n)
#else
static void _PrPTGsemicolon_typename(n)
	_PPTGsemicolon_typename n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " p");
	PTG_OUTPUT_INT(f, n->p2);
	PTG_OUTPUT_STRING(f, ";");
}

#ifdef PROTO_OK
PTGNode PTGsemicolon_typename(char * p1, int p2)
#else
PTGNode PTGsemicolon_typename(p1, p2)
char * p1;
int p2;
#endif
{
	_PPTGsemicolon_typename n;

	n = (_PPTGsemicolon_typename)MALLOC(sizeof(struct _SPTGsemicolon_typename));
	n->_print = (_PTGProc)_PrPTGsemicolon_typename;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern assignment */

typedef struct _SPTGassignment{
	_PTGProc _print;
	int p1;
} * _PPTGassignment;

#ifdef PROTO_OK
static void _PrPTGassignment(_PPTGassignment n)
#else
static void _PrPTGassignment(n)
	_PPTGassignment n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n\tn->p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, " = p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, ";");
}

#ifdef PROTO_OK
PTGNode PTGassignment(int p1)
#else
PTGNode PTGassignment(p1)
int p1;
#endif
{
	_PPTGassignment n;

	n = (_PPTGassignment)MALLOC(sizeof(struct _SPTGassignment));
	n->_print = (_PTGProc)_PrPTGassignment;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern void */

typedef struct _SPTGvoid{
	_PTGProc _print;
} * _PPTGvoid;

#ifdef PROTO_OK
static void _PrPTGvoid(_PPTGvoid n)
#else
static void _PrPTGvoid(n)
	_PPTGvoid n;
#endif
{
	PTG_OUTPUT_STRING(f, "void");
}

static struct _SPTGvoid _sptgvoid = { (_PTGProc) _PrPTGvoid };

#ifdef PROTO_OK
PTGNode PTGvoid(void)
#else
PTGNode PTGvoid()
#endif
{
	return (PTGNode)(&_sptgvoid);
}

/* Implementation of Pattern node_prototype */

typedef struct _SPTGnode_prototype{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
} * _PPTGnode_prototype;

#ifdef PROTO_OK
static void _PrPTGnode_prototype(_PPTGnode_prototype n)
#else
static void _PrPTGnode_prototype(n)
	_PPTGnode_prototype n;
#endif
{
	PTG_OUTPUT_STRING(f, "\nPTGNode PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " ELI_ARG((");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "));");
}

#ifdef PROTO_OK
PTGNode PTGnode_prototype(char * p1, PTGNode p2)
#else
PTGNode PTGnode_prototype(p1, p2)
char * p1;
PTGNode p2;
#endif
{
	_PPTGnode_prototype n;

	n = (_PPTGnode_prototype)MALLOC(sizeof(struct _SPTGnode_prototype));
	n->_print = (_PTGProc)_PrPTGnode_prototype;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern refer_other_node */

typedef struct _SPTGrefer_other_node{
	_PTGProc _print;
	char * p1;
	char * p2;
} * _PPTGrefer_other_node;

#ifdef PROTO_OK
static void _PrPTGrefer_other_node(_PPTGrefer_other_node n)
#else
static void _PrPTGrefer_other_node(n)
	_PPTGrefer_other_node n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n#define PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " ");
	PTG_OUTPUT_STRING(f, "PTG");
	PTG_OUTPUT_STRING(f, n->p2);
}

#ifdef PROTO_OK
PTGNode PTGrefer_other_node(char * p1, char * p2)
#else
PTGNode PTGrefer_other_node(p1, p2)
char * p1;
char * p2;
#endif
{
	_PPTGrefer_other_node n;

	n = (_PPTGrefer_other_node)MALLOC(sizeof(struct _SPTGrefer_other_node));
	n->_print = (_PTGProc)_PrPTGrefer_other_node;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern refer_ptgnull */

typedef struct _SPTGrefer_ptgnull{
	_PTGProc _print;
	char * p1;
} * _PPTGrefer_ptgnull;

#ifdef PROTO_OK
static void _PrPTGrefer_ptgnull(_PPTGrefer_ptgnull n)
#else
static void _PrPTGrefer_ptgnull(n)
	_PPTGrefer_ptgnull n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n#define PTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "() PTGNULL");
}

#ifdef PROTO_OK
PTGNode PTGrefer_ptgnull(char * p1)
#else
PTGNode PTGrefer_ptgnull(p1)
char * p1;
#endif
{
	_PPTGrefer_ptgnull n;

	n = (_PPTGrefer_ptgnull)MALLOC(sizeof(struct _SPTGrefer_ptgnull));
	n->_print = (_PTGProc)_PrPTGrefer_ptgnull;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern HeaderFile */

typedef struct _SPTGHeaderFile{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGHeaderFile;

#ifdef PROTO_OK
static void _PrPTGHeaderFile(_PPTGHeaderFile n)
#else
static void _PrPTGHeaderFile(n)
	_PPTGHeaderFile n;
#endif
{
	PTG_OUTPUT_STRING(f, "#ifndef _PTGGEN_H");
	PTG_OUTPUT_STRING(f, "\n#define _PTGGEN_H\n");
	PTG_OUTPUT_STRING(f, "\n#include <stdio.h>");
	PTG_OUTPUT_STRING(f, "\n#include \"eliproto.h\"\n");
	PTG_OUTPUT_STRING(f, "\n/* Include-files specified in .ptg.phi-files */\n");
	PTG_OUTPUT_STRING(f, "\n#include \"ptg.h\"");
	PTG_OUTPUT_STRING(f, "\n/* Definition of Output-Macros */\n");
	PTG_OUTPUT_STRING(f, "\n#if !defined(PTG_OUTPUT_FILE)");
	PTG_OUTPUT_STRING(f, "\n#    define PTG_OUTPUT_FILE FILE *");
	PTG_OUTPUT_STRING(f, "\n#    define PTG_OUTPUT_DEFAULT 1");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\n#    define PTG_OUTPUT_DEFAULT 0");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n#if !defined(PTG_OUTPUT_STRING)");
	PTG_OUTPUT_STRING(f, "\n#    define PTG_OUTPUT_STRING(file,param) fputs(param, file)");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_INT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_INT(file,param)    fprintf(file,\"%d\",param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_LONG)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_LONG(file,param)   fprintf(file,\"%ld\",param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_SHORT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_SHORT(file,param)  fprintf(file,\"%d\",(int) param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_CHAR)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_CHAR(file,param)   fputc(param, file)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_FLOAT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_FLOAT(file,param)  fprintf(file,\"%g\",(double)param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_DOUBLE)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_DOUBLE(file,param) fprintf(file,\"%g\",param)");
	PTG_OUTPUT_STRING(f, "\n#    endif\n");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\n     /* PTG_OUTPUT_STRING defined */");
	PTG_OUTPUT_STRING(f, "\n     extern void _PTGPrintInt ELI_ARG((PTG_OUTPUT_FILE,int));");
	PTG_OUTPUT_STRING(f, "\n     extern void _PTGPrintLong ELI_ARG((PTG_OUTPUT_FILE,long));");
	PTG_OUTPUT_STRING(f, "\n     extern void _PTGPrintChar ELI_ARG((PTG_OUTPUT_FILE,char));");
	PTG_OUTPUT_STRING(f, "\n     extern void _PTGPrintDouble ELI_ARG((PTG_OUTPUT_FILE,double));");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_INT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_INT(file,param)    _PTGPrintInt(file,param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_LONG)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_LONG(file,param)   _PTGPrintLong(file,param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_SHORT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_SHORT(file,param)  _PTGPrintInt(file,(int)param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_CHAR)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_CHAR(file,param)   _PTGPrintChar(file,param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_FLOAT)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_FLOAT(file,param)  _PTGPrintDouble(file,(double)param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#    if !defined(PTG_OUTPUT_DOUBLE)");
	PTG_OUTPUT_STRING(f, "\n#            define PTG_OUTPUT_DOUBLE(file,param) _PTGPrintDouble(file,param)");
	PTG_OUTPUT_STRING(f, "\n#    endif");
	PTG_OUTPUT_STRING(f, "\n#endif\n");
	PTG_OUTPUT_STRING(f, "\n/* Define PTGNode Type */");
	PTG_OUTPUT_STRING(f, "\n#if defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nstruct _SPTG0;");
	PTG_OUTPUT_STRING(f, "\ntypedef void (* _PTGProc)(struct _SPTG0 *);");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\ntypedef void (* _PTGProc)();");
	PTG_OUTPUT_STRING(f, "\n#endif\n");
	PTG_OUTPUT_STRING(f, "\ntypedef struct _SPTG0");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n  _PTGProc _print;");
	PTG_OUTPUT_STRING(f, "\n} * _PPTG0;");
	PTG_OUTPUT_STRING(f, "\ntypedef _PPTG0 PTGNode;                      /* the only exported type */\n");
	PTG_OUTPUT_STRING(f, "\n/* predefined static PTGNULL-Node */\n");
	PTG_OUTPUT_STRING(f, "\nextern struct _SPTG0 _PTGNULL;");
	PTG_OUTPUT_STRING(f, "\n#define PTGNULL (& _PTGNULL)");
	PTG_OUTPUT_STRING(f, "\n#define PTGNull() (& _PTGNULL)\n");
	PTG_OUTPUT_STRING(f, "\n/* output functions */\n");
	PTG_OUTPUT_STRING(f, "\n#if PTG_OUTPUT_DEFAULT");
	PTG_OUTPUT_STRING(f, "\nextern PTGNode PTGOut ELI_ARG((PTGNode root));");
	PTG_OUTPUT_STRING(f, "\nextern PTGNode PTGOutFile ELI_ARG((char *filename, PTGNode root));");
	PTG_OUTPUT_STRING(f, "\nextern PTGNode PTGOutFPtr ELI_ARG((FILE *output, PTGNode root));");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\nextern PTGNode PTGProcess ELI_ARG((PTG_OUTPUT_FILE file, PTGNode root));\n");
	PTG_OUTPUT_STRING(f, "\n/* Memory Management functions. */\n");
	PTG_OUTPUT_STRING(f, "\nextern void PTGFree ELI_ARG((void));\n");
	PTG_OUTPUT_STRING(f, "\n/* functions for making PTG nodes */\n");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, "\n\n/* prototypes for used function call insertions */\n");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "\n\n#ifdef MONITOR");
	PTG_OUTPUT_STRING(f, "\n/* Monitoring support for structured values */");
	PTG_OUTPUT_STRING(f, "\n#define DAPTO_RESULTPTGNode(n) DAPTO_RESULT_PTR(n)");
	PTG_OUTPUT_STRING(f, "\n#define DAPTO_ARGPTGNode(n) DAPTO_ARG_PTR(n, PTGNode)");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n\n#endif\n\n");
}

#ifdef PROTO_OK
PTGNode PTGHeaderFile(PTGNode p1, PTGNode p2)
#else
PTGNode PTGHeaderFile(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGHeaderFile n;

	n = (_PPTGHeaderFile)MALLOC(sizeof(struct _SPTGHeaderFile));
	n->_print = (_PTGProc)_PrPTGHeaderFile;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern ImplementationFile */

typedef struct _SPTGImplementationFile{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGImplementationFile;

#ifdef PROTO_OK
static void _PrPTGImplementationFile(_PPTGImplementationFile n)
#else
static void _PrPTGImplementationFile(n)
	_PPTGImplementationFile n;
#endif
{
	PTG_OUTPUT_STRING(f, "#include <stdio.h>");
	PTG_OUTPUT_STRING(f, "\n#include <stdlib.h>\n");
	PTG_OUTPUT_STRING(f, "\n#include \"ptg_gen.h\"");
	PTG_OUTPUT_STRING(f, "\n#include \"obstack.h\"\n");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */");
	PTG_OUTPUT_STRING(f, "\n/*                      Memory Management                   */");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */\n");
	PTG_OUTPUT_STRING(f, "\nstatic Obstack _PTGObstack;");
	PTG_OUTPUT_STRING(f, "\nstatic void *_PTGFirstObj = NULL;");
	PTG_OUTPUT_STRING(f, "\n\nstatic void _PTGInit()");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tif (_PTGFirstObj)");
	PTG_OUTPUT_STRING(f, "\n\t\treturn;");
	PTG_OUTPUT_STRING(f, "\n\tobstack_init(&_PTGObstack);");
	PTG_OUTPUT_STRING(f, "\n\t_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\nvoid PTGFree()");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tobstack_free(&_PTGObstack, _PTGFirstObj);");
	PTG_OUTPUT_STRING(f, "\n\t_PTGFirstObj = obstack_alloc(&_PTGObstack, 0);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\n\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nstatic void *MALLOC(int size)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nstatic void *MALLOC(size) int size;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tif (! _PTGFirstObj)");
	PTG_OUTPUT_STRING(f, "\n\t\t_PTGInit();");
	PTG_OUTPUT_STRING(f, "\n\treturn (obstack_alloc(&_PTGObstack, size));");
	PTG_OUTPUT_STRING(f, "\n}\n");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */");
	PTG_OUTPUT_STRING(f, "\n/*                       Output-functions                   */");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */\n");
	PTG_OUTPUT_STRING(f, "\nstatic PTG_OUTPUT_FILE f;");
	PTG_OUTPUT_STRING(f, "\nstatic char buffer[40];\n");
	PTG_OUTPUT_STRING(f, "\n#if PTG_OUTPUT_DEFAULT");
	PTG_OUTPUT_STRING(f, "\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOut (PTGNode r)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOut (r)");
	PTG_OUTPUT_STRING(f, "\n\tPTGNode r;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tf = stdout;");
	PTG_OUTPUT_STRING(f, "\n\tif (r) {");
	PTG_OUTPUT_STRING(f, "\n\t\t(* (r->_print)) (r);");
	PTG_OUTPUT_STRING(f, "\n\t}");
	PTG_OUTPUT_STRING(f, "\n\treturn (r);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOutFile (char *fn, PTGNode r)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOutFile (fn, r)");
	PTG_OUTPUT_STRING(f, "\n\tchar * fn; PTGNode r;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tif ((f = fopen(fn, \"w\"))  == (FILE *)NULL)");
	PTG_OUTPUT_STRING(f, "\n\t{");
	PTG_OUTPUT_STRING(f, "\n\t\tfprintf(stderr, \"ERROR: PTGOutFile: output file '%s' can't be opened.\\n\",fn);");
	PTG_OUTPUT_STRING(f, "\n\t\texit(1);");
	PTG_OUTPUT_STRING(f, "\n\t}");
	PTG_OUTPUT_STRING(f, "\n\tif (r)");
	PTG_OUTPUT_STRING(f, "\n\t\t(* (r->_print)) (r);");
	PTG_OUTPUT_STRING(f, "\n\tfclose(f);");
	PTG_OUTPUT_STRING(f, "\n\treturn (r);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOutFPtr(FILE *fptr, PTGNode r)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGOutFPtr(fptr, r)");
	PTG_OUTPUT_STRING(f, "\n\tFILE *fptr; PTGNode r;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tif ((f = fptr) == (FILE *)NULL)");
	PTG_OUTPUT_STRING(f, "\n\t{");
	PTG_OUTPUT_STRING(f, "\n\t\tfprintf(stderr, \"ERROR: PTGOutFPtr: output file not open.\\n\");");
	PTG_OUTPUT_STRING(f, "\n\t\texit(1);");
	PTG_OUTPUT_STRING(f, "\n\t}");
	PTG_OUTPUT_STRING(f, "\n\tif (r)");
	PTG_OUTPUT_STRING(f, "\n\t\t(* (r->_print)) (r);");
	PTG_OUTPUT_STRING(f, "\n\treturn (r);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n");
	PTG_OUTPUT_STRING(f, "\n#endif\n");
	PTG_OUTPUT_STRING(f, "\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGProcess(PTG_OUTPUT_FILE file, PTGNode r)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nPTGNode PTGProcess(file, r)");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_FILE file; PTGNode r;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tf = file;");
	PTG_OUTPUT_STRING(f, "\n\tif (r)");
	PTG_OUTPUT_STRING(f, "\n\t\t(* (r->_print)) (r);");
	PTG_OUTPUT_STRING(f, "\n\treturn (r);");
	PTG_OUTPUT_STRING(f, "\n}");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */");
	PTG_OUTPUT_STRING(f, "\n/*                            PTGNULL                       */");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */\n");
	PTG_OUTPUT_STRING(f, "\n/* Define PTGNULL as a PTGNode that prints nothing. */");
	PTG_OUTPUT_STRING(f, "\n\n#if defined(__STDC__) || defined(__cplusplus)");
	PTG_OUTPUT_STRING(f, "\nstatic void _PrPTGNULL(_PPTG0 n)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nstatic void _PrPTGNULL(n)");
	PTG_OUTPUT_STRING(f, "\n_PPTG0 n;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{(void)n; /* function printing nothing */}\n");
	PTG_OUTPUT_STRING(f, "\nstruct _SPTG0   _PTGNULL = { (_PTGProc) _PrPTGNULL };\n");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */");
	PTG_OUTPUT_STRING(f, "\n/*          Node-Construction and Print-functions           */");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */\n\n");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, "\n\n/* -------------------------------------------------------- */");
	PTG_OUTPUT_STRING(f, "\n/*                  Default Output Functions                */");
	PTG_OUTPUT_STRING(f, "\n/* -------------------------------------------------------- */\n\n");
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintInt(PTG_OUTPUT_FILE file, int param)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintInt(file, param)");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_FILE file; int param;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{    /* used for short and int */");
	PTG_OUTPUT_STRING(f, "\n\tsprintf(buffer,\"%d\",param);");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_STRING(file,buffer);");
	PTG_OUTPUT_STRING(f, "\n}\n");
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintLong(PTG_OUTPUT_FILE file, long param)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintLong(file, param)");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_FILE file; long param;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tsprintf(buffer,\"%ld\",param);");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_STRING(file,buffer);");
	PTG_OUTPUT_STRING(f, "\n}\n");
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintDouble(PTG_OUTPUT_FILE file, double param)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintDouble(file, param)");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_FILE file; double param;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{    /* used for float and double */");
	PTG_OUTPUT_STRING(f, "\n\tsprintf(buffer,\"%g\",param);");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_STRING(file,buffer);");
	PTG_OUTPUT_STRING(f, "\n}\n");
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintChar(PTG_OUTPUT_FILE file, char param)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nvoid _PTGPrintChar(file, param)");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_FILE file; char param;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	PTG_OUTPUT_STRING(f, "\n\tbuffer[0] = param;");
	PTG_OUTPUT_STRING(f, "\n\tbuffer[1] = 0;");
	PTG_OUTPUT_STRING(f, "\n\tPTG_OUTPUT_STRING(file,buffer);");
	PTG_OUTPUT_STRING(f, "\n}\n\n");
}

#ifdef PROTO_OK
PTGNode PTGImplementationFile(PTGNode p1)
#else
PTGNode PTGImplementationFile(p1)
PTGNode p1;
#endif
{
	_PPTGImplementationFile n;

	n = (_PPTGImplementationFile)MALLOC(sizeof(struct _SPTGImplementationFile));
	n->_print = (_PTGProc)_PrPTGImplementationFile;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern structure */

typedef struct _SPTGstructure{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
} * _PPTGstructure;

#ifdef PROTO_OK
static void _PrPTGstructure(_PPTGstructure n)
#else
static void _PrPTGstructure(n)
	_PPTGstructure n;
#endif
{
	PTG_OUTPUT_STRING(f, "\ntypedef struct _SPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "{");
	PTG_OUTPUT_STRING(f, "\n\t_PTGProc _print;");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "\n} * _PPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, ";\n");
}

#ifdef PROTO_OK
PTGNode PTGstructure(char * p1, PTGNode p2)
#else
PTGNode PTGstructure(p1, p2)
char * p1;
PTGNode p2;
#endif
{
	_PPTGstructure n;

	n = (_PPTGstructure)MALLOC(sizeof(struct _SPTGstructure));
	n->_print = (_PTGProc)_PrPTGstructure;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern structure_component */

typedef struct _SPTGstructure_component{
	_PTGProc _print;
	char * p1;
	int p2;
} * _PPTGstructure_component;

#ifdef PROTO_OK
static void _PrPTGstructure_component(_PPTGstructure_component n)
#else
static void _PrPTGstructure_component(n)
	_PPTGstructure_component n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n\t");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " p");
	PTG_OUTPUT_INT(f, n->p2);
	PTG_OUTPUT_STRING(f, ";");
}

#ifdef PROTO_OK
PTGNode PTGstructure_component(char * p1, int p2)
#else
PTGNode PTGstructure_component(p1, p2)
char * p1;
int p2;
#endif
{
	_PPTGstructure_component n;

	n = (_PPTGstructure_component)MALLOC(sizeof(struct _SPTGstructure_component));
	n->_print = (_PTGProc)_PrPTGstructure_component;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern check_empty_argument */

typedef struct _SPTGcheck_empty_argument{
	_PTGProc _print;
	int p1;
} * _PPTGcheck_empty_argument;

#ifdef PROTO_OK
static void _PrPTGcheck_empty_argument(_PPTGcheck_empty_argument n)
#else
static void _PrPTGcheck_empty_argument(n)
	_PPTGcheck_empty_argument n;
#endif
{
	PTG_OUTPUT_STRING(f, "p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, " == PTGNULL");
}

#ifdef PROTO_OK
PTGNode PTGcheck_empty_argument(int p1)
#else
PTGNode PTGcheck_empty_argument(p1)
int p1;
#endif
{
	_PPTGcheck_empty_argument n;

	n = (_PPTGcheck_empty_argument)MALLOC(sizeof(struct _SPTGcheck_empty_argument));
	n->_print = (_PTGProc)_PrPTGcheck_empty_argument;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern AndSeq */

typedef struct _SPTGAndSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGAndSeq;

#ifdef PROTO_OK
static void _PrPTGAndSeq(_PPTGAndSeq n)
#else
static void _PrPTGAndSeq(n)
	_PPTGAndSeq n;
#endif
{
	n->p1->_print(n->p1);
	if (n->p1 != PTGNULL && n->p2 != PTGNULL)
	{
		PTG_OUTPUT_STRING(f, " && ");
	}
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGAndSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGAndSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGAndSeq n;

	n = (_PPTGAndSeq)MALLOC(sizeof(struct _SPTGAndSeq));
	if(p1 == PTGNULL && p2 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGAndSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern check_empty_arguments */

typedef struct _SPTGcheck_empty_arguments{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGcheck_empty_arguments;

#ifdef PROTO_OK
static void _PrPTGcheck_empty_arguments(_PPTGcheck_empty_arguments n)
#else
static void _PrPTGcheck_empty_arguments(n)
	_PPTGcheck_empty_arguments n;
#endif
{
	if (n->p1 != PTGNULL)
	{
		PTG_OUTPUT_STRING(f, "\n\tif(");
	}
	n->p1->_print(n->p1);
	if (n->p1 != PTGNULL)
	{
		PTG_OUTPUT_STRING(f, ")");
		PTG_OUTPUT_STRING(f, "\n\t\treturn PTGNULL;\n");
	}
}

#ifdef PROTO_OK
PTGNode PTGcheck_empty_arguments(PTGNode p1)
#else
PTGNode PTGcheck_empty_arguments(p1)
PTGNode p1;
#endif
{
	_PPTGcheck_empty_arguments n;

	n = (_PPTGcheck_empty_arguments)MALLOC(sizeof(struct _SPTGcheck_empty_arguments));
	if(p1 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGcheck_empty_arguments;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern print_function */

typedef struct _SPTGprint_function{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
} * _PPTGprint_function;

#ifdef PROTO_OK
static void _PrPTGprint_function(_PPTGprint_function n)
#else
static void _PrPTGprint_function(n)
	_PPTGprint_function n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n#ifdef PROTO_OK");
	PTG_OUTPUT_STRING(f, "\nstatic void _PrPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(_PPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " n)");
	PTG_OUTPUT_STRING(f, "\n#else");
	PTG_OUTPUT_STRING(f, "\nstatic void _PrPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(n)");
	PTG_OUTPUT_STRING(f, "\n\t_PPTG");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " n;");
	PTG_OUTPUT_STRING(f, "\n#endif");
	PTG_OUTPUT_STRING(f, "\n{");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "\n}\n");
}

#ifdef PROTO_OK
PTGNode PTGprint_function(char * p1, PTGNode p2)
#else
PTGNode PTGprint_function(p1, p2)
char * p1;
PTGNode p2;
#endif
{
	_PPTGprint_function n;

	n = (_PPTGprint_function)MALLOC(sizeof(struct _SPTGprint_function));
	n->_print = (_PTGProc)_PrPTGprint_function;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern print_string */

typedef struct _SPTGprint_string{
	_PTGProc _print;
	char * p1;
} * _PPTGprint_string;

#ifdef PROTO_OK
static void _PrPTGprint_string(_PPTGprint_string n)
#else
static void _PrPTGprint_string(n)
	_PPTGprint_string n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n");
	condindent(f);
	PTG_OUTPUT_STRING(f, "\tPTG_OUTPUT_STRING(f, ");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, ");");
}

#ifdef PROTO_OK
PTGNode PTGprint_string(char * p1)
#else
PTGNode PTGprint_string(p1)
char * p1;
#endif
{
	_PPTGprint_string n;

	n = (_PPTGprint_string)MALLOC(sizeof(struct _SPTGprint_string));
	n->_print = (_PTGProc)_PrPTGprint_string;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern print_macro_call */

typedef struct _SPTGprint_macro_call{
	_PTGProc _print;
	char * p1;
	int p2;
} * _PPTGprint_macro_call;

#ifdef PROTO_OK
static void _PrPTGprint_macro_call(_PPTGprint_macro_call n)
#else
static void _PrPTGprint_macro_call(n)
	_PPTGprint_macro_call n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n");
	condindent(f);
	PTG_OUTPUT_STRING(f, "\tPTG_OUTPUT_");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(f, n->p");
	PTG_OUTPUT_INT(f, n->p2);
	PTG_OUTPUT_STRING(f, ");");
}

#ifdef PROTO_OK
PTGNode PTGprint_macro_call(char * p1, int p2)
#else
PTGNode PTGprint_macro_call(p1, p2)
char * p1;
int p2;
#endif
{
	_PPTGprint_macro_call n;

	n = (_PPTGprint_macro_call)MALLOC(sizeof(struct _SPTGprint_macro_call));
	n->_print = (_PTGProc)_PrPTGprint_macro_call;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern print_invocation */

typedef struct _SPTGprint_invocation{
	_PTGProc _print;
	int p1;
} * _PPTGprint_invocation;

#ifdef PROTO_OK
static void _PrPTGprint_invocation(_PPTGprint_invocation n)
#else
static void _PrPTGprint_invocation(n)
	_PPTGprint_invocation n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n");
	condindent(f);
	PTG_OUTPUT_STRING(f, "\tn->p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, "->_print(n->p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, ");");
}

#ifdef PROTO_OK
PTGNode PTGprint_invocation(int p1)
#else
PTGNode PTGprint_invocation(p1)
int p1;
#endif
{
	_PPTGprint_invocation n;

	n = (_PPTGprint_invocation)MALLOC(sizeof(struct _SPTGprint_invocation));
	n->_print = (_PTGProc)_PrPTGprint_invocation;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern print_function_call */

typedef struct _SPTGprint_function_call{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
} * _PPTGprint_function_call;

#ifdef PROTO_OK
static void _PrPTGprint_function_call(_PPTGprint_function_call n)
#else
static void _PrPTGprint_function_call(n)
	_PPTGprint_function_call n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n");
	condindent(f);
	PTG_OUTPUT_STRING(f, "\t");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, "(f");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, ");");
}

#ifdef PROTO_OK
PTGNode PTGprint_function_call(char * p1, PTGNode p2)
#else
PTGNode PTGprint_function_call(p1, p2)
char * p1;
PTGNode p2;
#endif
{
	_PPTGprint_function_call n;

	n = (_PPTGprint_function_call)MALLOC(sizeof(struct _SPTGprint_function_call));
	n->_print = (_PTGProc)_PrPTGprint_function_call;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern print_function_argument */

typedef struct _SPTGprint_function_argument{
	_PTGProc _print;
	int p1;
} * _PPTGprint_function_argument;

#ifdef PROTO_OK
static void _PrPTGprint_function_argument(_PPTGprint_function_argument n)
#else
static void _PrPTGprint_function_argument(n)
	_PPTGprint_function_argument n;
#endif
{
	PTG_OUTPUT_STRING(f, ", n->p");
	PTG_OUTPUT_INT(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGprint_function_argument(int p1)
#else
PTGNode PTGprint_function_argument(p1)
int p1;
#endif
{
	_PPTGprint_function_argument n;

	n = (_PPTGprint_function_argument)MALLOC(sizeof(struct _SPTGprint_function_argument));
	n->_print = (_PTGProc)_PrPTGprint_function_argument;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern print_opt_check */

typedef struct _SPTGprint_opt_check{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGprint_opt_check;

#ifdef PROTO_OK
static void _PrPTGprint_opt_check(_PPTGprint_opt_check n)
#else
static void _PrPTGprint_opt_check(n)
	_PPTGprint_opt_check n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n\tif (");
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, ")");
	PTG_OUTPUT_STRING(f, "\n\t{");
	condindenton(f);
	n->p2->_print(n->p2);
	condindentoff(f);
	PTG_OUTPUT_STRING(f, "\n\t}");
}

#ifdef PROTO_OK
PTGNode PTGprint_opt_check(PTGNode p1, PTGNode p2)
#else
PTGNode PTGprint_opt_check(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGprint_opt_check n;

	n = (_PPTGprint_opt_check)MALLOC(sizeof(struct _SPTGprint_opt_check));
	n->_print = (_PTGProc)_PrPTGprint_opt_check;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern print_optional_condition */

typedef struct _SPTGprint_optional_condition{
	_PTGProc _print;
	int p1;
} * _PPTGprint_optional_condition;

#ifdef PROTO_OK
static void _PrPTGprint_optional_condition(_PPTGprint_optional_condition n)
#else
static void _PrPTGprint_optional_condition(n)
	_PPTGprint_optional_condition n;
#endif
{
	PTG_OUTPUT_STRING(f, "n->p");
	PTG_OUTPUT_INT(f, n->p1);
	PTG_OUTPUT_STRING(f, " != PTGNULL");
}

#ifdef PROTO_OK
PTGNode PTGprint_optional_condition(int p1)
#else
PTGNode PTGprint_optional_condition(p1)
int p1;
#endif
{
	_PPTGprint_optional_condition n;

	n = (_PPTGprint_optional_condition)MALLOC(sizeof(struct _SPTGprint_optional_condition));
	n->_print = (_PTGProc)_PrPTGprint_optional_condition;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern function_call_prototype */

typedef struct _SPTGfunction_call_prototype{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
} * _PPTGfunction_call_prototype;

#ifdef PROTO_OK
static void _PrPTGfunction_call_prototype(_PPTGfunction_call_prototype n)
#else
static void _PrPTGfunction_call_prototype(n)
	_PPTGfunction_call_prototype n;
#endif
{
	PTG_OUTPUT_STRING(f, "\nvoid ");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " ELI_ARG((PTG_OUTPUT_FILE");
	n->p2->_print(n->p2);
	PTG_OUTPUT_STRING(f, "));");
}

#ifdef PROTO_OK
PTGNode PTGfunction_call_prototype(char * p1, PTGNode p2)
#else
PTGNode PTGfunction_call_prototype(p1, p2)
char * p1;
PTGNode p2;
#endif
{
	_PPTGfunction_call_prototype n;

	n = (_PPTGfunction_call_prototype)MALLOC(sizeof(struct _SPTGfunction_call_prototype));
	n->_print = (_PTGProc)_PrPTGfunction_call_prototype;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern function_type */

typedef struct _SPTGfunction_type{
	_PTGProc _print;
	char * p1;
} * _PPTGfunction_type;

#ifdef PROTO_OK
static void _PrPTGfunction_type(_PPTGfunction_type n)
#else
static void _PrPTGfunction_type(n)
	_PPTGfunction_type n;
#endif
{
	PTG_OUTPUT_STRING(f, ", ");
	PTG_OUTPUT_STRING(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGfunction_type(char * p1)
#else
PTGNode PTGfunction_type(p1)
char * p1;
#endif
{
	_PPTGfunction_type n;

	n = (_PPTGfunction_type)MALLOC(sizeof(struct _SPTGfunction_type));
	n->_print = (_PTGProc)_PrPTGfunction_type;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern node_implementation */

typedef struct _SPTGnode_implementation{
	_PTGProc _print;
	char * p1;
	PTGNode p2;
	PTGNode p3;
	PTGNode p4;
} * _PPTGnode_implementation;

#ifdef PROTO_OK
static void _PrPTGnode_implementation(_PPTGnode_implementation n)
#else
static void _PrPTGnode_implementation(n)
	_PPTGnode_implementation n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n/* Implementation of Pattern ");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " */\n");
	n->p2->_print(n->p2);
	n->p3->_print(n->p3);
	n->p4->_print(n->p4);
}

#ifdef PROTO_OK
PTGNode PTGnode_implementation(char * p1, PTGNode p2, PTGNode p3, PTGNode p4)
#else
PTGNode PTGnode_implementation(p1, p2, p3, p4)
char * p1;
PTGNode p2;
PTGNode p3;
PTGNode p4;
#endif
{
	_PPTGnode_implementation n;

	n = (_PPTGnode_implementation)MALLOC(sizeof(struct _SPTGnode_implementation));
	n->_print = (_PTGProc)_PrPTGnode_implementation;
	n->p1 = p1;
	n->p2 = p2;
	n->p3 = p3;
	n->p4 = p4;
	return (PTGNode)n;
}

/* Implementation of Pattern node_other */

typedef struct _SPTGnode_other{
	_PTGProc _print;
	char * p1;
	char * p2;
} * _PPTGnode_other;

#ifdef PROTO_OK
static void _PrPTGnode_other(_PPTGnode_other n)
#else
static void _PrPTGnode_other(n)
	_PPTGnode_other n;
#endif
{
	PTG_OUTPUT_STRING(f, "\n/* No Implementation of Pattern ");
	PTG_OUTPUT_STRING(f, n->p1);
	PTG_OUTPUT_STRING(f, " needed */");
	PTG_OUTPUT_STRING(f, "\n/* See ");
	PTG_OUTPUT_STRING(f, n->p2);
	PTG_OUTPUT_STRING(f, " for implementation */\n");
}

#ifdef PROTO_OK
PTGNode PTGnode_other(char * p1, char * p2)
#else
PTGNode PTGnode_other(p1, p2)
char * p1;
char * p2;
#endif
{
	_PPTGnode_other n;

	n = (_PPTGnode_other)MALLOC(sizeof(struct _SPTGnode_other));
	n->_print = (_PTGProc)_PrPTGnode_other;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Id */

typedef struct _SPTGId{
	_PTGProc _print;
	int p1;
} * _PPTGId;

#ifdef PROTO_OK
static void _PrPTGId(_PPTGId n)
#else
static void _PrPTGId(n)
	_PPTGId n;
#endif
{
	PtgOutId(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGId(int p1)
#else
PTGNode PTGId(p1)
int p1;
#endif
{
	_PPTGId n;

	n = (_PPTGId)MALLOC(sizeof(struct _SPTGId));
	n->_print = (_PTGProc)_PrPTGId;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern AsIs */

typedef struct _SPTGAsIs{
	_PTGProc _print;
	char * p1;
} * _PPTGAsIs;

#ifdef PROTO_OK
static void _PrPTGAsIs(_PPTGAsIs n)
#else
static void _PrPTGAsIs(n)
	_PPTGAsIs n;
#endif
{
	PTG_OUTPUT_STRING(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGAsIs(char * p1)
#else
PTGNode PTGAsIs(p1)
char * p1;
#endif
{
	_PPTGAsIs n;

	n = (_PPTGAsIs)MALLOC(sizeof(struct _SPTGAsIs));
	n->_print = (_PTGProc)_PrPTGAsIs;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Numb */

typedef struct _SPTGNumb{
	_PTGProc _print;
	int p1;
} * _PPTGNumb;

#ifdef PROTO_OK
static void _PrPTGNumb(_PPTGNumb n)
#else
static void _PrPTGNumb(n)
	_PPTGNumb n;
#endif
{
	PTG_OUTPUT_INT(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGNumb(int p1)
#else
PTGNode PTGNumb(p1)
int p1;
#endif
{
	_PPTGNumb n;

	n = (_PPTGNumb)MALLOC(sizeof(struct _SPTGNumb));
	n->_print = (_PTGProc)_PrPTGNumb;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern CString */

typedef struct _SPTGCString{
	_PTGProc _print;
	char * p1;
} * _PPTGCString;

#ifdef PROTO_OK
static void _PrPTGCString(_PPTGCString n)
#else
static void _PrPTGCString(n)
	_PPTGCString n;
#endif
{
	CPtgOutstr(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGCString(char * p1)
#else
PTGNode PTGCString(p1)
char * p1;
#endif
{
	_PPTGCString n;

	n = (_PPTGCString)MALLOC(sizeof(struct _SPTGCString));
	n->_print = (_PTGProc)_PrPTGCString;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern CChar */

typedef struct _SPTGCChar{
	_PTGProc _print;
	int p1;
} * _PPTGCChar;

#ifdef PROTO_OK
static void _PrPTGCChar(_PPTGCChar n)
#else
static void _PrPTGCChar(n)
	_PPTGCChar n;
#endif
{
	CPtgOutchar(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGCChar(int p1)
#else
PTGNode PTGCChar(p1)
int p1;
#endif
{
	_PPTGCChar n;

	n = (_PPTGCChar)MALLOC(sizeof(struct _SPTGCChar));
	n->_print = (_PTGProc)_PrPTGCChar;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern PString */

typedef struct _SPTGPString{
	_PTGProc _print;
	char * p1;
} * _PPTGPString;

#ifdef PROTO_OK
static void _PrPTGPString(_PPTGPString n)
#else
static void _PrPTGPString(n)
	_PPTGPString n;
#endif
{
	PPtgOutstr(f, n->p1);
}

#ifdef PROTO_OK
PTGNode PTGPString(char * p1)
#else
PTGNode PTGPString(p1)
char * p1;
#endif
{
	_PPTGPString n;

	n = (_PPTGPString)MALLOC(sizeof(struct _SPTGPString));
	n->_print = (_PTGProc)_PrPTGPString;
	n->p1 = p1;
	return (PTGNode)n;
}

/* Implementation of Pattern Seq */

typedef struct _SPTGSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGSeq;

#ifdef PROTO_OK
static void _PrPTGSeq(_PPTGSeq n)
#else
static void _PrPTGSeq(n)
	_PPTGSeq n;
#endif
{
	n->p1->_print(n->p1);
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGSeq n;

	n = (_PPTGSeq)MALLOC(sizeof(struct _SPTGSeq));
	if(p1 == PTGNULL && p2 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern CommaSeq */

typedef struct _SPTGCommaSeq{
	_PTGProc _print;
	PTGNode p1;
	PTGNode p2;
} * _PPTGCommaSeq;

#ifdef PROTO_OK
static void _PrPTGCommaSeq(_PPTGCommaSeq n)
#else
static void _PrPTGCommaSeq(n)
	_PPTGCommaSeq n;
#endif
{
	n->p1->_print(n->p1);
	if (n->p1 != PTGNULL && n->p2 != PTGNULL)
	{
		PTG_OUTPUT_STRING(f, ", ");
	}
	n->p2->_print(n->p2);
}

#ifdef PROTO_OK
PTGNode PTGCommaSeq(PTGNode p1, PTGNode p2)
#else
PTGNode PTGCommaSeq(p1, p2)
PTGNode p1;
PTGNode p2;
#endif
{
	_PPTGCommaSeq n;

	n = (_PPTGCommaSeq)MALLOC(sizeof(struct _SPTGCommaSeq));
	if(p1 == PTGNULL && p2 == PTGNULL)
		return PTGNULL;

	n->_print = (_PTGProc)_PrPTGCommaSeq;
	n->p1 = p1;
	n->p2 = p2;
	return (PTGNode)n;
}

/* Implementation of Pattern Eol */

typedef struct _SPTGEol{
	_PTGProc _print;
	PTGNode p1;
} * _PPTGEol;

#ifdef PROTO_OK
static void _PrPTGEol(_PPTGEol n)
#else
static void _PrPTGEol(n)
	_PPTGEol n;
#endif
{
	n->p1->_print(n->p1);
	PTG_OUTPUT_STRING(f, "\n");
}

#ifdef PROTO_OK
PTGNode PTGEol(PTGNode p1)
#else
PTGNode PTGEol(p1)
PTGNode p1;
#endif
{
	_PPTGEol n;

	n = (_PPTGEol)MALLOC(sizeof(struct _SPTGEol));
	n->_print = (_PTGProc)_PrPTGEol;
	n->p1 = p1;
	return (PTGNode)n;
}


/* -------------------------------------------------------- */
/*                  Default Output Functions                */
/* -------------------------------------------------------- */


#ifdef PROTO_OK
void _PTGPrintInt(PTG_OUTPUT_FILE file, int param)
#else
void _PTGPrintInt(file, param)
	PTG_OUTPUT_FILE file; int param;
#endif
{    /* used for short and int */
	sprintf(buffer,"%d",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintLong(PTG_OUTPUT_FILE file, long param)
#else
void _PTGPrintLong(file, param)
	PTG_OUTPUT_FILE file; long param;
#endif
{
	sprintf(buffer,"%ld",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintDouble(PTG_OUTPUT_FILE file, double param)
#else
void _PTGPrintDouble(file, param)
	PTG_OUTPUT_FILE file; double param;
#endif
{    /* used for float and double */
	sprintf(buffer,"%g",param);
	PTG_OUTPUT_STRING(file,buffer);
}

#ifdef PROTO_OK
void _PTGPrintChar(PTG_OUTPUT_FILE file, char param)
#else
void _PTGPrintChar(file, param)
	PTG_OUTPUT_FILE file; char param;
#endif
{
	buffer[0] = param;
	buffer[1] = 0;
	PTG_OUTPUT_STRING(file,buffer);
}

