/* $Id: CompSet.c,v 1.5 1997/01/02 08:56:00 uwe Exp $ */
/* Copyright, 1996, AG-Kastens, University Of Paderborn */

#include "CompSet.h"
#include "LIGAMacros.h"
#include "liga_func.h"
#include "ligaconsts.h"

Call MarkBottomUp (ex, line, col)
   Expr ex;
   int line, col;
/* ex is embedded in a call BOTTOMUPFCT (ex).
   ex is either a plain computation or 
   the rhs of an attribute computation
*/
{
   return
      MkCall (BOTTOMUPFCT, creatSEQExpr(ex), line, col);
}/* MarkBottomUp */

Call PlainToAssign (comp, attrid, coord) 
	Call comp; int attrid; POSITION *coord;
/*
   The computation is transformed into an ASSIGN to (lhs, attrid).
*/
{ Expr tmp1, tmp2;
  
  tmp1 = AttraccToExpr 
           (MkAttracc (0, attrid, coord->line, coord->col));
  tmp2 = CallToExpr (comp);
  return
    MkCall
      (ASSIGNFCT,
       AppFrontSEQExpr
         (tmp1, 
	  creatSEQExpr (tmp2)),
       coord->line, coord->col);
}/* PlainToAssign */

#if FORLATERUSE

/* implementation of computational sets may use this code.
*/
#include "pdl_gen.h"
#include "AttrDefs.h"
#include "Syntax.h"
#include "Names.h"
#include "GlobDef.h"

void SplitChainAssign (context, symb, lhs, rhs, islow, coord)
	DefTableKey context, symb; 
	Expr lhs, rhs; 
	int islow;
	POSITION *coord;
/* generates an attribute (symb, a)
   associates 2 computations to context:
   (0,a) = rhs; and lhs = (0,a);
   BOTTOMUP marks are separated from CHAIN computations this way.
*/
{ int attrid;
  DefTableKey attrkey;

  attrid = NewCntId ("_BUChain");
  attrkey = 
    DeclareExplAttr 
      (GetAttrScope (symb, NoEnv),
       attrid,
       DIDVOLI, ATCLSYNT, coord
      );

  if (context != symb) /* rule context */
    attrid = GetDid (attrkey, DIDNON);

  UpdateAttrib
   (context,
    CallToAttrrule
      (MkCall
        (ASSIGNFCT,
         AppFrontSEQExpr
           (AttraccToExpr (MkAttracc (0, attrid, coord->line, coord->col)),
	    creatSEQExpr (rhs)),
         coord->line, coord->col
        )
      ),
    islow
   );

  UpdateAttrib
   (context,
    CallToAttrrule
      (MkCall
        (ASSIGNFCT,
         AppFrontSEQExpr
           (lhs,
	    creatSEQExpr
	      (AttraccToExpr 
                 (MkAttracc (0, attrid, coord->line, coord->col))
              )
           ),
         coord->line, coord->col
        )
      ),
    islow
   );
}/* SplitChainAssign */

static
void AddDependency (rule, lhs, rhs, islow, line, col)
	DefTableKey rule; Expr lhs, rhs; int line, col;
{ Attrrule comp; Call assign;

  assign =
      MkCall
	(ASSIGNFCT,
	 AppFrontSEQExpr
	   (lhs,
	    AppFrontSEQExpr
	      (rhs,
	       creatSEQExpr
	         (NameToExpr(MkName(MULTMARK, line, col)))
	      )
	    ),
	 line, col
	);
  comp = CallToAttrrule (assign);
  UpdateAttrib (rule, comp, islow);
}/* AddDependency */

static
void IntoChainSet (rule, chain, assign)
	DefTableKey rule, chain; Attrrule assign;
/* let assign be (i,a) = f(...); then 2 dependencies are added:
   precondition:
   if i == 0:
	precondition:	(i,a) = (TAIL,chain)
	postcondition:	(0,chain) = (i,a)
problem if (i,a) is a chain access!

   if i >  0:
	precondition:	(i,a) = (i-1,chain)
     to a lower context for that symbol:
	postcondition:	(0,chain) = ((0,a), (0,chain)) 

several (0,chain) = ... do accumulate!
*/
{ Expr lhs, rhs;
  int symbno, chaindid, line, col;

  line = rowOfCall(AttrruleToCall(assign));
  col = colOfCall(AttrruleToCall(assign));

  retrievefirstSEQExpr (paramsOfCall(AttrruleToCall(assign)), lhs);
  if (typeof (lhs) == KAttracc)
     symbno = symbnoOfAttracc (ExprToAttracc (lhs));
  else
  if (typeof (lhs) == KChainacc)
     symbno = symbnoOfChainacc (ExprToChainacc (lhs));

  chaindid = GetDid (chain, DIDNON);

  if (symbno == 0)
  { AddDependency
	(rule,
	 CpExpr (lhs),
	 ChainaccToExpr
	   (MkChainacc (GetTAILpos (rule, 0), chaindid, line, col)),
	 1, /* islow */
	 line, col
	);
    AddDependency
	(rule,
	 ChainaccToExpr (MkChainacc (0, chaindid, line, col)),
	 CpExpr (lhs),
	 1, /* islow */
	 line, col
	);
  } else
  { AddDependency
	(rule,
	 CpExpr (lhs),
	 ChainaccToExpr (MkChainacc (symbno-1, chaindid, line, col)),
	 0, /* not islow */
	 line, col
	);

    if (typeof (lhs) == KAttracc)
       rhs =
         AttraccToExpr
            (MkAttracc (0, attridOfAttracc(ExprToAttracc(lhs)),
			line, col));
    else
    if (typeof (lhs) == KChainacc)
       rhs =
         ChainaccToExpr
            (MkChainacc (0, chainidOfChainacc(ExprToChainacc(lhs)), 
			 line, col));
    AddDependency
	(FindRuleForLhs (FindSymbOfRulePos (rule, symbno)),
	 ChainaccToExpr (MkChainacc (0, chaindid, line, col)),
	 rhs,
	 1, /* islow */
	 line, col
	);
  }
}/* IntoChainSet */

static DefTableKey BUChain = NoKey;
static Environment globenv, globattrenv;
static DefTableKey rootprod = NoKey;

static
void FindRootProd ()
{ Scope alldefs = DefinitionsOf (globenv);
  while (alldefs != NoScope)
  { DefTableKey symkey = KeyOf (alldefs);
    if (SymDef == GetDefKind (symkey, TypeDef) &&
	GetIsRoot (symkey, 0))
    { rootprod = FindRuleForLhs (symkey);
      return;
    }
    alldefs = NextDefinition (alldefs);
  }
}/* FindRootProd */

static POSITION NullPos = {0, 0};

static
void InitBUChain ()
{ if (BUChain == NoKey)
  { int headpos;

/* create BUChain: */
    BUChain = DeclareAttrName 
		(globattrenv, 
		 NewId ("$BUChain"), 
		 isChainAttr, DIDVOLI, ATCLUNKN,
		 GetCoord (rootprod, &NullPos));

/* ChainStart in rootprod: */
    UpdateAttrib
      (rootprod,
       ChainStartToAttrrule 
         (MkChainStart 
            (GetDid (BUChain, DIDNON), "", "", 0, 0)),
       1 /* islow */
      );

/* chain head assign in rootprod: */
    headpos = GetHEADpos (rootprod, 0);
    if (headpos == 0) return;
    UpdateAttrib
      (rootprod,
       CallToAttrrule
         (MkCall
	    (ASSIGNFCT,
	     AppFrontSEQExpr
	       (ChainaccToExpr
		  (MkChainacc 
		     (headpos,
		      GetDid (BUChain, DIDNON),
		      0, 0
		     )
		  ),
		creatSEQExpr (NameToExpr(MkName("x", 0, 0)))
	       ),
	     0, 0
	    )
	  ),
       0 /* not islow */
      );
  }
}/* InitBUChain */

void TransCompSets (env, attrenv) Environment env, attrenv;
/* inserts each BOTTOMUP rule computation into BUChain */
{ Scope alldefs = DefinitionsOf (env);

/* UNUSED; no BUChain created;
   may be modified for computational sets
*/
  globenv = env;
  globattrenv = attrenv;
  FindRootProd ();

  while (alldefs != NoScope)
  { DefTableKey rulekey = KeyOf (alldefs);
    if (RuleDef == GetDefKind (rulekey, TypeDef))
    { SEQAttrrule atrs; Attrrule atrule;

      foreachinSEQAttrrule
	(GetAttrib (rulekey, nullSEQAttrrule()), atrs, atrule)
      if (typeof (atrule) == KCall)
      { Call ca = AttrruleToCall (atrule);
        if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0)
	{ Expr rhs;
	  retrievefirstSEQExpr (tailSEQExpr (paramsOfCall (ca)), rhs);
	  if (typeof (rhs) == KCall)
	  { Call rhsca = ExprToCall (rhs);
	    if (strcmp (BOTTOMUPFCT, nameOfCall (rhsca)) == 0)
	    { Expr lhs; Attracc at;
	      retrievefirstSEQExpr (paramsOfCall (ca), lhs);
	      at = ExprToAttracc (lhs);
	      if (rulekey == rootprod &&
		  symbnoOfAttracc (at) == 0)
		continue; /* trivial bottomup */

              InitBUChain ();
	      IntoChainSet (rulekey, BUChain, atrule);
	    }/* BOTTOMUPFCT */
	  }/* rhs Call */
	}/* ASSIGNFCT */
      }/* if KCall, foreachinSEQAttrrule */
    }/* RuleDef */
    alldefs = NextDefinition (alldefs);
  }/* while alldefs */

  if (BUChain != NoKey)
  { /* insert a BUChain access into every context: */
    alldefs = DefinitionsOf (env);
    while (alldefs != NoScope)
    { DefTableKey rulekey = KeyOf (alldefs);
      if (RuleDef == GetDefKind (rulekey, TypeDef) &&
	  rulekey != rootprod)
        UpdateAttrib
	  (rulekey,
	   CallToAttrrule
	     (MkCall
	        (IDFCT,
		 creatSEQExpr
		   (ChainaccToExpr
		      (MkChainacc
		         (0, GetDid (BUChain, DIDNON), 0, 0)
                      )
                   ),
		 0, 0
                )
             ),
	   1 /* islow */
          );

      alldefs = NextDefinition (alldefs);
    }
  }
}/* TransCompSets */
#endif
