static char RCSid[] = "$Id: misc.c,v 1.5 1997/08/28 17:29:53 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/* This file is part of the Eli translator construction system.

Eli is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

Eli is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Eli; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "dj.h"
#define MAXLINE 200

/* allocate_array - allocate memory for an integer array of the given size */

char *allocate_array( size, element_size )
int size, element_size;

    {
    register char *mem = (char *)malloc( (unsigned) (element_size * size) );
 
    if ( mem == NULL )
        flexfatal( "memory allocation failed in allocate_array()" );
 
    return ( mem );
    }


/* reallocate_array - increase the size of a dynamic array */

char *reallocate_array( array, size, element_size )
char *array;
int size, element_size;

    {        
    register char *new_array;

    new_array = (char *)realloc( array, (unsigned) (size * element_size ));
 
    if ( new_array == NULL )
        flexfatal( "attempt to increase array size failed" );

    return ( new_array );                                     
    }
 



/* lerrif - report an error message formatted with one integer argument
 *
 * synopsis
 *    char msg[];
 *    int arg;
 *    lerrif( msg, arg );
 */

void lerrif( msg, arg)
char *msg;
int arg;

    {   
    char errmsg[MAXLINE];
    (void) sprintf( errmsg, msg, arg );
    flexerror( errmsg );
    }


/* lerrsf - report an error message formatted with one string argument
 *
 * synopsis
 *    char msg[], arg[];
 *    lerrsf( msg, arg );
 */
 
void lerrsf( msg, arg )
char *msg;
char *arg;
 
    {
    char errmsg[MAXLINE];
     
    (void) sprintf( errmsg, msg, arg );
    flexerror( errmsg );
    }
 
/* flexerror - report an error message and terminate
 *
 * synopsis
 *    char msg[];
 *    flexerror( msg );
 */
     
void flexerror( msg )
char *msg;
 
    {
    fprintf( stderr, "glagen: %s\n", msg );
    /*flexend( 1 );*/
    exit(1);
    }
 
 
/* flexfatal - report a fatal error message and terminate
 *
 * synopsis
 *    char msg[];
 *    flexfatal( msg );
 */
 
void flexfatal( msg )
char *msg;
 
    {
    fprintf( stderr, "glagen: fatal internal error %s\n", msg );
    /* flexend( 1 );*/
    exit(1);
    }
