/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * defaults.h
 */

#ifndef DEFAULTS_h
#define DEFAULTS_h

#include <symbols.h>

/* This file contains user defined DEFAULTS */
#define USAGE_STR "usage: dstool_tk <filename> [-version] [-large]\n\t[-debug] [-infile <filename>] [-outfile <filename>]"
#define MAX_CMD_LINE_ARG_LEN 300

/* automatically read configuration file */
#define CONFIG_FILENAME "dstool.config"

/* name of geomview executable */
#define GEOMVIEW_EXECUTABLE "geomview"

/* multiple */
#define MULT_RADIUS_FACTOR 0.01

/* default values for the Defaults window */
#define DEF_SAVE_POINTS TRUE   /* save points */
#define DEF_AUTO_REFRESH TRUE  /* automatically refresh 2-d windows */
#define DEF_SYMBOL_INDEX 1  /* a medium point */
#define DISP_TRAJ_ITERS 100 /* number of points to compute before displaying */
#define DEF_DIVERG_CUTOFF 1.e8 /* infinity for propagating */
#define DEF_PRECISION    17    /* sig digits displayed in text items */
#define DEF_SCALE_FACTOR 1.1  /* Factor for use in auto-scaling plot windows */





/* BELOW stuff not used yet - paw  4/18/93 */


/* file loaded into message win */
#define DSTOOL_MSG "dstool.msg"

/* default trajectory colormap */
#define TRAJ_COLORMAP "colormap"

/* default system colormap */
#define SYS_COLORMAP "sys_colormap"


/* defaults for orbit window */
#define TOTAL_ITERATES 5000
#define START_SAVE_POINTS 0
#define SKIP_SIZE 1
#define STEPSIZE 0.01

/* default values for print window */
#define		PRINTER_NAME	"lp"
#define		PROLOG_FILE	"Prolog.ps"
#define		TITLE_PT_SIZE	14
#define		LABEL_PT_SIZE	10
#define		NUM_X_TICKS	3
#define		NUM_Y_TICKS	3
#define		BBOX_HOR_LEN	450 		/* fjw 7/30/92 */
#define		BBOX_VER_LEN	450
#define		BBOX_HOR_OFF	80
#define		BBOX_VER_OFF	145

#define		BUFFERSIZE	1024


/* defaults values for the periodic/fixed point algorithms */
#define         MAP_PERIOD      1
#define         FXPT_ALGORITHM  NEWTON             /* NEWTON or SECANT */
#define         FXPT_GUESS      0
#define         MC_GUESSES      10
#define         FIXPT_ITERS     30
#define 	DUP_DIFF	1.e-6
#define		VARB_CONV	1.e-9
#define		FUNCTION_CONV	1.e-8
#define		EIGEN_DIST	1.e-6
#define         STAB_POINTS     1
#define         STAB_STEPS      200
#define         UNSTAB_POINTS   1
#define         UNSTAB_STEPS    200
#define         DELTAX          1.e-6
#define         EVAL_TOLERANCE  1.e-6
#define         UNSTAB_MAN_COLOR SYS_RED
#define         UNSTAB_MAN_SYMBOL MED_POINT
#define         STAB_MAN_COLOR  SYS_BLUE
#define         STAB_MAN_SYMBOL MED_POINT
#define         SADDLE_COLOR    SYS_GREEN
#define         SADDLE_SYMBOL   MED_CROSS
#define         SOURCE_COLOR    SYS_RED
#define         SOURCE_SYMBOL   MED_BOX
#define         SINK_COLOR      SYS_BLUE
#define         SINK_SYMBOL     MED_TRI
#define         DEFAULT_FP_COLOR SYS_GREEN
#define         DEFAULT_FP_SYMBOL LARGE_POINT

/* default values for multiple window */
#define         MULT_MAXSTEPS   10000


/* default values for twoD manifold stuff */
#define         MAN2_EIGEN_DIST     1.e-6
#define         MAN2_STEPSIZE       0.01
#define         MAN2_STEPS          20
#define         MAN2_POINTS         10
#define         MAN2_DIST           1.0
#define         MAN2_SKIP           10

#endif
/* !DEFAULTS_h */




