### Copyright (C) 1996 Rasmus Ingemann Hansen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc bool {onoff} {
	if {[string tolower $onoff] == "on"} {
		return 1
	} else {
		return 0
	}
}

proc elmparser {filename list} {
  ### ~/.elm/elmrc ###
	set elmfile [open ~/.elm/elmrc]
	while {![eof $elmfile]} {
		gets $elmfile line
		if [regexp {^\#} $line || regexp {^\n} $line] {
			gets $elmfile line
		}

		### mask out EXPR: ^( )*EXPR( )*=( )*(.)*$
   	        if [regexp -nocase {^[ ]*editor[ ]*=[ ]*(.*)$} $line all file(editor)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*easyeditor[ ]*=[ ]*(.*)$} $line all file(easyeditor)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*visualeditor[ ]*=[ ]*(.*)$} $line all file(visualeditor)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*alteditor[ ]*=[ ]*(.*)$} $line all file(alteditor)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*escape[ ]*=[ ]*(.*)$} $line all file(escape)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*autocopy[ ]*=[ ]*(.*)$} $line all file(autocopy)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*prefix[ ]*=[ ]*(.*)$} $line all file(prefix)] {
			continue
		}
  	        if [regexp -nocase {^[ ]*attribution[ ]*=[ ]*(.*)$} $line all file(attribution)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*sigdashes[ ]*=[ ]*(.*)$} $line all file(sigdashes)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*localsignature[ ]*=[ ]*(.*)$} $line all file(localsignature)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*remotesignature[ ]*=[ ]*(.*)$} $line all file(remotesignature)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*signature[ ]*=[ ]*(.*)$} $line all file(signature)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*textencoding[ ]*=[ ]*(.*)$} $line all file(textencoding)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*precedences[ ]*=[ ]*(.*)$} $line all file(precedences)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*noheader[ ]*=[ ]*(.*)$} $line all file(noheader)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*pager[ ]*=[ ]*(.*)$} $line all file(pager)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*builtinlines[ ]*=[ ]*(.*)$} $line all file(builtinlines)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*promptafter[ ]*=[ ]*(.*)$} $line all file(promptafter)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*weed[ ]*=[ ]*(.*)$} $line all file(weed)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*weedout[ ]*=[ ]*(.*)$} $line all file(weedout)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*titles[ ]*=[ ]*(.*)$} $line all file(titles)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*displaycharset[ ]*=[ ]*(.*)$} $line all file(displaycharset)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*charset[ ]*=[ ]*(.*)$} $line all file(charset)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*compatcharsets[ ]*=[ ]*(.*)$} $line all file(compatcharsets)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*menu[ ]*=[ ]*(.*)$} $line all file(menu)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*userlevel[ ]*=[ ]*(.*)$} $line all file(userlevel)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*arrow[ ]*=[ ]*(.*)$} $line all file(arrow)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*sortby[ ]*=[ ]*(.*)$} $line all file(sortby)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*movepage[ ]*=[ ]*(.*)$} $line all file(movepage)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*keypad[ ]*=[ ]*(.*)$} $line all file(keypad)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*softkeys[ ]*=[ ]*(.*)$} $line all file(softkeys)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*pointnew[ ]*=[ ]*(.*)$} $line all file(pointnew)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*resolve[ ]*=[ ]*(.*)$} $line all file(resolve)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*readmsginc[ ]*=[ ]*(.*)$} $line all file(readmsginc)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*timeout[ ]*=[ ]*(.*)$} $line all file(timeout)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*names[ ]*=[ ]*(.*)$} $line all file(names)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*metoo[ ]*=[ ]*(.*)$} $line all file(metoo)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*aliassortby[ ]*=[ ]*(.*)$} $line all file(aliassortby)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*alwayskeep[ ]*=[ ]*(.*)$} $line all file(alwayskeep)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*alwaysdelete[ ]*=[ ]*(.*)$} $line all file(alwaysdelete)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*alwaysstore[ ]*=[ ]*(.*)$} $line all file(alwaysstore)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*copy[ ]*=[ ]*(.*)$} $line all file(copy)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*forcename[ ]*=[ ]*(.*)$} $line all file(forcename)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*keepempty[ ]*=[ ]*(.*)$} $line all file(keepempty)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*savename[ ]*=[ ]*(.*)$} $line all file(savename)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*receivedmail[ ]*=[ ]*(.*)$} $line all file(receivedmail)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*sentmail[ ]*=[ ]*(.*)$} $line all file(sentmail)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*maildir[ ]*=[ ]*(.*)$} $line all file(maildir)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*tmpdir[ ]*=[ ]*(.*)$} $line all file(tmpdir)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*confirmappend[ ]*=[ ]*(.*)$} $line all file(confirmappend)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*confirmfiles[ ]*=[ ]*(.*)$} $line all file(confirmfiles)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*confirmcreate[ ]*=[ ]*(.*)$} $line all file(confirmcreate)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*confirmfolders[ ]*=[ ]*(.*)$} $line all file(confirmfolders)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*sleepmsg[ ]*=[ ]*(.*)$} $line all file(sleepmsg)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*ask[ ]*=[ ]*(.*)$} $line all file(ask)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*askcc[ ]*=[ ]*(.*)$} $line all file(askcc)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*forms[ ]*=[ ]*(.*)$} $line all file(forms)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*usetite[ ]*=[ ]*(.*)$} $line all file(usetite)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*bounceback[ ]*=[ ]*(.*)$} $line all file(bounceback)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*calendar[ ]*=[ ]*(.*)$} $line all file(calendar)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*shell[ ]*=[ ]*(.*)$} $line all file(shell)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*print[ ]*=[ ]*(.*)$} $line all file(print)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*fullname[ ]*=[ ]*(.*)$} $line all file(fullname)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*alternatives[ ]*=[ ]*(.*)$} $line all file(alternatives)] {
			continue
		}
   	        if [regexp -nocase {^[ ]*configoptions[ ]*=[ ]*(.*)$} $line all file(configoptions)] {
			continue
		}
	}
	close $elmfile


  ### argument "filename" ###
	set File [open $filename w]
	### "editor" page ###
	puts $File "PAGE editor"
	if {[info exist file(editor)]} {
	    if {[string tolower $file(editor)] == "none"} {
		puts $File "RADIO editorRadio1 \"Use builtin = simulate Berkeley Mail\""
		puts $File "ENTRY editorDir1 \"emacs\""
		puts $File "COMMAND com_editorDir1 \"emacs\""
	    } else {
		puts $File "RADIO editorRadio1 \"Use editor of your own choice\""
		puts $File "ENTRY editorDir1 \"$file(editor)\""
		puts $File "COMMAND com_editorDir1 \"$file(editor)\""
	    }
	} else {
	    puts $File "RADIO editorRadio1 \"Use editor of your own choice\""
	    puts $File "ENTRY editorDir1 \"emacs\"
	    puts $File "COMMAND com_editorDir1 \"emacs\"
	}
	if {[info exist file(easyeditor)]} {
	    puts $File "ENTRY editorDir5 \"$file(easyeditor)\""
	    puts $File "COMMAND com_editorDir5 \"$file(easyeditor)\""
	} else {
	    puts $File "ENTRY editorDir5 \"emacs\""
	    puts $File "COMMAND com_editorDir5 \"emacs\""
	}
	if {[info exist file(visualeditor)]} {
	    puts $File "ENTRY editorDir6 \"$file(visualeditor)\""
	    puts $File "COMMAND com_editorDir6 \"$file(visualeditor)\""
	} else {
	    puts $File "ENTRY editorDir6 \"vi\""
	    puts $File "COMMAND com_editorDir6 \"vi\""
	}
	if {[info exist file(alteditor)]} {
	    puts $File "ENTRY editorDir7 \"$file(alteditor)\""
	    puts $File "COMMAND com_editorDir7 \"$file(alteditor)\""
	} else {
	    puts $File "ENTRY editorDir7 \"emacs\""
	    puts $File "COMMAND com_editorDir7 \"emacs\""
	}
	if {[info exist file(escape)]} {
	    puts $File "ENTRY editorEntry6 \"$file(escape)\""
	} else {
	    puts $File "ENTRY editorEntry6 \"~\""
	}

	### "quoting" page ###
	puts $File "PAGE quoting"
	if {[info exist file(autocopy)]} {
	    puts $File "CHECKBOX formatCheckBox17 [bool $file(autocopy)]"
	} else {
	    puts $File "CHECKBOX formatCheckBox17 0"
	}
	if {[info exist file(prefix)]} {
	    puts $File "CHECKBOX formatCheckBox1 1"
	    puts $File "ENTRY editorOptionsEntry11 \"$file(prefix)\""
	} else {
	    puts $File "CHECKBOX formatCheckBox1 0"
	    puts $File "ENTRY editorOptionsEntry11 \">_\""
	}
	if {[info exist file(attribution)]} {
	    puts $File "CHECKBOX quotingCheckBox1 1"
	    puts $File "ENTRY quotingEntry1 \"$file(attribution)\""
	} else {
	    puts $File "CHECKBOX quotingCheckBox1 1"
	    puts $File "ENTRY quotingEntry1 \"Quoting %s:\""
	}

	### "signature" page ###
	puts $File "PAGE signature"
	if {[info exist file(sigdashes)]} {
	    puts $File "CHECKBOX signatureCheckBox1 [bool $file(sigdashes)]"
	} else {
	    puts $File "CHECKBOX signatureCheckBox1 1"
	}
	if {[info exist file(signature)] || [info exist file(localsignature)] || [info exist file(remotesignature)]} {
            puts $File "CHECKBOX editorOptionsCheckBox33 1"
        } else {
            puts $File "CHECKBOX editorOptionsCheckBox33 0"
	}
	if {[info exist file(signature)]} {
            puts $File "CHECKBOX editorOptionsCheckBox22 1"
            set temp3 file(signature)
	    puts $File "ENTRY editorOptionsDir2 \"$file(signature)\""
	    puts $File "COMMAND com_editorOptionsDir2 \"$file(signature)\""
        } else {
            puts $File "CHECKBOX editorOptionsCheckBox22 0"
            set temp3 file(signature)
	    puts $File "ENTRY editorOptionsDir2 \"\""
	    puts $File "COMMAND com_editorOptionsDir2 \"\""
        }
	if {[info exist file(localsignature)] || [info exist file(localsignature)]} {
            puts $File "CHECKBOX editorOptionsCheckBox22 0"
        }
	if {[info exist file(localsignature)]} {
            puts $File "ENTRY editorOptionsDir3 \"$file(localsignature)\""
            puts $File "COMMAND com_editorOptionsDir3 \"$file(localsignature)\""
        } else {
            puts $File "ENTRY editorOptionsDir3 \"\""
            puts $File "COMMAND com_editorOptionsDir3 \"\""
        }
	if {[info exist file(remotesignature)]} {
            puts $File "ENTRY editorOptionsDir4 \"$file(remotesignature)\""
            puts $File "COMMAND com_editorOptionsDir4 \"$file(remotesignature)\""
        } else {
            puts $File "ENTRY editorOptionsDir4 \"\""
            puts $File "COMMAND com_editorOptionsDir4 \"\""
        }

	### "textencoding" page ###
	puts $File "PAGE textencoding"
	if {[info exist file(textencoding)]} {
 	    if {[string tolower $file(textencoding)]=="7bit"} {
	        puts $File "RADIO textencodeRadio1 \"7bit\""
	    } elseif {[string tolower $file(textencoding)]=="8bit"} {
	        puts $File "RADIO textencodeRadio1 \"8bit\""
	    } elseif {[string tolower $file(textencoding)]=="base64"} {
	        puts $File "RADIO textencodeRadio1 \"base64\""
	    } elseif {[string tolower $file(textencoding)]=="quoted-printable"} {
	        puts $File "RADIO textencodeRadio1 \"quoted-printable\""
            }
	} else {
             puts $File "RADIO textencodeRadio1 \"8bit\""
        }

	### "editingheaders" page ###
	puts $File "PAGE editingheaders"
	if {[info exist file(precedences)]} {
	    puts $File "CHECKBOX headerCheckBox1 1"
	    puts $File "ENTRY editorOptionsEntry11 \"$file(precedences)\""
	} else {
	    puts $File "CHECKBOX headerCheckBox1 0"
	    puts $File "ENTRY editorOptionsEntry11 \"\""
        }
	if {[info exist file(noheader)]} {
	    if {[bool $file(noheader)]==0} {
		puts $File "CHECKBOX editorOptionsCheckBox29 1"
	    } else {
		puts $File "CHECKBOX editorOptionsCheckBox29 0"
	    }
	} else {
	    puts $File "CHECKBOX editorOptionsCheckBox29 0"
	}

	### "viewer" page ###
	puts $File "PAGE viewer"
	if {[info exist file(pager)]} {
	    if {[string tolower $file(pager)]=="builtin" || [string tolower $file(pager)]=="builtin+"} {
                puts $File "RADIO editorOptionsRadio2 \"Builtin (recommended)\""
            } else {
                puts $File "RADIO editorOptionsRadio2 \"Use another editor for viewing\""
            }
	    if {[string tolower $file(pager)]=="builtin"} {
                puts $File "RADIO viewerRadio1 \"Builtin\""
            } elseif {[string tolower $file(pager)]=="builtin+"} {
                puts $File "RADIO viewerRadio1 \"Builtin+ (recommended)\""
            } else {
                puts $File "ENTRY editorOptionsDir1 \"$file(pager)\""
                puts $File "COMMAND com_editorOptionsDir1 \"$file(pager)\""
            }
	} else {
                puts $File "RADIO viewerRadio1 \"Builtin+ (recommended)\""
                puts $File "ENTRY editorOptionsDir1 \"emacs\""
                puts $File "COMMAND com_editorOptionsDir1 \"emacs\""
        }
        puts $File "CHECKBOX viewerCheckBox1 0"
        puts $File "ENTRY editorOptionsTextBox1 \"\""
	if {[info exist file(promptafter)]} {
	    puts $File "CHECKBOX viewerCheckBox3 [bool $file(promptafter)]"
        } else {
	    puts $File "CHECKBOX viewerCheckBox3 1"
        }
	if {[info exist file(builtinlines)]} {
	    if {$file(builtinlines)==0} {
	        puts $File "CHECKBOX viewerCheckBox2 0"
	        puts $File "INT viewerInt1 0"
            } else {
	        puts $File "CHECKBOX viewerCheckBox2 1"
	        puts $File "INT viewerInt1 \"$file(builtinlines)\""
            }
        } else {
	    puts $File "CHECKBOX viewerCheckBox2 1"
	    puts $File "INT viewerInt1 -3"
        }

	### "viewingheaders" page ###
	puts $File "PAGE viewingheaders"
	if {[info exist file(weed)]} {
            puts $File "CHECKBOX actionMenuCheckBox00 [bool $file(weed)]"
        } else {
            puts $File "CHECKBOX actionMenuCheckBox00 1"
        }
	if {[info exist file(weedout)]} {
            puts $File "TEXTBOX  actionMenuEntry00 {$file(weedout)}"
        } else {
            puts $File "TEXTBOX  actionMenuEntry00 {\">From\" \"Path:\" \"Sent:\" \"Sender:\" \"In-Reply-To:\" \"References:\" \"Newsgroups:\" \"Received:\" \"Aparently-To\" \"Message-Id:\" \"Content-Type:\" \"X-Status\" \"From:\" \"Mailer:\" \"*end-of-user-headers*\"}"
        }
	if {[info exist file(titles)]} {
            puts $File "CHECKBOX headersCheckBox12 [bool $file(titles)]"
        } else {
            puts $File "CHECKBOX headersCheckBox12 1"
        }

	### "viewingcharset" page ###
	puts $File "PAGE viewingcharset"
	if {[info exist file(displaycharset)]} {
            puts $File "ENTRY formatEntry0 \"$file(displaycharset)\""
        } else {
            puts $File "ENTRY formatEntry0 \"ISO-8859-1\""
        }
	if {[info exist file(charset)]} {
            puts $File "ENTRY formatEntry1 \"$file(charset)\""
        } else {
            puts $File "ENTRY formatEntry1 \"ISO-8859-1\""
        }
	if {[info exist file(compatcharsets)]} {
            puts $File "ENTRY formatEntry2 \"$file(compatcharsets)\""
        } else {
            puts $File "ENTRY formatEntry2 \"ISO-8859-1 ISO-8859-2 ISO-8859-3 ISO-8859-4 ISO-8859-5 ISO-8859-7 ISO-8859-8 ISO-8859-9\""
        }

	### "layout" page ###
	puts $File "PAGE layout"
	if {[info exist file(menu)]} {
            puts $File "CHECKBOX actionMenuCheckBox1 [bool $file(menu)]"
        } else {
            puts $File "CHECKBOX actionMenuCheckBox1 1"
        }
	if {[info exist file(userlevel)]} {
            if {$file(userlevel)==0} {
                puts $File "RADIO actionMenuRadio1 \"Beginner level\""
            } elseif {$file(userlevel)==1} {
                puts $File "RADIO actionMenuRadio1 \"Intermediate level\""
            } else {
                puts $File "RADIO actionMenuRadio1 \"Expert level\""
            }
        } else {
            puts $File "RADIO actionMenuRadio1 \"Intermediate level\""
        }
	if {[info exist file(arrow)]} {
            if {[bool $file(arrow)] == 1} {
                puts $File "MENU actionMenuMenu1 \"arrow '->'\""
            } else {
                puts $File "MENU actionMenuMenu1 \"highlighted bar\""
            }
        } else {
            puts $File "MENU actionMenuMenu1 \"highlighted bar\""
        }
    ###### sortby = Reverse-Status ######
	set sortby_illegal_option 0
        if {[info exist file(sortby)]} {
            set str [string tolower $file(sortby)]
            regexp {^(reverse-)?(.*)$} $str all prefix txt
            switch $txt {
                sent {puts $File "MENU actionMenuMenu2 \"Date Mail sent\""}
                received {puts $File "MENU actionMenuMenu2 \"Date mail received\""}
                from {puts $File "MENU actionMenuMenu2 \"Message sender\""}
                lines {puts $File "MENU actionMenuMenu2 \"Lines in sender\""}
                subject {puts $File "MENU actionMenuMenu2 \"Message subject\""}
                status {puts $File "MENU actionMenuMenu2 \"Message status\""}
                mailbox {puts $File "MENU actionMenuMenu2 \"Mailbox order\""}
                default {puts $File "MENU actionMenuMenu2 \"Date Mail sent\""
		         set sortby_illegal_option 1}
            }
	    if {$sortby_illegal_option != 1} {
		if {$prefix == "reverse-"} {
		    puts $File "MENU actionMenuMenu3 \"top\""
		} else {
		    puts $File "MENU actionMenuMenu3 \"bottom\""
		}
            }
        } else {
                puts $File "MENU actionMenuMenu2 \"Date Mail sent\""
                puts $File "MENU actionMenuMenu3 \"top\""
	}

	### "navigation" page ###
	puts $File "PAGE navigation"
	if {[info exist file(movepage)]} {
            puts $File "CHECKBOX actionMenuCheckBox44 [bool $file(movepage)]"
        } else {
            puts $File "CHECKBOX actionMenuCheckBox44 0"
        }
	if {[info exist file(keypad)]} {
            if {[bool $file(keypad)]==0} {
                puts $File "CHECKBOX actionMenuCheckBox3 0"
                puts $File "CHECKBOX actionMenuCheckBox33 0"
            } else { 
                puts $File "CHECKBOX actionMenuCheckBox3 1"
                puts $File "CHECKBOX actionMenuCheckBox33 1"
            } 
        } else {
            puts $File "CHECKBOX actionMenuCheckBox3 0"
            puts $File "CHECKBOX actionMenuCheckBox33 0"
        }
	if {[info exist file(softkeys)]} {
            if {[bool $file(softkeys)]==0} {
                puts $File "CHECKBOX actionMenuCheckBox4 0"
            } else { 
                puts $File "CHECKBOX actionMenuCheckBox4 1"
                puts $File "CHECKBOX actionMenuCheckBox33 1"
            } 
        } else {
            puts $File "CHECKBOX actionMenuCheckBox4 0"
        }

	### "behavior" page ###
	puts $File "PAGE behavior"
	if {[info exist file(pointnew)]} {
            puts $File "CHECKBOX actionMenuCheckBox2 [bool $file(pointnew)]"
        } else {
            puts $File "CHECKBOX actionMenuCheckBox2 1"
        }
	if {[info exist file(resolve)]} {
            puts $File "CHECKBOX actionMenuCheckBox23 [bool $file(resolve)]"
        } else {
            puts $File "CHECKBOX actionMenuCheckBox23 1"
        }
	if {[info exist file(readmsginc)]} {
            puts $File "INT actionMenuInt1 $file(readmsginc)"
        } else {
            puts $File "INT actionMenuInt1 10"
        }
	if {[info exist file(timeout)]} {
            puts $File "INT actionMenuInt2 $file(timeout)"
        } else {
            puts $File "INT actionMenuInt2 300"
        }

	### "optionmenu" page ###
	puts $File "PAGE optionmenu"
        puts $File "EXTENTRY optionMenuEntry"
        set str "^cdefsopyv_am_un"
	set configoptions_empty 0
	set configoptions_ok 0
	if {[info exist file(configoptions)]} {
            if {$file(configoptions) != ""} {
                 set str $file(configoptions)
            }
        }
	# none option given or not legal option: 'configoptions=^cdefsopyv_am_un'
        while {[string length $str] != 0} {
                 set ch [string index $str 0]
                 switch $ch {
                     _ {puts $File "\{COMBOBOX optionMenuComboBox \"-- Blank line --\"\}"
		        set configoptions_ok 1}
                     a {puts $File "\{COMBOBOX optionMenuComboBox \"\[a] Arrow cursor\"\}"
		        set configoptions_ok 1}
                     b {puts $File "\{COMBOBOX optionMenuComboBox \"\[b] Border on copy\"\}"
		        set configoptions_ok 1}
                     d {puts $File "\{COMBOBOX optionMenuComboBox \"\[d] Display mail using\"\}"
		        set configoptions_ok 1}
                     e {puts $File "\{COMBOBOX optionMenuComboBox \"\[e] Primary editor\"\}"
		        set configoptions_ok 1}
                     f {puts $File "\{COMBOBOX optionMenuComboBox \"\[f] Folder directory\"\}"
		        set configoptions_ok 1}
                     h {puts $File "\{COMBOBOX optionMenuComboBox \"\[h] Hold sent message\"\}"
		        set configoptions_ok 1}
                     j {puts $File "\{COMBOBOX optionMenuComboBox \"\[j] Reply editor\"\}"
		        set configoptions_ok 1}
                     k {puts $File "\{COMBOBOX optionMenuComboBox \"\[k] Pause after pager\"\}"
		        set configoptions_ok 1}
                     l {puts $File "\{COMBOBOX optionMenuComboBox \"\[l] Alias sorting\"\}"
		        set configoptions_ok 1}
                     m {puts $File "\{COMBOBOX optionMenuComboBox \"\[m] Menu display\"\}"
		        set configoptions_ok 1}
                     n {puts $File "\{COMBOBOX optionMenuComboBox \"\[n] Names only\"\}"
		        set configoptions_ok 1}
                     o {puts $File "\{COMBOBOX optionMenuComboBox \"\[o] Outboard mail saved\"\}"
		        set configoptions_ok 1}
                     p {puts $File "\{COMBOBOX optionMenuComboBox \"\[p] Print mail using\"\}"
		        set configoptions_ok 1}
                     r {puts $File "\{COMBOBOX optionMenuComboBox \"\[r] Reply copies msg\"\}"
		        set configoptions_ok 1}
                     s {puts $File "\{COMBOBOX optionMenuComboBox \"\[s] Sorting criteria\"\}"
		        set configoptions_ok 1}
                     t {puts $File "\{COMBOBOX optionMenuComboBox \"\[t] Text editor (e)\"\}"
		        set configoptions_ok 1}
                     u {puts $File "\{COMBOBOX optionMenuComboBox \"\[u] User level\"\}"
		        set configoptions_ok 1}
                     v {puts $File "\{COMBOBOX optionMenuComboBox \"\[v] Visual editor\"\}"
		        set configoptions_ok 1}
                     y {puts $File "\{COMBOBOX optionMenuComboBox \"\[y] Your full name\"\}"
		        set configoptions_ok 1}
                     w {puts $File "\{COMBOBOX optionMenuComboBox \"\[w] Want Cc: prompt\"\}"
		        set configoptions_ok 1}
                     z {puts $File "\{COMBOBOX optionMenuComboBox \"\[z] Signature dashes\"\}"
		        set configoptions_ok 1}
		     default {set configoptions_empty 1}
              }
              set str [string range $str 1 end]
        }
	if {($configoptions_empty==1) && ($configoptions_ok==0)} {
		puts $File "\{ \}"
	}

	### "aliasmenu" page ###
	puts $File "PAGE aliasmenu"
	if {[info exist file(names)]} {
            puts $File "CHECKBOX aliasCheckBox2 [bool $file(names)]"
        } else {
            puts $File "CHECKBOX aliasCheckBox2 1"
        }
	if {[info exist file(metoo)]} {
            puts $File "CHECKBOX aliasCheckBox1 [bool $file(metoo)]"
        } else {
            puts $File "CHECKBOX aliasCheckBox1 0"
        }
    ###### aliassortby = Reverse-Name ######
        if {[info exist file(aliassortby)]} {
            set str [string tolower $file(aliassortby)]
            regexp {^(reverse-)?(.*)$} $str all prefix txt
            switch $txt {
                names {puts $File "MENU aliasMenu2 \"User-name\""}
                alias {puts $File "MENU aliasMenu2 \"Alias-name\""}
                text {puts $File "MENU aliasMenu2 \{\"aliases.text\"\}"}
            }
            if {$prefix == "reverse-"} {
                puts $File "MENU aliasMenu3 \"top\""
            } else {
                puts $File "MENU aliasMenu3 \"bottom\""
            }                
        }

	### "folderdecision" page ###
	puts $File "PAGE folderdecision"
	if {[info exist file(alwayskeep)]} {
            puts $File "CHECKBOX folderCheckBox2 [bool $file(alwayskeep)]"
        } else {
            puts $File "CHECKBOX folderCheckBox2 1"
        }
	if {[info exist file(alwaysdelete)]} {
            puts $File "CHECKBOX folderCheckBox1 [bool $file(alwaysdelete)]"
        } else {
            puts $File "CHECKBOX folderCheckBox1 0"
        }
	if {[info exist file(alwaysstore)]} {
            puts $File "CHECKBOX folderCheckBox3 [bool $file(alwaysstore)]"
        } else {
            puts $File "CHECKBOX folderCheckBox3 0"
        }
	if {[info exist file(copy)]} {
            puts $File "CHECKBOX folderCheckBox8 [bool $file(copy)]"
        } else {
            puts $File "CHECKBOX folderCheckBox8 0"
        }
	if {[info exist file(forcename)]} {
            puts $File "CHECKBOX folderCheckBox9 [bool $file(forcename)]"
        } else {
            puts $File "CHECKBOX folderCheckBox9 1"
        }
	if {[info exist file(keepempty)]} {
            puts $File "CHECKBOX folderCheckBox10 [bool $file(keepempty)]"
        } else {
            puts $File "CHECKBOX folderCheckBox10 0"
        }
	if {[info exist file(savename)]} {
            puts $File "CHECKBOX folderCheckBox11 [bool $file(savename)]"
        } else {
            puts $File "CHECKBOX folderCheckBox11 0"
        }

	### "foldercommunication" page ###
	puts $File "PAGE foldercommunication"
	if {[info exist file(receivedmail)]} {
            puts $File "ENTRY editorOptionsDir1 \"$file(receivedmail)\""
            puts $File "COMMAND com_editorOptionsDir1 \"$file(receivedmail)\""
        } else {
            puts $File "ENTRY editorOptionsDir1 \"=received\""
            puts $File "COMMAND com_editorOptionsDir1 \"=received\""
        }
	if {[info exist file(sentmail)]} {
            puts $File "ENTRY editorOptionsDir2 \"$file(sentmail)\""
            puts $File "COMMAND com_editorOptionsDir2 \"$file(sentmail)\""
        } else {
            puts $File "ENTRY editorOptionsDir2 \"=sent\""
            puts $File "COMMAND com_editorOptionsDir2 \"=sent\""
        }
	if {[info exist file(maildir)]} {
            puts $File "ENTRY editorOptionsDir3 \"$file(maildir)\""
            puts $File "COMMAND com_editorOptionsDir3 \"$file(maildir)\""
        } else {
            puts $File "ENTRY editorOptionsDir3 \"~/Mail\""
            puts $File "COMMAND com_editorOptionsDir3 \"~/Mail\""
        }
	if {[info exist file(tmpdir)]} {
            puts $File "ENTRY editorOptionsDir4 \"$file(tmpdir)\""
            puts $File "COMMAND com_editorOptionsDir4 \"$file(tmpdir)\""
        } else {
            puts $File "ENTRY editorOptionsDir4 \"/tmp/\""
            puts $File "COMMAND com_editorOptionsDir4 \"/tmp/\""
        }
	if {[info exist file(confirmappend)]} {
            puts $File "CHECKBOX folderCheckBox4 [bool $file(confirmappend)]"
        } else {
            puts $File "CHECKBOX folderCheckBox4 0"
        }
	if {[info exist file(confirmfiles)]} {
            puts $File "CHECKBOX folderCheckBox5 [bool $file(confirmfiles)]"
        } else {
            puts $File "CHECKBOX folderCheckBox5 0"
        }
	if {[info exist file(confirmcreate)]} {
            puts $File "CHECKBOX folderCheckBox6 [bool $file(confirmcreate)]"
        } else {
            puts $File "CHECKBOX folderCheckBox6 0"
        }
	if {[info exist file(confirmfolders)]} {
            puts $File "CHECKBOX folderCheckBox7 [bool $file(confirmfolders)]"
        } else {
            puts $File "CHECKBOX folderCheckBox7 0"
        }


	### "generel" page ###
	puts $File "page generel"
	if {[info exist file(sleepmsg)]} {
            puts $File "INT generelInt01 \"$file(sleepmsg)\""
        } else {
            puts $File "INT generelInt01 2"
        }
	if {[info exist file(ask)]} {
            puts $File "CHECKBOX generelCheckBox1 [bool $file(ask)]"
        } else {
            puts $File "CHECKBOX generelCheckBox1 0"
        }
	if {[info exist file(askcc)]} {
            puts $File "CHECKBOX generelCheckBox00 [bool $file(askcc)]"
        } else {
            puts $File "CHECKBOX generelCheckBox00 1"
        }
	if {[info exist file(forms)]} {
            puts $File "CHECKBOX generelCheckBox2 [bool $file(forms)]"
        } else {
            puts $File "CHECKBOX generelCheckBox2 0"
        }
	if {[info exist file(usetite)]} {
            puts $File "CHECKBOX generelCheckBox02 [bool $file(usetite)]"
        } else {
            puts $File "CHECKBOX generelCheckBox02 0"
        }
	if {[info exist file(bounceback)]} {
	    if {($file(bounceback)=="") || ($file(bounceback)=="0")} { 
		puts $File "CHECKBOX generelCheckBox3 0"
		puts $File "ENTRY generelEntry1 \"\""
	    } else {
		puts $File "CHECKBOX generelCheckBox3 1"
		puts $File "ENTRY generelEntry1 $file(bounceback)"
	    }
	} else {
	    puts $File "CHECKBOX generelCheckBox3 0"
	    puts $File "ENTRY generelEntry1 \"\""
	}
	if {[info exist file(calendar)]} {
            puts $File "ENTRY generelDir1 \"$file(calendar)\""
            puts $File "COMMAND com_generelDir1 \"$file(calendar)\""
        } else {
            puts $File "ENTRY generelDir1 \"~/\""
            puts $File "COMMAND com_generelDir1 \"~/\""
        }
	if {[info exist file(shell)]} {
            puts $File "ENTRY editorOptionsDir1 \"$file(shell)\""
            puts $File "COMMAND com_editorOptionsDir1 \"$file(shell)\""
        } else {
            puts $File "ENTRY editorOptionsDir1 \"bash\""
            puts $File "COMMAND com_editorOptionsDir1 \"bash\""
        }
	if {[info exist file(print)]} {
            puts $File "ENTRY printer \"$file(print)\""
        } else {
            puts $File "ENTRY printer \"lpr\""
        }
	if {[info exist file(fullname)]} {
            puts $File "ENTRY generelEE \"$file(fullname)\""
        } else {
            puts $File "ENTRY generelEE \"\""
        }
	if {[info exist file(alternatives)]} {
            puts $File "CHECKBOX actionMenuCheckBox007 1"
            puts $File "ENTRY actionMenuEntry007 \"$file(alternatives)\""
        } else {
            puts $File "CHECKBOX actionMenuCheckBox007 0"
            puts $File "ENTRY actionMenuEntry007 \"\""
        }

	close $File
}

