/*
 *  dlisp / a dancer's lisp parser library
 *  Copyright (C) 2002-2003 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * memory freeing routine
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "dlispparser.h"

/**
   Free memory allocated for the lisp data structure 
 */
void 
dlisp_free (dlisp_lispentry * e)
{
  if (!e)
    {
      fprintf (stderr, "FATAL: dlisp_freee was given a NULL pointer\n");
      exit (1);
    }
  
  if (e->next)
    dlisp_free(e->next);
  if (e->child)
    dlisp_free(e->child);
  if (e->name)
    free(e->name);
  free(e);
}
