#include "includes.h"
#include "dbus_service.h"
#include "dhcp_options.h"
#include "dhcdbd.h"

void handle_subscription(DBUS_SVC dbus, char *ip_if, char *opt, dbus_svc_MessageHandle msg)
{
    char *name=0L, *value=0L, *p, a[16];	
    uint32_t length;

    if( strcmp(opt,"reason") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%d\n", ip_if, name, *((uint32_t*)value));
	}
    }else
    if( strcmp(opt,"ip_address") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, (struct in_addr*)value, &(a[0]),16) 
	       );
	}
    }else
    if( strcmp(opt,"subnet_mask") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, (struct in_addr*)value, &(a[0]),16) 
	       );
	}
    }if( strcmp(opt,"broadcast_address") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, (struct in_addr*)value, &(a[0]),16) 
	       );
	}
    }else
    if( strcmp(opt,"routers") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    for(p=value; p < (value + length); p += sizeof(struct in_addr))
		printf("%s\t%s\t%s\n", ip_if, name, 
		    inet_ntop(AF_INET, (struct in_addr*)p, &(a[0]),16) 
		    );
	}
    }if( strcmp(opt,"domain_name_servers") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    for(p=value; p < (value + length); p += sizeof(struct in_addr))
		printf("%s\t%s\t%s\n", ip_if, name, 
		    inet_ntop(AF_INET, (struct in_addr*)p, &(a[0]),16) 
		    );
	}
    }else
    if( strcmp(opt,"domain_name") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_ARRAY, TYPE_BYTE, &value, &length,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, value);
	}
    }
}

void handle_state_change(DBUS_SVC dbus, char *ip_if, dbus_svc_MessageHandle msg)
{
    uint8_t state;
    if( dbus_svc_get_args(dbus, msg,
			  TYPE_BYTE, &state,
			  TYPE_INVALID
	                 )   
      )
	printf("%s\t state: %u\n", ip_if, state);
}

dbus_svc_HandlerResult
message_filter
(
    DBusMsgHandlerArgs
) 
{
    char *ip_if;
/*    printf("Filter: got message %u %u %s %s %s %s %s %s\n",
 *	   reply_expected, serial, destination, path, member, interface, sender, signature
 *	);
 */
    if (  ( type == SIGNAL )
	&&( strcmp(path,"/org/freedesktop/DBus/Local") == 0 )
	&&( strcmp(member,"Disconnected") == 0 )
       ) 
    {
	dbus_svc_quit( dbus );
    }

    if ( strcmp(interface,"com.redhat.dhcp.subscribe.binary") == 0 )
    {
	ip_if = strrchr(path, '/');
	if( ip_if == 0L)
	    return HANDLED;
	++ip_if;
/*	printf("\t subscription: path:%s member:%s interface:%s ip_if:%s\n",
	       path,member,interface,ip_if
	    );
*/
	handle_subscription(dbus, ip_if, member, msg);
    }else
    if ( strcmp(interface,"com.redhat.dhcp.state") == 0 )
	handle_state_change(dbus, member, msg);

    return HANDLED;
}

uint8_t subscribe_to_dhcdbd
( DBUS_SVC dbus, char *type, int n_subs, ...)
{
    int i;
    va_list va;
    va_start(va, n_subs);
    char subs[1024], path[1024],*option_name;
    dbus_svc_MessageHandle msg;
    
    sprintf(subs,"com.redhat.dhcp.binary");
    sprintf(path,"/com/redhat/dhcp/subscribe");
    for(i = 0; i < n_subs; i++)
    {
	option_name = va_arg(va,char*);
	msg = dbus_svc_call
	      ( dbus,
		"com.redhat.dhcp",
		path,
		type,		
		subs,		
		TYPE_STRING, &option_name,
		TYPE_INVALID
	      );
	if(msg == 0L)
	    return 0;	
    }
    return 1;
}

int main( int argc, char **argv, char **envp )
{
    DBUS_SVC dbus;
    

    dbus = dbus_svc_init( DBUS_SYSTEM, 0L, 0L, 0L );

    if ( dbus == 0L )
    {
	printf("Failed to initialise D-Bus service.\n");
	return( 1 );
    }
	
    if ( !dbus_svc_add_message_filter
	 ( dbus, message_filter,1,
	   "type=signal"
	 )
       )return( 1 );

    
    if( ! subscribe_to_dhcdbd
	  ( dbus, "binary",  7,
	    "reason", "ip-address", "subnet-mask", "broadcast-address", "routers", "domain-name", "domain-name-servers"
	  )
      )
    {
	printf("subscription failed\n");
	return(1);
    }

    dbus_svc_main_loop( dbus, 0L);

    return(0);
}
