/*
 * search_line.h
 *   $Last modified: Thu Mar 30 22:06:54 2000$
 *                  Copyright (c) 1999 kamop
 * $Id: qanda.h,v 1.3 2000/03/30 13:09:24 kamop Exp $
 */

#include <stdio.h>
#include <regex.h>

typedef struct _qanda_t{
  char q[BUFSIZE];              /* question */
  char a[BUFSIZE];              /* answer */
  regex_t qr;                  /* regex compileed question */
} qanda_t;

typedef enum _qanda_type_t{
  PACKAGE,
  PRESET,
  FREQ,
} qanda_type_t;


#ifdef _QANDA_C

#define QANDA_DEFAULT_SIZE 50
#define QANDA_EXPAND_SIZE 10

#define START_QANDA_STR "[QANDA]"

qanda_t *qanda = NULL;
int qanda_size = 0;
int qanda_end = 0;

qanda_t *qanda_package = NULL;
int qanda_package_size = 0;
int qanda_package_end = 0;

qanda_t *qanda_preset = NULL;
int qanda_preset_size = 0;
int qanda_preset_end = 0;

char filename[BUFSIZE];
char package[BUFSIZE];
char up_ver[BUFSIZE];
char deb_ver[BUFSIZE];
char qanda_dir[BUFSIZE];

#define QANDA_FREQ_SIZE 7
qanda_t qanda_freq[QANDA_FREQ_SIZE] = {
  { "Do you want to continue.*", "y\n", 0 },
  { "Do you want to erase the downloaded \\.deb files .*", "y\n", 0 },
  { "Press enter to continue.*", "\n", 0 },
  { "Press ENTER to continue.*", "\n", 0 },
  { "\\[More\\].*", "\n", 0 },
  { ".*\\?.*\\[.*\\].*", "\n", 0 },
  { ".*\\[.*\\].*\\?.*", "\n", 0 }
};

void set_qanda_type(qanda_type_t);
void store_qanda_type(qanda_type_t);
void init_qanda();
void init_qanda_type();
void expand_qanda();
void setup_preset_qanda();
void setup_qanda();
void clear_qanda();
void init_qanda_freq();

void parse_qanda_file(FILE *);
FILE *open_qanda_file();
void close_qanda_file(FILE *);

qanda_t *get_qanda(int);
char *get_qanda_question(int);
char *get_qanda_answer(int);
regex_t *get_qanda_regex(int);
int get_qanda_size();
int get_qanda_end();
int get_qanda_freq_end();
int get_qanda_freq(int);

void set_qanda_dir();
void set_qanda_package(char *);
void set_qanda_up_ver(char *);
void set_qanda_deb_ver(char *);

#else

extern void set_qanda_type(qanda_type_t);
extern void store_qanda_type(qanda_type_t);
extern void init_qanda();
extern void init_qanda_type();
extern void setup_preset_qanda();
extern void setup_qanda();
extern void clear_qanda();

extern qanda_t *get_qanda(int);
extern char *get_qanda_question(int);
extern char *get_qanda_answer(int);
extern regex_t *get_qanda_regex(int);

extern int get_qanda_size();
extern int get_qanda_end();
extern int get_qanda_freq_end();
extern int get_qanda_freq(int);

extern void set_qanda_dir();
extern void set_qanda_package(char *);
extern void set_qanda_up_ver(char *);
extern void set_qanda_deb_ver(char *);
#endif
