/*
 * init.c
 *   $Last modified: Wed Dec 29 15:41:37 1999$
 * $Id: init.c,v 1.2 1999/12/29 06:42:21 kamop Exp $
 */

#define _INIT_C

#include "debwrap.h"

void init_dwrap(int argc, char *argv[])
{
  int i;
  char *c;
  FILE *fp;

  /* Set default log output FilePointer */
  logfp = stderr;
  if((c = getenv(ENV_LOG)) != NULL){
    if((fp = fopen(c, "a")) != NULL){
#ifdef DEBUG
      fprintf(stderr, "LOG FILE = %s\n", c);
#endif
      logfp = fp;
    }
  }

  /* Set qanda_dir */
  if((c = getenv(ENV_QANDA_DIR)) != NULL){
    strcpy(dwrap.qanda_dir, c);
  }else{
    strcpy(dwrap.qanda_dir, QANDADIR);
  }

  /* Set pre-qanda-file */
  if((c = getenv(ENV_QANDA_FILE)) != NULL){
    strcpy(dwrap.qanda_file, c);
  }else{
    strcpy(dwrap.qanda_file, "");
  }
  
  /* Handling args of subprocess */
  if(argc > 1)
    strcpy(dwrap.command, argv[1]);
  for(i = 0; i < argc - 1 ; i++){
    strcpy(dwrap.realargv[i], argv[i+1]);
    dwrap.argv[i] = dwrap.realargv[i];
  } /* for(i) */
  /*
  dwrap.argv[i] = dwrap.realargv[i];
  dwrap.argv[++i] = NULL;
  */
  if(argc > 1)
    dwrap.argv[i] = NULL;
} /* init_dwrap() */

dwrap_t *get_dwrap()
{
  return(&dwrap);
} /* get_dwrap() */

