/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gconf/gconf-client.h> 
#include <gnome.h>

#include "interface.h"
#include "support.h"

#include "main.h"
#include "gui_layout.h"
#include "done_clist.h"
#include "misc_gtk.h"
#include "callbacks.h"

/* GConf variables */
GConfClient *gconf_engine=NULL;

static pid_t dc_gui2_pid=-1;

GtkWidget *main_window=NULL;

/* name of the directory containing the directory used by dc_gui2 to store running bittorrent data = $HOME/.dc_gui2/bt2dc_gui2/ */
GString *bt2dc_gui2_directory=NULL;

/* this string is "$HOME/.dctc" */
GString *dctc_main_dir=NULL;
 
GString *dctc_dir;

static gboolean on_plug_delete_event(GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	on_root_notebook_delete_event(GTK_WIDGET(user_data),NULL,NULL);	/* delete the notebook */
	/* it is a bit weird but despite of the call of gtk_main_quit in the previous function */
	/* the program reachs this part of the code */
	return FALSE;
}

static gint check_ppid(gpointer data)
{
	if(getppid()!=dc_gui2_pid)		/* this process has a new parent => previous parent is dead */
	{
		gtk_main_quit();				/* only quit, don't save anything */
	}
	return TRUE;	/* don't stop periodic call */
}


/* if the environnement var EMB_WID is defined, its value is used as GdkNativeWindow for embedding the process */
int
main (int argc, char *argv[])
{
	char *path;
	GdkNativeWindow sock_id=0;
	char *t;

	dc_gui2_pid=getppid();

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
											argc, argv,
											GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
											NULL);

	path=getenv("HOME");

	t=getenv("EMB_WID");
	if(t!=NULL)
		sock_id=strtoul(t,NULL,10);

	/* bittorrent directory = $HOME/.dc_gui2/bt2dc_gui2/ */
	bt2dc_gui2_directory=g_string_new(NULL);
	g_string_sprintf(bt2dc_gui2_directory,"%s/.dc_gui2/bt2dc_gui2/",(path!=NULL)?path:".");

	dctc_main_dir=g_string_new(NULL);
	g_string_sprintf(dctc_main_dir,"%s/.dctc",(path!=NULL)?path:".");

	dctc_dir=g_string_new(NULL);
	g_string_sprintf(dctc_dir,"%s/running",dctc_main_dir->str);

   /* build a gconf engine */
   gconf_engine=gconf_client_get_default();

	/*
	 * The following code was added by Glade to create one of each component
	 * (except popup menus), just so that you see something after building
	 * the project. Delete any components that you don't want shown initially.
	 */
	main_window = create_app1 ();
	bmav4_done_clist();
	bmav4_ul_done_clist();
	gui_full_restore(main_window,NULL);
	gtk_widget_realize(main_window);

	load_all_done_lists();


	if(sock_id==0)
		gtk_widget_show(main_window);
	else
	{
		GtkWidget *root_window;
		GtkWidget *base_widget;

		/* install a watchdog to end this program if dc_gui2 disappears */
		gtk_timeout_add(1000,check_ppid,NULL);

		base_widget=get_widget_by_widget_name(main_window,"root_notebook");

		root_window=gtk_plug_new(sock_id);
		g_signal_connect((gpointer) root_window,"delete_event", G_CALLBACK(on_plug_delete_event),base_widget);

		gtk_widget_realize(root_window);

		gtk_widget_reparent(base_widget,root_window);
		gtk_widget_show(root_window);
	}

	gtk_main ();

   g_object_unref(G_OBJECT(gconf_engine));
   gconf_engine=NULL;

	return 0;
}

