#ifndef __MAIN_H__
#define __MAIN_H__

/*****************************/
/* widget of the main window */
/*****************************/
extern GtkWidget *main_window;

/* popup menu */
extern GtkWidget *dl_popup;
extern GtkWidget *ul_popup;
extern GtkWidget *q_popup;
extern GtkWidget *user_popup;
extern GtkWidget *start_dl_popup;
extern GtkWidget *gdl_popup;
extern GtkWidget *uaddr_popup;
extern GtkWidget *done_popup;

/* some useful colors */
extern GdkColor light_red, white, black, light_grey, green, light_orange;

/* this string is "$HOME/.dctc" */
extern GString *dctc_main_dir;
/**************************************************************/
/* this string contains the path to directory ~/.dctc/running */
/**************************************************************/
extern GString *dctc_dir;
extern GString *dctc_active_client_file;

extern int local_udp_socket;                  /* this socket is used to send data to DCTC UDP communication socket, it is not bind to anything */


#include "dctc_com.h"

extern DCTC_COM *current_dctc;

extern GString *last_search[2];     /* the last search is kept because if multi-hub search is enabled */
                                    /* the command(s) must be resent */
extern gint last_search_tag;        /* when a search may start a multi-hub search, this value is the tag return by gtk_timeout_add */

extern gchar **last_started_search; /* it is an array of gchar * produced by splitting the last entered search pattern */

/*********************************/
/* add a label to the blink list */
/*********************************/
void blink_on(char *label_name);

/**************************************/
/* remove a label from the blink list */
/**************************************/
void blink_off(char *label_name);

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
char *my_strcasestr(GString *pattern, char *filename);

#endif
