<?php
/**
 * Give you the possibility to put webcam shots online :)
 *
 * daCode http://www.dacode.org/
 * src/phplib/webcam.php3
 * $Id: webcam.php3,v 1.62.2.4 2002/05/15 17:27:04 jbcombes Exp $
 *
 * Depends: Config Db Html User
 *@author Fabien Penso <penso@linuxfr.org>
 */


Class Webcam {
	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * HTML rendering package
	 *@var object Html
	 */
	var  $html;
	
	/**
	 * Session handling instance
	 *@var object Session
	 */
	var $session;

	/**
	 * User instance
	 *@var object User
	 */
	var $user;

	/**
	 * Class constructor
	 */
	Function Webcam() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
		$this->user = LoadClass('User');
	}

	/**
	 * Choose randomly a webcam to display
	 *
	 *@access public
	 *@return string html of a sidebox to display
	 */
	Function get_random() {
		global $config;

		$sqlc_q = 'SELECT count(*) AS nb FROM '.$config->tables['webcam'].
			" WHERE state='1'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()." -->\n";
			return;
		}
		$row = $this->db->fetch_array();
		$this->db->free();

		if ($row['nb'] == 0) {
			$tmp = lecho("No pic yet<br />");
			$title = lecho("Webcam...");
		} else {

			if ($row['nb'] >= 2) {
				$number = mt_rand(0,($row['nb'] - 1));
			} else {
				$number = $row['nb'] - 1;
			}

			$sqlc_q = 'SELECT '.
				$config->tables['webcam'].'.comment,'.
				$config->tables['users'].'.login,'.
				$config->tables['users'].'.fname,'.
				$config->tables['users'].'.lname,'.
				$config->tables['webcam'].'.id AS id'.
				' FROM '.$config->tables['webcam'].','.
				$config->tables['users'] . ' WHERE '.
				$config->tables['webcam'].'.user_id='.
				$config->tables['users'].'.id AND '.
				$config->tables['webcam'].".state='1' ".
				$this->db->compat_limit(1,$number);
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo '<!-- SQL failed: '.$this->db->error()." -->\n";
				return;
			}
			$row = $this->db->fetch_array();
			$this->db->free();

			$tmp = '<div align="center"><a href="'.$config->basehref.
				'webcam/image.'.$config->php.'?image_id='.$row['id'].'"><img src="'.
				$config->basehref.
				'webcam/image.'.$config->php.
				'?image_id='.$row['id'].'" border="0" '.
				'width="200" alt="webcam" />'.
				'</a><br />'.
				ereg_replace('((ftp://)|(http://))(([[:alnum:]]|[[:punct:]])*)',
						'<a href="\\0"><b>[url]</b></a>',
						htmlentities($row['comment'])).
				' (';

			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= htmlentities($row['fname'])." ".htmlentities($row['lname']);
			} else {
				$tmp .= htmlentities($row['login']);
			}

			$tmp .= ") <br /></div>\n";

			if (!$this->session->is_moderator && !$this->session->is_admin) {
				$title = '<!-- WEBCAMTITLE:'.$row['id'].
						" -->Webcam...<!-- /WEBCAMTITLE -->\n";
			} else {
				$title = ' <!-- WEBCAMTITLE:'.$row['id'].
					' -->Webcam... - <a href="'.$config->basehref.
					'webcam/'.$config->webcamadminfile.
					'?webcam_id='.$row['id'].
					'" class="boxheader">'.lecho("Edit!").
					"</a><!-- /WEBCAMTITLE -->\n";
			}
		}

		return $this->html->sidebox($title,$tmp);
	}

	/**
	 * Select an image from DB and send it with header()
	 * Call header() to send image, then call exit.
	 * Call exit if DB error
	 *
	 *@access public
	 *@param int image's id
	 */
	Function view_image($image_id) {
		global $config;

		//echo 'view_image\n';
		$sqlc_q = 'SELECT image,content_type,size,name FROM '.
			$config->tables['webcam']." WHERE id='".addslashes($image_id)."'";
		if (!$this->session->is_moderator && !$this->session->is_admin) {
			$sqlc_q .= " AND state='1'";
		}
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			exit;
		}
		if ($row = $this->db->fetchLOB(array('image'))) {
			//echo $row['content_type'];
			header('Content-Type: '.stripslashes($row['content_type']));
			//header('Content-type: text/plain');
			header('Content-Length: '.stripslashes($row['size']));
			header('Content-disposition: inline; filename='.
				stripslashes($row['name']));
			echo $row['image'];
		}
		$this->db->free();
		exit;
	}

	/**
	 * Give the list of webcam waiting for moderation
	 *
	 *@access public
	 *@return string html to be displayed
	 */
	Function webcam_to_moderate() {
		global $config;
		$tmp = "";

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}

		$sqlc_q = 'SELECT id,name,size FROM '.$config->tables['webcam'].
			" WHERE state='0'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Webcam: SQL Error!")."<br />\n";
		}

		while($row=$this->db->fetch_array()) {
			$row['name'] = htmlentities(stripslashes($row['name']));
			$row['id'] = htmlentities(stripslashes($row['id']));
			$row['size'] = htmlentities(stripslashes($row['size']));
			$tmp .= '&nbsp;-&nbsp;[WEBCAM]&nbsp;<a href="'.
			$config->basehref.'webcam/'.$config->webcamadminfile.
			'?webcam_id='.$row['id'].'">'.$row['name']."</a><br />\n";

		};
		$this->db->free();

		return $tmp;
	}

	/**
	 * Display webcam and form in order to do moderation
	 *
	 *@access public
	 *@param int webcam's id 
	 *@return string html to be displayed
	 */
	Function show_webcam_to_moderate($id) {
		global $config;

		if (!ereg('^[0-9]+$',$id)) {
			return;
		}

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}

		$sqlc_q = 'SELECT id,comment FROM '.
			$config->tables['webcam']." WHERE id='".addslashes($id)."'";

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Webcam: SQL Request Failed: ").$sqlc_q."\n";
		}

		$row=$this->db->fetch_array();

		$tmp = '';
		$tmp .= '<form action="'.$config->basehref.'webcam/'.
			$config->webcamchangefile.'" method="post">';

		$tmp .= '<center><a href="'.$config->basehref.
			'webcam/image.'.$config->php.'?image_id='.$row['id'].
			'"><img src="'.$config->basehref.'webcam/image.'.$config->php.
			'?image_id='.$row['id'].'" border="0" /></a><br />';

		$tmp .= '<input type="hidden" name="table[id]" '.
			'value="'.$row['id'].'">'.htmlentities($row['comment']).'<br />'.
			'<input type="submit" value="'.lecho("Submit").'" name="table[submit]">'.
			'<input type="submit" value="'.lecho("Erase").'" name="table[submit]">'.
			'</center></form>';

		return $tmp;
	}

	/**
	 * Do the moderation : remove from DB or change state to valid
	 *
	 *@access public
	 *@param array contain field 'submit' and field 'id'
	 *@return mixed error string or nothing
	 */
	Function do_moderate($row) {
		global $config;

		if (!$this->session->is_moderator && !$this->session->is_admin) {
			return;
		}

		if ($row['submit'] == lecho("Submit")) {
			$sqlc_q = "UPDATE ". $config->tables['webcam']." SET state='1' WHERE ".
				"id='".addslashes($row['id'])."'";
		} elseif ($row['submit'] == lecho("Erase")) {
			$sqlc_q = 'DELETE FROM '. $config->tables['webcam']." WHERE id='".
			addslashes($row['id'])."'";
		} else {
			return;
		}

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Webcam: SQL Request Failed: ").$sqlc_q."\n";
		}
		return;
	}

	/**
	 * Create a form to upload an image 
	 *
	 *@access public
	 *@return string html of the form to be displayed
	 */
	Function formNewImage() {
		global $config;

		$tmp = '<form method="post" enctype="multipart/form-data" action="'.
			$config->basehref.'webcam/submit.'.$config->php.'">'.
			lecho("<b>Comments</b> is 255 caracters maximum.").'<br />'.
			'<textarea name="comment" rows="5" cols="50"></textarea><br />'.
			'<input type="file" size="50" name="image" /><br />'.
			'<input type="hidden" name="MAX_FILE_SIZE" value="2097152">'.
			'<input type="submit" name="submit" value="'.lecho("Submit").
			'" /></form>';
		return $tmp;
	}

	/**
	 * Insert an image into DB
	 * Call header() when image is recorded, then exit
	 * Call exit if DB error
	 *
	 *@access public
	 *@param array info and data about image
	 */
	Function addNewImage($row) {
		global $config;

		if (!file_exists($row['image']) || !$fd = fopen($row['image'], "rb")) {
			echo lecho("No filename. Contact webmaster<br />\n");
			exit;
		}
		$contents = fread($fd,filesize($row['image']));
		fclose($fd);
		/*
		$q = "INSERT INTO ".$config->tables['webcam'].
			" (user_id,image,comment,content_type,size,name) VALUES ('".
			addslashes($this->user->user_id)."','".
			base64_encode(addslashes($contents))."','".
			addslashes($row['comment'])."','".
			addslashes($row['image_type'])."','".
			addslashes($row['image_size'])."','".
			addslashes($row['image_name'])."')";
		*/

		$ret = $this->db->insertLob($config->tables['webcam'], 
			array('user_id' => "'". addslashes($this->user->user_id). "'",
				'image' => $contents,
				'comment' => "'". addslashes($row['comment']) ."'",
				'content_type' => "'".addslashes($row['image_type'])."'",
				'size' => "'".addslashes($row['image_size'])."'",
				'name' => "'".addslashes($row['image_name'])."'"),
			array('image')
		);

		//$ret = $this->db->query($q);
		if (!$ret) {
			echo '<!-- '.lecho("SQL Failed: ").$this->db->error()."-->\n";
			echo '<!-- '.lecho("SQL command was: ").$q." -->\n";
			exit;
		}

		header('Location: '.$config->basehref);
		exit;
	}

}

?>
